/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.handler;

import journeymap.client.Constants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.WorldNbtIDSaveHandler;
import journeymap.common.network.data.ServerPropertyType;
import journeymap.common.network.data.model.Location;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.util.JourneyMapTeleport;
import journeymap.common.util.PermissionsManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PacketHandler {
    public void handleTeleportPacket(ServerPlayerEntity player, Location location) {
        JourneyMapTeleport.instance().attemptTeleport((Entity)player, location);
    }

    public void onClientPermsRequest(ServerPlayerEntity sender) {
        PermissionsManager.getInstance().sendPermissions(sender);
    }

    public void onAdminScreenOpen(ServerPlayerEntity sender, int type, String dimension) {
        PropertiesManager pm = PropertiesManager.getInstance();
        if (PermissionsManager.getInstance().canServerAdmin(sender) || FMLLoader.getDist().isClient() || pm.getGlobalProperties().viewOnlyServerProperties.get().booleanValue()) {
            String newPayload;
            switch (ServerPropertyType.getFromType(type)) {
                case GLOBAL: {
                    newPayload = pm.getGlobalProperties().toJsonString(false);
                    break;
                }
                case DEFAULT: {
                    newPayload = pm.getDefaultDimensionProperties().toJsonString(false);
                    break;
                }
                default: {
                    newPayload = pm.getDimProperties(DimensionHelper.getWorldKeyForName(dimension)).toJsonString(false);
                }
            }
            Journeymap.getInstance().getDispatcher().sendServerAdminPacket(sender, type, newPayload, dimension);
        } else {
            sender.func_145747_a((ITextComponent)Constants.getStringTextComponent("You do not have permission to modify Journeymap's server options!"), Util.field_240973_b_);
        }
    }

    public void onServerAdminSave(ServerPlayerEntity sender, Integer type, String payload, String dimension) {
        if (PermissionsManager.getInstance().canServerAdmin(sender) || FMLLoader.getDist().isClient()) {
            switch (ServerPropertyType.getFromType(type)) {
                case GLOBAL: {
                    ((PropertiesBase)PropertiesManager.getInstance().getGlobalProperties().load(payload, false)).save();
                    PacketHandler.updatePlayers("global");
                    break;
                }
                case DEFAULT: {
                    ((PropertiesBase)PropertiesManager.getInstance().getDefaultDimensionProperties().load(payload, false)).save();
                    break;
                }
                default: {
                    DimensionProperties prop = (DimensionProperties)PropertiesManager.getInstance().getDimProperties(DimensionHelper.getWorldKeyForName(dimension)).load(payload, true);
                    prop.save();
                    if (!prop.enabled.get().booleanValue()) break;
                    PacketHandler.updatePlayers(dimension);
                }
            }
            PropertiesManager.getInstance().reloadConfigs();
        } else {
            sender.func_145747_a((ITextComponent)Constants.getStringTextComponent("You do not have permission to modify Journeymap's server options!"), Util.field_240973_b_);
        }
    }

    private static void updatePlayers(String dim) {
        for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
            if (!dim.equals(DimensionHelper.getDimKeyName((Entity)player)) && !"global".equals(dim)) continue;
            PermissionsManager.getInstance().sendPermissions(player);
        }
    }

    public void onWorldIdRequest(ServerPlayerEntity sender) {
        if (PropertiesManager.getInstance().getGlobalProperties().useWorldId.get().booleanValue()) {
            WorldNbtIDSaveHandler worldSaveHandler = new WorldNbtIDSaveHandler();
            String worldId = worldSaveHandler.getWorldID();
            Journeymap.getInstance().getDispatcher().sendWorldIdPacket(sender, worldId);
        }
    }

    public void handleBiomeRequest(ServerPlayerEntity sender, BlockPos pos) {
        Biome biome = sender.field_70170_p.func_226691_t_(pos);
        ResourceLocation biomeResource = sender.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
        Journeymap.getInstance().getDispatcher().sendBiomeResource(sender, biomeResource);
    }
}

