/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.properties.config;

import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.ConfigField;

public class FloatField
extends ConfigField<Float> {
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_INC_VAL = "inc";
    public static final String PRECISION = "precision";

    protected FloatField() {
    }

    public FloatField(Category category, String key, float minValue, float maxValue, float defaultValue) {
        this(category, key, minValue, maxValue, defaultValue, 0.1f, 2);
    }

    public FloatField(Category category, String key, float minValue, float maxValue, float defaultValue, float incrementValue, int precision) {
        this(category, key, minValue, maxValue, defaultValue, 100);
        this.setIncrementValue(incrementValue);
        this.setPrecision(precision);
    }

    public FloatField(Category category, String key, float minValue, float maxValue, float defaultValue, int sortOrder) {
        super(category, key);
        this.range(minValue, maxValue);
        this.defaultValue(Float.valueOf(defaultValue));
        this.setToDefault();
        this.sortOrder(sortOrder);
        this.setIncrementValue(0.1f);
        this.setPrecision(2);
    }

    @Override
    public Float getDefaultValue() {
        return this.getFloatAttr("default");
    }

    @Override
    public Float get() {
        return this.getFloatAttr("value");
    }

    @Override
    public boolean validate(boolean fix) {
        boolean valid = super.validate(fix);
        valid = this.require(ATTR_MIN, ATTR_MAX) && valid;
        Float value = this.get();
        if (value == null || !(value.floatValue() >= this.getMinValue()) || !(value.floatValue() <= this.getMaxValue())) {
            if (fix) {
                this.setToDefault();
            } else {
                valid = false;
            }
        }
        return valid;
    }

    private void setPrecision(int precision) {
        this.put(PRECISION, precision);
    }

    private void setIncrementValue(float value) {
        this.put(ATTR_INC_VAL, Float.valueOf(value));
    }

    public FloatField range(float min, float max) {
        this.put(ATTR_MIN, Float.valueOf(min));
        this.put(ATTR_MAX, Float.valueOf(max));
        return this;
    }

    public float getMinValue() {
        return this.getFloatAttr(ATTR_MIN).floatValue();
    }

    public float getMaxValue() {
        return this.getFloatAttr(ATTR_MAX).floatValue();
    }

    public float getIncrementValue() {
        return this.getFloatAttr(ATTR_INC_VAL).floatValue();
    }

    public int getPrecision() {
        return this.getIntegerAttr(PRECISION);
    }
}

