/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import java.util.List;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.config.ForgeConfig;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.WorldNbtIDSaveHandler;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PermissionProperties;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.fml.loading.FMLLoader;

public class PermissionsManager {
    private static PermissionsManager INSTANCE;

    public static PermissionsManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PermissionsManager();
        }
        return INSTANCE;
    }

    public void sendPermissions(ServerPlayerEntity playerEntity) {
        GlobalProperties permissions = this.getPlayerConfig(playerEntity);
        if (permissions != null) {
            Journeymap.getInstance().getDispatcher().sendClientPermissions(playerEntity, permissions.toJsonString(false), this.canServerAdmin(playerEntity));
        }
    }

    private GlobalProperties getPlayerConfig(ServerPlayerEntity player) {
        if (PropertiesManager.getInstance().getGlobalProperties().useWorldId.get().booleanValue() && (FMLLoader.getDist().isDedicatedServer() || Minecraft.func_71410_x().func_71401_C() != null && Minecraft.func_71410_x().func_71401_C().func_71344_c())) {
            WorldNbtIDSaveHandler worldSaveHandler = new WorldNbtIDSaveHandler();
            String worldId = worldSaveHandler.getWorldID();
            Journeymap.getInstance().getDispatcher().sendWorldIdPacket(player, worldId);
        }
        return this.buildPermissions(player);
    }

    public boolean canServerAdmin(ServerPlayerEntity player) {
        List admins = (List)ForgeConfig.serverAdmins.get();
        for (String admin : admins) {
            if (!player.func_110124_au().toString().equals(admin) && !player.func_200200_C_().getString().equalsIgnoreCase(admin) && !CommonConstants.debugOverride((Entity)player)) continue;
            return true;
        }
        if (Journeymap.isOp((PlayerEntity)player)) {
            return (Boolean)ForgeConfig.opAccess.get();
        }
        return false;
    }

    private boolean canTeleport(ServerPlayerEntity player) {
        RegistryKey<World> playerDim = DimensionHelper.getDimension((Entity)player);
        if (PropertiesManager.getInstance().getDimProperties(playerDim).enabled.get().booleanValue()) {
            return PropertiesManager.getInstance().getDimProperties(playerDim).teleportEnabled.get();
        }
        if (PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get().booleanValue()) {
            return true;
        }
        return Journeymap.isOp((PlayerEntity)player);
    }

    private GlobalProperties buildPermissions(ServerPlayerEntity player) {
        PermissionProperties prop = PropertiesManager.getInstance().getDimProperties((RegistryKey<World>)player.func_130014_f_().func_234923_W_());
        GlobalProperties globalProp = PropertiesManager.getInstance().getGlobalProperties();
        boolean isOp = Journeymap.isOp((PlayerEntity)player);
        if (!((DimensionProperties)prop).enabled.get().booleanValue()) {
            prop = globalProp;
        }
        GlobalProperties to = (GlobalProperties)new GlobalProperties().loadForClient(prop.toJsonString(true), true);
        to.journeymapEnabled.set(globalProp.journeymapEnabled.get() != false || isOp || CommonConstants.debugOverride((Entity)player));
        to.teleportEnabled.set(this.canTeleport(player));
        to.worldPlayerRadar.set(((ServerOption)globalProp.worldPlayerRadar.get()).enabled(isOp));
        to.radarEnabled.set(((ServerOption)prop.radarEnabled.get()).enabled(isOp));
        to.surfaceMapping.set(((ServerOption)prop.surfaceMapping.get()).enabled(isOp));
        to.topoMapping.set(((ServerOption)prop.topoMapping.get()).enabled(isOp));
        to.caveMapping.set(((ServerOption)prop.caveMapping.get()).enabled(isOp));
        return to;
    }
}

