/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.gui.window;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.client.gui.window.element.ElementHatRender;
import me.ichun.mods.hats.client.gui.window.element.ElementHatsScrollView;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.hats.sort.SortHandler;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrained;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextWrapper;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;

public class WindowSetAccessory
extends Window<WorkspaceHats> {
    @Nonnull
    private final ElementHatRender<?> parentElement;

    public WindowSetAccessory(WorkspaceHats parent, @Nonnull ElementHatRender<?> parentElement) {
        super((IWindows)parent);
        this.setBorderSize(() -> 0);
        this.disableBringToFront();
        this.disableDocking();
        this.disableDockStacking();
        this.disableUndocking();
        this.disableDrag();
        this.disableDragResize();
        this.disableTitle();
        this.isNotUnique();
        this.parentElement = parentElement;
        this.setView(new ViewSetAccessory(this));
    }

    public void setScissor() {
        this.currentView.setScissor();
    }

    public void renderBackground(MatrixStack stack) {
    }

    public int getMinWidth() {
        return this.parentElement.getMinWidth();
    }

    public int getMinHeight() {
        return this.parentElement.getMinHeight();
    }

    public static class ViewSetAccessory
    extends View<WindowSetAccessory> {
        public int age;
        public float renderTick = 0.0f;
        public float lastProg = 0.0f;
        public Window<?> windowDummy;
        public ElementHatsScrollView list;
        public HashSet<String> conflicts = new HashSet();
        public ArrayList<HatsSavedData.HatPart> hatParts;

        public ViewSetAccessory(@Nonnull WindowSetAccessory parent) {
            super((Window)parent, "hats.gui.window.hat.personaliser");
            int padding = 0;
            this.hatParts = new ArrayList<HatsSavedData.HatPart>(((WindowSetAccessory)parent).parentElement.hatLevel.hatParts);
            SortHandler.sort(Hats.configClient.filterSorters, this.hatParts, true);
            int maxHeight = ((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.height - (Integer)((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.borderSize.get() * 2 - 12;
            int idealHeight = this.hatParts.size() * 73 + 3;
            ElementScrollBar sv = null;
            if (idealHeight > maxHeight) {
                sv = new ElementScrollBar((Fragment)this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
                sv.constraints().top((IConstrainable)this, Constraint.Property.Type.TOP, padding).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding).right((IConstrainable)this, Constraint.Property.Type.RIGHT, padding);
                this.elements.add(sv);
            }
            this.list = new ElementHatsScrollView((Fragment)this);
            this.list.constraints().top((IConstrainable)this, Constraint.Property.Type.TOP, padding + 1).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding + 1).left((IConstrainable)this, Constraint.Property.Type.LEFT, padding + 1).right((IConstrainable)this, Constraint.Property.Type.RIGHT, padding + 1);
            if (sv != null) {
                this.list.setScrollVertical(sv);
                this.list.constraints().right((IConstrainable)sv, Constraint.Property.Type.LEFT, 3);
            }
            this.elements.add(this.list);
            for (int i = 0; i < this.hatParts.size(); ++i) {
                HatsSavedData.HatPart level = this.hatParts.get(i);
                boolean isShowing = level.isShowing;
                HatInfo info = HatResourceHandler.getInfo(((WindowSetAccessory)parent).parentElement.hatOrigin);
                HatInfo accessoryInfo = null;
                if (info != null && (accessoryInfo = info.getInfoFor(level.name)) != null && isShowing) {
                    this.conflicts.addAll(accessoryInfo.accessoryLayer);
                }
                HatInfo accessoryInfoFinal = accessoryInfo;
                ElementHatRender hat = new ElementHatRender<ElementHatRender<?>>((Fragment)this.list, ((WindowSetAccessory)parent).parentElement.hatOrigin, level, btn -> {
                    if (btn.hatLevel.isNew) {
                        btn.hatLevel.isNew = false;
                    }
                    btn.hatLevel.isShowing = btn.toggleState;
                    ((WorkspaceHats)parent.parent).setNewHat(btn.hatOrigin.setModifier(btn.hatLevel), true);
                    if (accessoryInfoFinal != null && !accessoryInfoFinal.accessoryLayer.isEmpty()) {
                        if (btn.toggleState) {
                            this.conflicts.addAll(accessoryInfoFinal.accessoryLayer);
                        } else {
                            this.conflicts.removeAll(accessoryInfoFinal.accessoryLayer);
                        }
                        this.updateConflicts();
                    }
                }){

                    @Override
                    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
                        boolean isShowing = this.hatLevel.isShowing;
                        this.hatLevel.isShowing = true;
                        super.func_230430_a_(stack, mouseX, mouseY, partialTick);
                        this.hatLevel.isShowing = isShowing;
                    }

                    @Override
                    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
                        this.func_231037_b__(false);
                        boolean flag = this.func_241217_q_() != null && this.func_241217_q_().func_231048_c_(mouseX, mouseY, button);
                        this.parentFragment.func_231035_a_(null);
                        if (!this.disabled && !this.hasConflict && this.func_231047_b_(mouseX, mouseY)) {
                            if (button == 0 || button == 1 && !this.toggleState) {
                                this.trigger();
                            }
                            if (button == 1 || this.isOverHamburger(mouseX, mouseY)) {
                                if (this.renderMinecraftStyle() > 0) {
                                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                                }
                                this.spawnOptionsButtons();
                            }
                        }
                        return flag;
                    }

                    @Override
                    public void onClickRelease() {
                        this.toggleState = !this.toggleState;
                    }
                };
                hat.setToggled(isShowing);
                hat.setSize(50, 70);
                this.list.addElement((Element<?>)hat);
            }
            if (this.list.elements.isEmpty()) {
                ElementTextWrapper text = new ElementTextWrapper((Fragment)this){

                    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
                        stack.func_227860_a_();
                        stack.func_227861_a_(0.0, 0.0, 375.0);
                        super.func_230430_a_(stack, mouseX, mouseY, partialTick);
                        stack.func_227865_b_();
                    }
                };
                text.setConstraint(Constraint.matchParent((IConstrained)text, (IConstrainable)this, (int)3));
                text.setText(I18n.func_135052_a((String)"hats.gui.window.hat.noHat", (Object[])new Object[0]));
                this.elements.add(text);
            }
            this.updateConflicts();
        }

        public void updateConflicts() {
            for (Element<?> element : this.list.elements) {
                HatInfo accessoryInfo;
                HatInfo info;
                ElementHatRender hat = (ElementHatRender)element;
                if (hat.toggleState || (info = HatResourceHandler.getInfo(hat.hatOrigin.createCopy().setModifier(hat.hatLevel))) == null || (accessoryInfo = info.getInfoFor(hat.hatLevel.name)) == null) continue;
                boolean hasConflict = false;
                for (String s : accessoryInfo.accessoryLayer) {
                    if (!this.conflicts.contains(s)) continue;
                    hasConflict = true;
                    break;
                }
                hat.hasConflict = hasConflict;
            }
        }

        public void init() {
            super.init();
            if (this.windowDummy == null) {
                this.windowDummy = new Window<IWindows>(((WindowSetAccessory)this.parentFragment).parent){

                    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
                    }
                };
                this.windowDummy.disableBringToFront();
                this.windowDummy.disableDocking();
                this.windowDummy.disableDockStacking();
                this.windowDummy.disableUndocking();
                this.windowDummy.disableDrag();
                this.windowDummy.disableDragResize();
                this.windowDummy.disableTitle();
                this.windowDummy.isNotUnique();
                ((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).addWindow(this.windowDummy);
                this.windowDummy.init();
            }
        }

        public void onClose() {
            super.onClose();
            if (this.windowDummy != null) {
                ((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).removeWindow(this.windowDummy);
            }
        }

        public void tick() {
            super.tick();
            ++this.age;
        }

        public void renderBackground(MatrixStack stack) {
            float prog = 1.0f;
            if (this.age <= Hats.configClient.guiAnimationTime) {
                prog = (float)Math.sin(Math.toRadians(MathHelper.func_76131_a((float)(((float)this.age + this.renderTick) / (float)Hats.configClient.guiAnimationTime), (float)0.0f, (float)1.0f) * 90.0f));
            }
            int hatsListPadding = 6;
            int singProg = (int)((float)hatsListPadding * prog);
            int doubProg = (int)((float)(hatsListPadding * 2) * prog);
            this.posX -= singProg;
            this.width += doubProg;
            this.posY -= singProg;
            this.height += doubProg;
            if (this.renderMinecraftStyle() > 0) {
                RenderSystem.enableAlphaTest();
                ViewSetAccessory.bindTexture((ResourceLocation)this.resourceTabs());
                RenderHelper.startDrawBatch();
                RenderHelper.drawBatch((MatrixStack)stack, (double)(this.getLeft() + 4), (double)(this.getTop() + 4), (double)(this.width - 8), (double)(this.height - 8), (double)0.0, (double)0.015625, (double)0.09375, (double)0.140625, (double)0.234375);
                RenderHelper.drawBatch((MatrixStack)stack, (double)this.getLeft(), (double)(this.getTop() + 4), (double)4.0, (double)(this.height - 8), (double)0.0, (double)0.0, (double)0.015625, (double)0.140625, (double)0.234375);
                RenderHelper.drawBatch((MatrixStack)stack, (double)(this.getLeft() + 4), (double)this.getTop(), (double)(this.width - 8), (double)4.0, (double)0.0, (double)0.015625, (double)0.09375, (double)0.125, (double)0.140625);
                RenderHelper.drawBatch((MatrixStack)stack, (double)(this.getRight() - 4), (double)(this.getTop() + 4), (double)4.0, (double)(this.height - 8), (double)0.0, (double)0.09375, (double)0.109375, (double)0.140625, (double)0.234375);
                RenderHelper.drawBatch((MatrixStack)stack, (double)(this.getLeft() + 4), (double)(this.getBottom() - 4), (double)(this.width - 8), (double)4.0, (double)0.0, (double)0.015625, (double)0.09375, (double)0.484375, (double)0.5);
                RenderHelper.drawBatch((MatrixStack)stack, (double)this.getLeft(), (double)this.getTop(), (double)4.0, (double)4.0, (double)0.0, (double)0.0, (double)0.015625, (double)0.125, (double)0.140625);
                RenderHelper.drawBatch((MatrixStack)stack, (double)(this.getRight() - 4), (double)this.getTop(), (double)4.0, (double)4.0, (double)0.0, (double)0.09375, (double)0.109375, (double)0.125, (double)0.140625);
                RenderHelper.drawBatch((MatrixStack)stack, (double)this.getLeft(), (double)(this.getBottom() - 4), (double)4.0, (double)4.0, (double)0.0, (double)0.0, (double)0.015625, (double)0.484375, (double)0.5);
                RenderHelper.drawBatch((MatrixStack)stack, (double)(this.getRight() - 4), (double)(this.getBottom() - 4), (double)4.0, (double)4.0, (double)0.0, (double)0.09375, (double)0.109375, (double)0.484375, (double)0.5);
                RenderHelper.endDrawBatch();
            } else {
                this.fill(stack, this.getTheme().windowBorder, 0);
                this.fill(stack, this.getTheme().windowBackground, 3);
            }
            this.height -= doubProg;
            this.posY += singProg;
            this.width -= doubProg;
            this.posX += singProg;
        }

        public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
            int hatsListPadding = 3;
            float prog = 1.0f;
            if (this.age <= Hats.configClient.guiAnimationTime) {
                prog = (float)Math.sin(Math.toRadians(MathHelper.func_76131_a((float)(((float)this.age + partialTick) / (float)Hats.configClient.guiAnimationTime), (float)0.0f, (float)1.0f) * 90.0f));
            }
            int hatViewWidth = ((WindowSetAccessory)this.parentFragment).parentElement.getWidth();
            int hatViewLeft = ((WindowSetAccessory)this.parentFragment).parentElement.getLeft();
            int targetElementX = ((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.getCurrentView().list.getLeft() + hatsListPadding;
            int hatViewTop = ((WindowSetAccessory)this.parentFragment).parentElement.getTop();
            ((WindowSetAccessory)this.parentFragment).parentElement.setLeft((int)((float)hatViewLeft + (float)(targetElementX - hatViewLeft) * prog));
            ((WindowSetAccessory)this.parentFragment).parentElement.setWidth((int)((float)((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.width + (float)(((WindowSetAccessory)this.parentFragment).parentElement.getMinWidth() - ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.width) * prog));
            ((WindowSetAccessory)this.parentFragment).parentElement.setTop(hatViewTop);
            int maxHeight = ((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.height - (Integer)((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.borderSize.get() * 4;
            int idealHeight = this.hatParts.size() * 73 + 5;
            int targetHeight = Math.min(idealHeight, maxHeight);
            int targetY = ((WindowSetAccessory)this.parentFragment).getTop();
            if (targetY + idealHeight > ((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.getBottom() - (Integer)((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.borderSize.get() * 2 && (targetY -= targetY + idealHeight - (((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.getBottom() - (Integer)((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.borderSize.get() * 2)) < ((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.getTop() + (Integer)((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.borderSize.get() * 2) {
                targetY = ((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.getTop() + (Integer)((WorkspaceHats)((WindowSetAccessory)this.parentFragment).parent).windowHatsList.borderSize.get() * 2;
            }
            int targetX = ((WindowSetAccessory)this.parentFragment).parentElement.getRight() + hatsListPadding * 4;
            int targetWidth = 60 + (idealHeight > maxHeight ? 14 : 0);
            if (this.lastProg < 1.0f) {
                ((WindowSetAccessory)this.parentFragment).setTop((int)((float)((WindowSetAccessory)this.parentFragment).getTop() + (float)(targetY - ((WindowSetAccessory)this.parentFragment).getTop()) * prog));
                ((WindowSetAccessory)this.parentFragment).posX = (int)((float)((WindowSetAccessory)this.parentFragment).parentElement.getLeft() + (float)(targetX - ((WindowSetAccessory)this.parentFragment).parentElement.getLeft()) * prog);
                ((WindowSetAccessory)this.parentFragment).width = (int)((float)((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.width + (float)(targetWidth - ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.width) * prog);
                ((WindowSetAccessory)this.parentFragment).height = (int)((float)((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.height + (float)(targetHeight - ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.height) * prog);
                ((WindowSetAccessory)this.parentFragment).resize(this.getWorkspace().getMinecraft(), ((WindowSetAccessory)this.parentFragment).width, ((WindowSetAccessory)this.parentFragment).height);
            }
            this.renderTick = partialTick;
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)30.0f);
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, 0.0, 10.0);
            super.func_230430_a_(stack, mouseX, mouseY, partialTick);
            stack.func_227865_b_();
            Fragment fragment = ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.parentFragment;
            ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.parentFragment = this;
            ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.parentFragment.setScissor();
            ((WindowSetAccessory)this.parentFragment).parentElement.setLeft((int)((float)hatViewLeft + (float)(targetElementX - hatViewLeft) * prog));
            ((WindowSetAccessory)this.parentFragment).parentElement.setTop(hatViewTop);
            int bgPadding = 6;
            int singProg = (int)((float)bgPadding * prog);
            int doubProg = (int)((float)(bgPadding * 2) * prog);
            ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.posX -= singProg;
            ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.width += doubProg;
            ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.posY -= singProg;
            ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.height += doubProg;
            this.windowDummy.pos(((WindowSetAccessory)this.parentFragment).parentElement.getLeft(), ((WindowSetAccessory)this.parentFragment).parentElement.getTop());
            this.windowDummy.size(((WindowSetAccessory)this.parentFragment).parentElement.getWidth(), ((WindowSetAccessory)this.parentFragment).parentElement.getHeight());
            if (this.renderMinecraftStyle() > 0) {
                int width = ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.width;
                int height = ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.height;
                RenderSystem.enableAlphaTest();
                ViewSetAccessory.bindTexture((ResourceLocation)this.resourceTabs());
                RenderHelper.startDrawBatch();
                RenderHelper.drawBatch((MatrixStack)stack, (double)(((WindowSetAccessory)this.parentFragment).parentElement.getLeft() + 4), (double)(((WindowSetAccessory)this.parentFragment).parentElement.getTop() + 4), (double)(width - 8), (double)(height - 8), (double)0.0, (double)0.015625, (double)0.09375, (double)0.140625, (double)0.234375);
                RenderHelper.drawBatch((MatrixStack)stack, (double)((WindowSetAccessory)this.parentFragment).parentElement.getLeft(), (double)(((WindowSetAccessory)this.parentFragment).parentElement.getTop() + 4), (double)4.0, (double)(height - 8), (double)0.0, (double)0.0, (double)0.015625, (double)0.140625, (double)0.234375);
                RenderHelper.drawBatch((MatrixStack)stack, (double)(((WindowSetAccessory)this.parentFragment).parentElement.getLeft() + 4), (double)((WindowSetAccessory)this.parentFragment).parentElement.getTop(), (double)(width - 8), (double)4.0, (double)0.0, (double)0.015625, (double)0.09375, (double)0.125, (double)0.140625);
                RenderHelper.drawBatch((MatrixStack)stack, (double)(((WindowSetAccessory)this.parentFragment).parentElement.getRight() - 4), (double)(((WindowSetAccessory)this.parentFragment).parentElement.getTop() + 4), (double)4.0, (double)(height - 8), (double)0.0, (double)0.09375, (double)0.109375, (double)0.140625, (double)0.234375);
                RenderHelper.drawBatch((MatrixStack)stack, (double)(((WindowSetAccessory)this.parentFragment).parentElement.getLeft() + 4), (double)(((WindowSetAccessory)this.parentFragment).parentElement.getBottom() - 4), (double)(width - 8), (double)4.0, (double)0.0, (double)0.015625, (double)0.09375, (double)0.484375, (double)0.5);
                RenderHelper.drawBatch((MatrixStack)stack, (double)((WindowSetAccessory)this.parentFragment).parentElement.getLeft(), (double)((WindowSetAccessory)this.parentFragment).parentElement.getTop(), (double)4.0, (double)4.0, (double)0.0, (double)0.0, (double)0.015625, (double)0.125, (double)0.140625);
                RenderHelper.drawBatch((MatrixStack)stack, (double)(((WindowSetAccessory)this.parentFragment).parentElement.getRight() - 4), (double)((WindowSetAccessory)this.parentFragment).parentElement.getTop(), (double)4.0, (double)4.0, (double)0.0, (double)0.09375, (double)0.109375, (double)0.125, (double)0.140625);
                RenderHelper.drawBatch((MatrixStack)stack, (double)((WindowSetAccessory)this.parentFragment).parentElement.getLeft(), (double)(((WindowSetAccessory)this.parentFragment).parentElement.getBottom() - 4), (double)4.0, (double)4.0, (double)0.0, (double)0.0, (double)0.015625, (double)0.484375, (double)0.5);
                RenderHelper.drawBatch((MatrixStack)stack, (double)(((WindowSetAccessory)this.parentFragment).parentElement.getRight() - 4), (double)(((WindowSetAccessory)this.parentFragment).parentElement.getBottom() - 4), (double)4.0, (double)4.0, (double)0.0, (double)0.09375, (double)0.109375, (double)0.484375, (double)0.5);
                RenderHelper.endDrawBatch();
            } else {
                ((WindowSetAccessory)this.parentFragment).parentElement.fill(stack, this.getTheme().windowBorder, 0);
                ((WindowSetAccessory)this.parentFragment).parentElement.fill(stack, this.getTheme().windowBackground, 3);
            }
            ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.height -= doubProg;
            ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.posY += singProg;
            ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.width -= doubProg;
            ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.posX += singProg;
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)20.0f);
            ((WindowSetAccessory)this.parentFragment).parentElement.func_230430_a_(stack, mouseX, mouseY, partialTick);
            ((WindowSetAccessory)((WindowSetAccessory)this.parentFragment)).parentElement.parentFragment = fragment;
            ((WindowSetAccessory)this.parentFragment).parentElement.setWidth(hatViewWidth);
            ((WindowSetAccessory)this.parentFragment).parentElement.setLeft(hatViewLeft);
            ((WindowSetAccessory)this.parentFragment).parentElement.setTop(hatViewTop);
            this.resetScissorToParent();
            this.lastProg = prog;
        }

        public void setScissor() {
            int hatRend = 71;
            RenderHelper.startGlScissor((int)(this.getLeft() - hatRend), (int)(this.getTop() - 6 - 70), (int)(this.width + hatRend + 6), (int)(this.height + 12 + 140));
        }

        public int getMinWidth() {
            return ((WindowSetAccessory)this.parentFragment).getMinWidth();
        }

        public int getMinHeight() {
            return ((WindowSetAccessory)this.parentFragment).getMinHeight();
        }
    }
}

