/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.goose;

import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.untitledduckmod.ModEntityTypes;
import net.untitledduckmod.ModItems;
import net.untitledduckmod.ModSoundEvents;
import net.untitledduckmod.duck.DuckSwimGoal;
import net.untitledduckmod.goose.GooseCleanGoal;
import net.untitledduckmod.goose.GooseEatGoal;
import net.untitledduckmod.goose.GooseEscapeDangerGoal;
import net.untitledduckmod.goose.GooseIntimidateMobsGoal;
import net.untitledduckmod.goose.GooseMeleeAttackGoal;
import net.untitledduckmod.goose.GoosePickupFoodGoal;
import net.untitledduckmod.goose.GooseRevengeGoal;
import net.untitledduckmod.goose.GooseStealItemGoal;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.ParticleKeyFrameEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class GooseEntity
extends TameableEntity
implements IAnimatable,
IAngerable,
AnimationController.IParticleListener {
    public static final String EGG_LAY_TIME_TAG = "gooseEggLayTime";
    public static final String VARIANT_TAG = "gooseVariant";
    public static final float SWIM_SPEED_MULTIPLIER = 3.0f;
    protected static final DataParameter<Byte> VARIANT = EntityDataManager.func_187226_a(TameableEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> ANIMATION = EntityDataManager.func_187226_a(TameableEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> ANGER_TIME = EntityDataManager.func_187226_a(TameableEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final RangedInteger ANGER_TIME_RANGE = new RangedInteger(20, 39);
    private UUID targetUuid;
    public static final byte ANIMATION_IDLE = 0;
    public static final byte ANIMATION_CLEAN = 1;
    public static final byte ANIMATION_BITE = 2;
    public static final int ANIMATION_BITE_LEN = 22;
    public static final byte ANIMATION_DANCE = 3;
    public static final byte ANIMATION_PANIC = 4;
    public static final byte ANIMATION_EAT = 5;
    public static final byte ANIMATION_INTIMIDATE = 6;
    private static final AnimationBuilder WALK_ANIM = new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true));
    private static final AnimationBuilder IDLE_ANIM = new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true));
    private static final AnimationBuilder SWIM_ANIM = new AnimationBuilder().addAnimation("swim", Boolean.valueOf(true));
    private static final AnimationBuilder SWIM_IDLE_ANIM = new AnimationBuilder().addAnimation("idle_swim", Boolean.valueOf(true));
    private static final AnimationBuilder PANIC_ANIM = new AnimationBuilder().addAnimation("panic", Boolean.valueOf(true));
    private static final AnimationBuilder FLY_ANIM = new AnimationBuilder().addAnimation("fly", Boolean.valueOf(true));
    private static final AnimationBuilder CLEAN_ANIM = new AnimationBuilder().addAnimation("clean");
    private static final AnimationBuilder EAT_ANIM = new AnimationBuilder().addAnimation("eat", Boolean.valueOf(true));
    private static final AnimationBuilder INTIMIDATE_ANIM = new AnimationBuilder().addAnimation("intimidate", Boolean.valueOf(true));
    private static final AnimationBuilder HONK_ANIM = new AnimationBuilder().addAnimation("honk", Boolean.valueOf(true));
    private static final AnimationBuilder BITE_ANIM = new AnimationBuilder().addAnimation("bite", Boolean.valueOf(true));
    private static final AnimationBuilder SIT_ANIM = new AnimationBuilder().addAnimation("sit", Boolean.valueOf(true));
    private static final AnimationBuilder CHARGE_ANIM = new AnimationBuilder().addAnimation("charge", Boolean.valueOf(true));
    public static final Ingredient FOOD = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU, Items.field_222066_kO, Items.field_221600_aB});
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    private static final Ingredient TAMING_INGREDIENT = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222066_kO, Items.field_221600_aB});
    private static final int MIN_EGG_LAY_TIME = 6000;
    private static final int MAX_EGG_LAY_TIME = 12000;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private int eggLayTime = this.field_70146_Z.nextInt(6000) + 6000;
    private boolean isFlapping;
    private boolean wasSongPlaying = false;
    private boolean panicked = false;
    private int animationTimer = 0;

    public GooseEntity(EntityType<? extends TameableEntity> entityType, World world) {
        super(entityType, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_98053_h(true);
    }

    public static AttributeModifierMap.MutableAttribute getDefaultAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 7.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    public boolean func_225503_b_(float fallDistance, float damageMultiplier) {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        byte variant = (byte)this.field_70146_Z.nextInt(2);
        this.field_70180_af.func_187214_a(VARIANT, (Object)variant);
        this.field_70180_af.func_187214_a(ANIMATION, (Object)0);
        this.field_70180_af.func_187214_a(ANGER_TIME, (Object)0);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74774_a(VARIANT_TAG, this.getVariant());
        tag.func_74768_a(EGG_LAY_TIME_TAG, this.eggLayTime);
        this.func_233682_c_(tag);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setVariant(tag.func_74771_c(VARIANT_TAG));
        if (tag.func_74764_b(EGG_LAY_TIME_TAG)) {
            this.eggLayTime = tag.func_74762_e(EGG_LAY_TIME_TAG);
        }
        this.func_241358_a_((ServerWorld)this.field_70170_p, tag);
    }

    public byte getVariant() {
        return (Byte)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(byte variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public byte getAnimation() {
        return (Byte)this.field_70180_af.func_187225_a(ANIMATION);
    }

    public void setAnimation(byte animation) {
        this.field_70180_af.func_187227_b(ANIMATION, (Object)animation);
    }

    public void func_191987_a(BlockPos songPosition, boolean playing) {
        if (playing && !this.wasSongPlaying) {
            this.setAnimation((byte)3);
            this.wasSongPlaying = true;
        } else if (!playing && this.wasSongPlaying) {
            this.setAnimation((byte)0);
            this.wasSongPlaying = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte status) {
        if (status == 100) {
            BasicParticleType particleEffect = ParticleTypes.field_197632_y;
            for (int i = 0; i < 7; ++i) {
                double d = this.field_70146_Z.nextGaussian() * 0.02;
                double e = this.field_70146_Z.nextGaussian() * 0.02;
                double f = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)particleEffect, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d, e, f);
            }
        }
        super.func_70103_a(status);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new DuckSwimGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new GooseEscapeDangerGoal((CreatureEntity)this, 1.7));
        this.field_70714_bg.func_75776_a(2, (Goal)new GooseIntimidateMobsGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new GooseEatGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new GooseStealItemGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new GoosePickupFoodGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new GooseMeleeAttackGoal(this, 1.5, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, BREEDING_INGREDIENT));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(9, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.6, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(9, (Goal)new GooseCleanGoal(this));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new GooseRevengeGoal(this).func_220794_a(new Class[0]));
    }

    public boolean func_70877_b(ItemStack stack) {
        return !this.isAngry() && BREEDING_INGREDIENT.test(stack);
    }

    protected void func_184606_a_(ItemStack stack) {
        ItemEntity ie;
        UUID thrower;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Entity holder = stack.func_234694_A_();
        if (this.isAngry() && holder instanceof ItemEntity && (thrower = (ie = (ItemEntity)holder).func_200214_m()) != null) {
            this.func_241356_K__();
        }
        super.func_184606_a_(stack);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70089_S() && !this.func_70631_g_() && --this.eggLayTime <= 0) {
                this.func_184185_a(ModSoundEvents.getGooseEggSound(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_199703_a((IItemProvider)ModItems.getGooseEgg());
                this.eggLayTime = this.field_70146_Z.nextInt(6000) + 6000;
            }
            Vector3d velocity = this.func_213322_ci();
            if (!this.field_70122_E && velocity.field_72448_b < 0.0) {
                this.func_213317_d(velocity.func_216372_d(1.0, 0.6, 1.0));
            }
            if (!this.panicked && (this.func_110143_aJ() < this.func_110138_aP() / 2.0f || this.func_70631_g_()) && (this.func_70643_av() != null || this.func_70027_ad())) {
                this.setAnimation((byte)4);
                this.panicked = true;
            } else if (this.panicked && this.func_70643_av() == null && !this.func_70027_ad()) {
                this.setAnimation((byte)0);
                this.panicked = false;
            }
            if (this.animationTimer > 0) {
                --this.animationTimer;
                if (this.animationTimer == 0) {
                    this.setAnimation((byte)0);
                }
            }
        }
        this.isFlapping = this.field_70170_p.field_72995_K && !this.func_70090_H() && !this.field_70122_E;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (this.field_70170_p.field_72995_K) {
            boolean tamable = this.func_152114_e((LivingEntity)player) || this.func_70909_n() || TAMING_INGREDIENT.test(itemStack) && !this.func_70909_n() && !this.func_233678_J__();
            return tamable ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        if (this.func_70909_n()) {
            ActionResultType actionResult = super.func_230254_b_(player, hand);
            if ((!actionResult.func_226246_a_() || this.func_70631_g_()) && this.func_152114_e((LivingEntity)player)) {
                this.func_233687_w_(!this.func_233685_eM_());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                return ActionResultType.SUCCESS;
            }
            return super.func_230254_b_(player, hand);
        }
        if (this.isAngry()) {
            if (FOOD.test(itemStack)) {
                ItemStack newStack = itemStack.func_77946_l();
                newStack.func_190920_e(1);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
                if (this.func_233665_g_(newStack)) {
                    this.func_241356_K__();
                }
            }
            return ActionResultType.CONSUME;
        }
        if (TAMING_INGREDIENT.test(itemStack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    private boolean isAngry() {
        return this.func_70638_az() != null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.func_233687_w_(false);
        return super.func_70097_a(source, amount);
    }

    protected void func_175445_a(ItemEntity item) {
        if (this.func_70631_g_()) {
            return;
        }
        if (item.func_200214_m() == this.func_110124_au()) {
            return;
        }
        super.func_175445_a(item);
    }

    public void func_241356_K__() {
        this.func_70604_c(null);
        this.func_230259_a_(null);
        this.func_70624_b(null);
        this.func_230260_a__(0);
        this.field_70170_p.func_72960_a((Entity)this, (byte)100);
    }

    public boolean func_233665_g_(ItemStack equipment) {
        EquipmentSlotType equipmentSlot = EquipmentSlotType.MAINHAND;
        ItemStack itemStack = this.func_184614_ca();
        if (FOOD.test(equipment) || this.func_175448_a(equipment)) {
            ItemEntity itemEntity;
            if (!itemStack.func_190926_b() && (itemEntity = this.func_199701_a_(itemStack)) != null) {
                itemEntity.func_174867_a(60);
            }
            this.func_233657_b_(equipmentSlot, equipment);
            this.func_184606_a_(equipment);
            return true;
        }
        return false;
    }

    public boolean func_175448_a(ItemStack stack) {
        ItemStack mainHandStack = this.func_184614_ca();
        if (!FOOD.test(mainHandStack) && FOOD.test(stack)) {
            return true;
        }
        if (mainHandStack.func_190926_b()) {
            return stack.func_77973_b() != ModItems.getGooseEgg();
        }
        return false;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity entity) {
        return (AgeableEntity)ModEntityTypes.getGoose().func_200721_a((World)world);
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate);
        controller.registerParticleListener((AnimationController.IParticleListener)this);
        data.addAnimationController(controller);
    }

    public boolean lookingAround() {
        return this.getAnimation() != 1 || this.getAnimation() != 5;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean inWater = this.func_70090_H();
        AnimationController controller = event.getController();
        if (this.isFlapping) {
            controller.setAnimation(FLY_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.func_233684_eK_()) {
            controller.setAnimation(SIT_ANIM);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 2: {
                controller.setAnimation(BITE_ANIM);
                this.animationTimer = 22;
                break;
            }
            case 6: {
                controller.setAnimation(INTIMIDATE_ANIM);
                break;
            }
            case 5: {
                controller.setAnimation(EAT_ANIM);
                break;
            }
            case 1: {
                controller.setAnimation(inWater ? SWIM_ANIM : CLEAN_ANIM);
                break;
            }
            case 3: {
                controller.setAnimation(HONK_ANIM);
                break;
            }
            case 4: {
                controller.setAnimation(PANIC_ANIM);
                break;
            }
            default: {
                if (inWater) {
                    controller.setAnimation(isMoving ? SWIM_ANIM : SWIM_IDLE_ANIM);
                    break;
                }
                if (this.func_213398_dR()) {
                    controller.setAnimation(CHARGE_ANIM);
                    return PlayState.CONTINUE;
                }
                controller.setAnimation(isMoving ? WALK_ANIM : IDLE_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void tryEating() {
        assert (!this.field_70170_p.func_201670_d());
        ItemStack stack = this.func_184614_ca();
        stack.func_190918_g(1);
        this.func_184185_a(this.func_213353_d(stack), 0.5f + 0.5f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        if (stack.func_190926_b()) {
            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
        }
        if (this.isHungry()) {
            this.func_70691_i(0.5f);
        }
    }

    public void func_70642_aH() {
        if (this.func_70631_g_()) {
            this.func_184185_a(ModSoundEvents.getDucklingAmbientSound(), 0.3f, this.func_70647_i());
            return;
        }
        if (this.func_233678_J__()) {
            this.func_184185_a(ModSoundEvents.getGooseHonkSound(), 0.6f, this.func_70647_i());
        }
    }

    @Nullable
    public ItemEntity func_70099_a(ItemStack stack, float yOffset) {
        ItemEntity droppedStack = super.func_70099_a(stack, yOffset);
        if (droppedStack == null) {
            return null;
        }
        droppedStack.func_200216_c(this.func_110124_au());
        return droppedStack;
    }

    protected void func_184581_c(DamageSource source) {
        if (this.func_70631_g_()) {
            this.func_184185_a(ModSoundEvents.getGoslingHurtSound(), 0.3f, this.func_70647_i() + 0.25f);
            return;
        }
        this.func_184185_a(ModSoundEvents.getGooseHonkSound(), 0.7f, this.func_70647_i());
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        if (this.func_70631_g_()) {
            return ModSoundEvents.getGoslingDeathSound();
        }
        return ModSoundEvents.getGooseDeathSound();
    }

    protected void func_180429_a(BlockPos pos, BlockState state) {
        this.func_184185_a(ModSoundEvents.getDuckStepSound(), 0.15f, 1.0f);
    }

    protected void func_180466_bG(ITag<Fluid> fluid) {
        if (this.func_70661_as().func_212238_t()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)0.04f, 0.0));
        } else {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.3, 0.0));
        }
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER_TIME);
    }

    public void func_230260_a__(int ticks) {
        this.field_70180_af.func_187227_b(ANGER_TIME, (Object)ticks);
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.targetUuid;
    }

    public void func_230259_a_(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    public void func_230258_H__() {
        this.func_230260_a__(ANGER_TIME_RANGE.func_233018_a_(this.field_70146_Z));
    }

    public <A extends IAnimatable> void summonParticle(ParticleKeyFrameEvent<A> particleKeyFrameEvent) {
        ItemStack stack = this.func_184614_ca();
        if (stack == ItemStack.field_190927_a) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            Vector3d vel = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vel = vel.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
            vel = vel.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
            Vector3d rotationVec = Vector3d.func_189986_a((float)0.0f, (float)this.field_70761_aq);
            Vector3d pos = new Vector3d(this.func_226277_ct_() + rotationVec.field_72450_a / 2.0, this.func_226280_cw_() - 0.2, this.func_226281_cx_() + rotationVec.field_72449_c / 2.0);
            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, vel.field_72450_a, vel.field_72448_b + 0.05, vel.field_72449_c);
        }
    }

    public boolean wantsToPickupItem() {
        return !this.func_233685_eM_();
    }

    public boolean isHungry() {
        return this.isAngry() || this.func_110143_aJ() <= this.func_110138_aP() - 0.5f;
    }
}

