/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStoragePart;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;
import org.cyclops.integratedterminals.part.PartTypeTerminalStorage;
import org.cyclops.integratedterminals.part.PartTypes;

public class TerminalStorageIngredientPartOpenPacket
extends PacketCodec {
    @CodecField
    private BlockPos pos;
    @CodecField
    private Direction side;
    @CodecField
    private String tabName;
    @CodecField
    private int channel;

    public TerminalStorageIngredientPartOpenPacket() {
    }

    public TerminalStorageIngredientPartOpenPacket(BlockPos pos, Direction side, String tabName, int channel) {
        this.pos = pos;
        this.side = side;
        this.tabName = tabName;
        this.channel = channel;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(World world, PlayerEntity player) {
    }

    public void actionServer(World world, ServerPlayerEntity player) {
        TerminalStorageIngredientPartOpenPacket.openServer(world, this.pos, this.side, player, this.tabName, this.channel);
    }

    public static void openServer(World world, BlockPos pos, Direction side, ServerPlayerEntity player, String tabName, int channel) {
        final ContainerTerminalStorageBase.InitTabData initData = new ContainerTerminalStorageBase.InitTabData(tabName, channel);
        PartPos partPos = PartPos.of((World)world, (BlockPos)pos, (Direction)side);
        final Triple data = PartHelpers.getContainerPartConstructionData((PartPos)partPos);
        PartTypeTerminalStorage.State state = (PartTypeTerminalStorage.State)((IPartContainer)data.getLeft()).getPartState(((PartTarget)data.getRight()).getCenter().getSide());
        final TerminalStorageState terminalStorageState = state.getPlayerStorageState((PlayerEntity)player);
        INamedContainerProvider containerProvider = new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("");
            }

            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new ContainerTerminalStoragePart(id, playerInventory, (PartTarget)data.getRight(), (PartTypeTerminalStorage)((Object)data.getMiddle()), Optional.of(initData), terminalStorageState);
            }
        };
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)containerProvider, packetBuffer -> {
            PacketCodec.write((PacketBuffer)packetBuffer, (Object)partPos);
            packetBuffer.func_180714_a(PartTypes.TERMINAL_STORAGE.getUniqueName().toString());
            packetBuffer.writeBoolean(true);
            initData.writeToPacketBuffer((PacketBuffer)packetBuffer);
            terminalStorageState.writeToPacketBuffer((PacketBuffer)packetBuffer);
        });
    }

    public static void send(BlockPos pos, Direction side, String tabName, int channel) {
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientPartOpenPacket(pos, side, tabName, channel));
    }
}

