/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.gui.ClickListHelper;
import cam72cam.immersiverailroading.gui.CraftPicker;
import cam72cam.immersiverailroading.items.ItemPlate;
import cam72cam.immersiverailroading.items.ItemRollingStock;
import cam72cam.immersiverailroading.library.CraftingType;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.PlateType;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.mod.entity.Player;
import cam72cam.mod.gui.screen.Button;
import cam72cam.mod.gui.screen.IScreen;
import cam72cam.mod.gui.screen.IScreenBuilder;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import java.util.Collections;
import java.util.List;

public class PlateRollerGUI
implements IScreen {
    private Button gaugeButton;
    private Gauge gauge;
    private Button plateButton;
    private PlateType plate;
    private Button pickerButton;
    private TileMultiblock tile;
    private ItemStack currentItem;

    public PlateRollerGUI(TileMultiblock te) {
        this.tile = te;
        this.currentItem = te.getCraftItem();
        if (this.currentItem == null || this.currentItem.isEmpty()) {
            this.currentItem = new ItemStack((CustomItem)IRItems.ITEM_PLATE, 1);
        }
        ItemPlate.Data data = new ItemPlate.Data(this.currentItem);
        this.gauge = data.gauge;
        this.plate = data.type;
    }

    private void updatePickerButton() {
        EntityRollingStockDefinition def = new ItemPlate.Data((ItemStack)this.currentItem.copy()).def;
        if (def != null) {
            this.pickerButton.setText(GuiText.SELECTOR_PLATE_BOILER.toString(def.name()));
        }
    }

    public void init(final IScreenBuilder screen) {
        this.gaugeButton = new Button(screen, -100, -24, GuiText.SELECTOR_GAUGE.toString(this.gauge)){

            public void onClick(Player.Hand hand) {
                if (!PlateRollerGUI.this.currentItem.isEmpty()) {
                    EntityRollingStockDefinition def = new ItemPlate.Data((ItemStack)((PlateRollerGUI)PlateRollerGUI.this).currentItem).def;
                    if (def != null && PlateRollerGUI.this.plate == PlateType.BOILER && Config.ConfigBalance.DesignGaugeLock) {
                        List<Gauge> validGauges = Collections.singletonList(Gauge.from(def.recommended_gauge.value()));
                        PlateRollerGUI.this.gauge = ClickListHelper.next(validGauges, PlateRollerGUI.this.gauge, hand);
                    } else {
                        PlateRollerGUI.this.gauge = ClickListHelper.next(Gauge.values(), PlateRollerGUI.this.gauge, hand);
                    }
                }
                PlateRollerGUI.this.gaugeButton.setText(GuiText.SELECTOR_GAUGE.toString(PlateRollerGUI.this.gauge));
                PlateRollerGUI.this.sendPacket();
            }
        };
        this.plateButton = new Button(screen, -100, 6, GuiText.SELECTOR_PLATE_TYPE.toString(new Object[]{this.plate})){

            public void onClick(Player.Hand hand) {
                PlateRollerGUI.this.plate = ClickListHelper.next(PlateRollerGUI.this.plate, hand);
                PlateRollerGUI.this.plateButton.setText(GuiText.SELECTOR_PLATE_TYPE.toString(new Object[]{PlateRollerGUI.this.plate}));
                PlateRollerGUI.this.pickerButton.setVisible(PlateRollerGUI.this.plate == PlateType.BOILER);
                PlateRollerGUI.this.sendPacket();
            }
        };
        this.pickerButton = new Button(screen, -100, 36, GuiText.SELECTOR_PLATE_BOILER.toString("")){

            public void onClick(Player.Hand hand) {
                CraftPicker.showCraftPicker(screen, null, CraftingType.PLATE_BOILER, item -> {
                    if (item != null) {
                        ItemRollingStock.Data rs = new ItemRollingStock.Data((ItemStack)item);
                        ItemPlate.Data data = new ItemPlate.Data(PlateRollerGUI.this.currentItem);
                        data.def = rs.def;
                        EntityRollingStockDefinition def = rs.def;
                        if (def != null && !PlateRollerGUI.this.gauge.isModel() && PlateRollerGUI.this.gauge.value() != def.recommended_gauge.value()) {
                            PlateRollerGUI.this.gauge = def.recommended_gauge;
                            PlateRollerGUI.this.gaugeButton.setText(GuiText.SELECTOR_GAUGE.toString(PlateRollerGUI.this.gauge));
                        }
                        data.write();
                        PlateRollerGUI.this.updatePickerButton();
                        PlateRollerGUI.this.sendPacket();
                    }
                });
            }
        };
        this.pickerButton.setVisible(this.plate == PlateType.BOILER);
        this.updatePickerButton();
    }

    public void onEnterKey(IScreenBuilder builder) {
        this.sendPacket();
        builder.close();
    }

    public void onClose() {
        this.sendPacket();
    }

    public void draw(IScreenBuilder builder) {
    }

    private void sendPacket() {
        ItemPlate.Data data = new ItemPlate.Data(this.currentItem);
        data.gauge = this.gauge;
        data.type = this.plate;
        data.write();
        switch (this.plate) {
            case BOILER: {
                this.currentItem.setCount(1);
                break;
            }
            case LARGE: {
                this.currentItem.setCount(1);
                break;
            }
            case MEDIUM: {
                this.currentItem.setCount(4);
                break;
            }
            case SMALL: {
                this.currentItem.setCount(8);
                break;
            }
        }
        this.currentItem.setCount(Math.max(1, (int)Math.floor((double)this.currentItem.getCount() / this.gauge.scale())));
        this.tile.setCraftItem(this.currentItem);
    }
}

