/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.library.Augment;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CreativeTab;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.text.TextUtil;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ItemRailAugment
extends CustomItem {
    public ItemRailAugment() {
        super("immersiverailroading", "item_augment");
    }

    public int getStackSize() {
        return 16;
    }

    public List<CreativeTab> getCreativeTabs() {
        return Collections.singletonList(ItemTabs.MAIN_TAB);
    }

    public ClickResult onClickBlock(Player player, World world, Vec3i pos, Player.Hand hand, Facing facing, Vec3d hit) {
        TileRailBase te;
        if (BlockUtil.isIRRail(world, pos) && (te = (TileRailBase)world.getBlockEntity(pos, TileRailBase.class)) != null) {
            ItemStack stack = player.getHeldItem(hand);
            Data data = new Data(stack);
            if (te.getAugment() == null && (player.isCreative() || Gauge.from(te.getTrackGauge()) == data.gauge)) {
                TileRail parent = te.getParentTile();
                if (parent == null) {
                    return ClickResult.REJECTED;
                }
                switch (data.augment) {
                    case WATER_TROUGH: {
                        return ClickResult.REJECTED;
                    }
                    case SPEED_RETARDER: {
                        switch (parent.info.settings.type) {
                            case SWITCH: 
                            case TURN: {
                                return ClickResult.REJECTED;
                            }
                        }
                    }
                }
                if (world.isServer) {
                    te.setAugment(data.augment);
                    if (!player.isCreative()) {
                        stack.setCount(stack.getCount() - 1);
                    }
                }
                return ClickResult.ACCEPTED;
            }
        }
        return ClickResult.PASS;
    }

    public List<ItemStack> getItemVariants(CreativeTab tab) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tab == null || tab.equals((Object)ItemTabs.MAIN_TAB)) {
            for (Augment augment : Augment.values()) {
                if (augment == Augment.WATER_TROUGH) continue;
                ItemStack stack = new ItemStack((CustomItem)this, 1);
                Data data = new Data(stack);
                data.augment = augment;
                data.write();
                items.add(stack);
            }
        }
        return items;
    }

    public List<String> getTooltip(ItemStack stack) {
        return Collections.singletonList(GuiText.GAUGE_TOOLTIP.toString(new Data((ItemStack)stack).gauge));
    }

    public String getCustomName(ItemStack stack) {
        return TextUtil.translate((String)("item.immersiverailroading:item_augment." + new Data((ItemStack)stack).augment.name() + ".name"));
    }

    public static class Data
    extends CustomItem.ItemDataSerializer {
        @TagField(value="gauge")
        public Gauge gauge;
        @TagField(value="augment")
        public Augment augment;

        public Data(ItemStack stack) {
            super(stack);
            if (this.gauge == null) {
                this.gauge = Gauge.from(1.435);
            }
            if (this.augment == null) {
                this.augment = Augment.SPEED_RETARDER;
            }
        }
    }
}

