/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.items.BaseItemRollingStock;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.library.CraftingType;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.ItemComponentType;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CreativeTab;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.text.TextColor;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class ItemRollingStockComponent
extends BaseItemRollingStock {
    public ItemRollingStockComponent() {
        super("immersiverailroading", "item_rolling_stock_component");
    }

    public int getStackSize() {
        return 64;
    }

    public List<CreativeTab> getCreativeTabs() {
        return Collections.singletonList(ItemTabs.COMPONENT_TAB);
    }

    @Override
    public String getCustomName(ItemStack stack) {
        return super.getCustomName(stack) + " " + new Data((ItemStack)stack).componentType.toString();
    }

    public List<ItemStack> getItemVariants(CreativeTab tab) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tab == null || tab.equals((Object)ItemTabs.COMPONENT_TAB)) {
            for (EntityRollingStockDefinition def : DefinitionManager.getDefinitions()) {
                for (ItemComponentType item : new LinkedHashSet<ItemComponentType>(def.getItemComponents())) {
                    ItemStack stack = new ItemStack((CustomItem)this, 1);
                    Data data = new Data(stack);
                    data.def = def;
                    data.gauge = def.recommended_gauge;
                    data.componentType = item;
                    data.write();
                    items.add(stack);
                }
            }
        }
        return items;
    }

    public List<String> getTooltip(ItemStack stack) {
        ArrayList<String> tooltip = new ArrayList<String>();
        Data data = new Data(stack);
        tooltip.add(GuiText.GAUGE_TOOLTIP.toString(data.gauge));
        if (data.requiresHammering()) {
            tooltip.add(TextColor.RED.wrap(GuiText.RAW_CAST_TOOLTIP.toString()));
        }
        return tooltip;
    }

    public ClickResult onClickBlock(Player player, World world, Vec3i pos, Player.Hand hand, Facing facing, Vec3d hit) {
        if (new Data((ItemStack)player.getHeldItem((Player.Hand)hand)).componentType != ItemComponentType.FRAME) {
            return ClickResult.REJECTED;
        }
        return ItemRollingStockComponent.tryPlaceStock(player, world, pos, hand, Collections.singletonList(ItemComponentType.FRAME));
    }

    public static class Data
    extends BaseItemRollingStock.Data {
        @TagField(value="componentType")
        public ItemComponentType componentType;
        @TagField(value="raw_cast")
        public boolean rawCast;

        public Data(ItemStack stack) {
            super(stack);
            if (this.componentType == null) {
                this.componentType = ItemComponentType.FRAME;
            }
        }

        public boolean requiresHammering() {
            return this.componentType.crafting == CraftingType.CASTING_HAMMER && this.rawCast;
        }
    }
}

