/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.ValveGearType;
import cam72cam.immersiverailroading.model.ComponentRenderer;
import cam72cam.immersiverailroading.model.LocomotiveModel;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.Cargo;
import cam72cam.immersiverailroading.model.part.DrivingAssembly;
import cam72cam.immersiverailroading.model.part.PartSound;
import cam72cam.immersiverailroading.model.part.PressureValve;
import cam72cam.immersiverailroading.model.part.SteamChimney;
import cam72cam.immersiverailroading.model.part.TrackFollower;
import cam72cam.immersiverailroading.model.part.Whistle;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveSteamDefinition;
import cam72cam.immersiverailroading.render.ExpireableList;
import java.util.List;
import java.util.UUID;

public class SteamLocomotiveModel
extends LocomotiveModel<LocomotiveSteam> {
    private List<ModelComponent> components;
    private DrivingAssembly drivingWheels;
    private ModelComponent frameFront;
    private ModelComponent frameRear;
    private DrivingAssembly drivingWheelsFront;
    private DrivingAssembly drivingWheelsRear;
    private Whistle whistle;
    private SteamChimney chimney;
    private PressureValve pressureValve;
    private final ExpireableList<UUID, TrackFollower> frontTrackers = new ExpireableList();
    private final ExpireableList<UUID, TrackFollower> rearTrackers = new ExpireableList();
    private final PartSound idleSounds = new PartSound(stock -> ImmersiveRailroading.newSound(def.idle, true, 40.0f, stock.soundGauge()));
    private Cargo cargoFront;
    private Cargo cargoRear;

    public SteamLocomotiveModel(LocomotiveSteamDefinition def) throws Exception {
        super(def);
    }

    @Override
    protected void parseComponents(ComponentProvider provider, EntityRollingStockDefinition def) {
        this.frameFront = provider.parse(ModelComponentType.FRONT_FRAME);
        this.cargoFront = Cargo.get(provider, "FRONT");
        this.frameRear = provider.parse(ModelComponentType.REAR_FRAME);
        this.cargoRear = Cargo.get(provider, "REAR");
        this.components = provider.parse(ModelComponentType.FIREBOX, ModelComponentType.SMOKEBOX, ModelComponentType.PIPING);
        this.components.addAll(provider.parseAll(ModelComponentType.BOILER_SEGMENT_X));
        this.whistle = Whistle.get(provider, ((LocomotiveSteamDefinition)def).quill, ((LocomotiveSteamDefinition)def).whistle);
        this.chimney = SteamChimney.get(provider);
        this.pressureValve = PressureValve.get(provider, ((LocomotiveSteamDefinition)def).pressure);
        ValveGearType type = def.getValveGear();
        this.drivingWheelsFront = DrivingAssembly.get(type, provider, "FRONT", 0.0f);
        this.drivingWheelsRear = DrivingAssembly.get(type, provider, "REAR", 45.0f);
        this.drivingWheels = DrivingAssembly.get(type, provider, null, 0.0f);
        super.parseComponents(provider, def);
    }

    @Override
    protected boolean unifiedBogies() {
        return false;
    }

    @Override
    protected void effects(LocomotiveSteam stock) {
        super.effects(stock);
        float throttle = stock.getThrottle();
        if (this.drivingWheels != null) {
            this.drivingWheels.effects(stock, throttle);
        }
        if (this.drivingWheelsFront != null) {
            this.drivingWheelsFront.effects(stock, throttle);
        }
        if (this.drivingWheelsRear != null) {
            this.drivingWheelsRear.effects(stock, throttle);
        }
        if (this.chimney != null) {
            this.chimney.effects(stock, this.drivingWheels != null && this.drivingWheels.isEndStroke(stock, throttle) || this.drivingWheelsFront != null && this.drivingWheelsFront.isEndStroke(stock, throttle) || this.drivingWheelsRear != null && this.drivingWheelsRear.isEndStroke(stock, throttle));
        }
        this.pressureValve.effects(stock, stock.isOverpressure() && Config.isFuelRequired(stock.gauge));
        this.idleSounds.effects((EntityMoveableRollingStock)stock, stock.getBoilerTemperature() > stock.ambientTemperature() + 5.0f ? 0.1f : 0.0f);
        this.whistle.effects(stock, stock.getBoilerPressure() > 0.0f || !Config.isFuelRequired(stock.gauge) ? stock.getHornTime() : 0, stock.getHornPlayer());
    }

    @Override
    protected void removed(LocomotiveSteam stock) {
        super.removed(stock);
        this.frontTrackers.put(stock.getUUID(), null);
        this.rearTrackers.put(stock.getUUID(), null);
        this.pressureValve.removed(stock);
        this.idleSounds.removed(stock);
        this.whistle.removed(stock);
    }

    @Override
    protected void render(LocomotiveSteam stock, ComponentRenderer draw, double distanceTraveled) {
        TrackFollower data2;
        Throwable throwable;
        ComponentRenderer matrix;
        super.render(stock, draw, distanceTraveled);
        draw.render(this.components);
        this.whistle.render(draw);
        if (this.drivingWheels != null) {
            this.drivingWheels.render(distanceTraveled, stock.getThrottle(), draw);
        }
        if (this.drivingWheelsFront != null) {
            matrix = draw.push();
            throwable = null;
            try {
                if (this.frameFront != null) {
                    data2 = this.frontTrackers.get(stock.getUUID());
                    if (data2 == null) {
                        data2 = new TrackFollower(this.frameFront.center);
                        this.frontTrackers.put(stock.getUUID(), data2);
                    }
                    data2.apply(stock);
                    matrix.render(this.frameFront);
                }
                this.drivingWheelsFront.render(distanceTraveled, stock.getThrottle(), matrix);
                if (this.cargoFront != null) {
                    this.cargoFront.render(stock.getPercentCargoFull(), stock.getDefinition().shouldShowCurrentLoadOnly(), matrix);
                }
            }
            catch (Throwable data2) {
                throwable = data2;
                throw data2;
            }
            finally {
                if (matrix != null) {
                    if (throwable != null) {
                        try {
                            matrix.close();
                        }
                        catch (Throwable data2) {
                            throwable.addSuppressed(data2);
                        }
                    } else {
                        matrix.close();
                    }
                }
            }
        }
        if (this.drivingWheelsRear != null) {
            matrix = draw.push();
            throwable = null;
            try {
                if (this.frameRear != null) {
                    data2 = this.rearTrackers.get(stock.getUUID());
                    if (data2 == null) {
                        data2 = new TrackFollower(this.frameRear.center);
                        this.rearTrackers.put(stock.getUUID(), data2);
                    }
                    data2.apply(stock);
                    matrix.render(this.frameRear);
                }
                this.drivingWheelsRear.render(distanceTraveled, stock.getThrottle(), matrix);
                if (this.cargoRear != null) {
                    this.cargoRear.render(stock.getPercentCargoFull(), stock.getDefinition().shouldShowCurrentLoadOnly(), matrix);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (matrix != null) {
                    if (throwable != null) {
                        try {
                            matrix.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        matrix.close();
                    }
                }
            }
        }
    }
}

