/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.Particles;
import cam72cam.immersiverailroading.model.ComponentRenderer;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.ConnectingRodValveGear;
import cam72cam.immersiverailroading.model.part.WheelSet;
import cam72cam.immersiverailroading.render.ExpireableList;
import cam72cam.immersiverailroading.render.SmokeParticle;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.sound.ISound;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.lwjgl.opengl.GL11;

public class StephensonValveGear
extends ConnectingRodValveGear {
    protected final ModelComponent drivingRod;
    protected final ModelComponent pistonRod;
    protected final ModelComponent cylinder;
    protected final boolean reverse;
    protected final Vec3d drivenWheel;
    ExpireableList<String, ChuffSound> chuffSounds = new ExpireableList<String, ChuffSound>(){

        @Override
        public void onRemove(String key, ChuffSound value) {
            value.free();
        }
    };

    public static StephensonValveGear get(WheelSet wheels, ComponentProvider provider, String pos, float angleOffset) {
        ModelComponent drivingRod = provider.parse(ModelComponentType.MAIN_ROD_SIDE, pos);
        ModelComponent connectingRod = provider.parse(ModelComponentType.SIDE_ROD_SIDE, pos);
        ModelComponent pistonRod = provider.parse(ModelComponentType.PISTON_ROD_SIDE, pos);
        ModelComponent cylinder = provider.parse(ModelComponentType.CYLINDER_SIDE, pos);
        return drivingRod != null && connectingRod != null && pistonRod != null ? new StephensonValveGear(wheels, drivingRod, connectingRod, pistonRod, cylinder, angleOffset) : null;
    }

    public StephensonValveGear(WheelSet wheels, ModelComponent drivingRod, ModelComponent connectingRod, ModelComponent pistonRod, ModelComponent cylinder, float angleOffset) {
        super(wheels, connectingRod, angleOffset);
        this.drivingRod = drivingRod;
        this.pistonRod = pistonRod;
        this.cylinder = cylinder;
        Vec3d center = ModelComponent.center(wheels.wheels.stream().map(x -> x.wheel).collect(Collectors.toList()));
        this.reverse = pistonRod.center.x > center.x;
        this.angleOffset = angleOffset + (float)(this.reverse ? -90 : 0);
        this.drivenWheel = wheels.wheels.stream().map(w -> w.wheel.center).min(Comparator.comparingDouble(w -> w.distanceTo(this.reverse ? drivingRod.min : drivingRod.max))).get();
        this.centerOfWheels = drivingRod.pos.equals("CENTER") ? this.drivenWheel : center;
    }

    protected double getStroke(EntityMoveableRollingStock stock, float throttle, int shift, boolean speedLimit) {
        double csm = Math.abs(stock.getCurrentSpeed().metric()) / stock.gauge.scale();
        if ((csm > 0.1 || throttle > 0.0f) && (csm < 20.0 || !speedLimit)) {
            float currentAngle = this.angle((double)stock.distanceTraveled / stock.gauge.scale()) + (float)shift;
            return Math.abs(Math.sin(Math.toRadians(currentAngle)));
        }
        return 0.0;
    }

    @Override
    public boolean isEndStroke(EntityMoveableRollingStock stock, float throttle) {
        return this.getStroke(stock, throttle, 0, true) > 0.97;
    }

    @Override
    public void effects(EntityMoveableRollingStock stock, float throttle) {
        if (ConfigGraphics.particlesEnabled && this.isEndStroke(stock, throttle)) {
            Vec3d particlePos = stock.getPosition().add(VecUtil.rotateWrongYaw(this.pistonRod.min.scale(stock.gauge.scale()), stock.getRotationYaw() + 180.0f));
            double accell = 0.3 * stock.gauge.scale();
            if (this.pistonRod.pos.contains("LEFT")) {
                accell = -accell;
            }
            if (this.pistonRod.pos.contains("CENTER")) {
                accell = 0.0;
            }
            Vec3d sideMotion = stock.getVelocity().add(VecUtil.fromWrongYaw(accell, stock.getRotationYaw() + 90.0f));
            Particles.SMOKE.accept(new SmokeParticle.SmokeParticleData(stock.getWorld(), particlePos, new Vec3d(sideMotion.x, sideMotion.y + 0.01 * stock.gauge.scale(), sideMotion.z), 80, 0.0f, 0.6f, 0.2 * stock.gauge.scale()));
        }
        if (ConfigSound.soundEnabled && stock instanceof LocomotiveSteam) {
            String key = String.format("%s-%s", stock.getUUID(), this.pistonRod.pos);
            ChuffSound sound = this.chuffSounds.get(key);
            if (sound == null) {
                sound = new ChuffSound((LocomotiveSteam)stock);
                this.chuffSounds.put(key, sound);
            }
            sound.update(this.getStroke(stock, throttle, -45, false) > 0.5);
        }
    }

    @Override
    public void render(double distance, float throttle, ComponentRenderer draw) {
        super.render(distance, throttle, draw);
        draw.render(this.cylinder);
        float wheelAngle = this.angle(distance);
        Vec3d connRodPos = this.connectingRod.center;
        double connRodRadius = connRodPos.x - this.centerOfWheels.x;
        Vec3d connRodMovment = VecUtil.fromWrongYaw(connRodRadius, wheelAngle);
        Vec3d drivingRodRotPoint = new Vec3d((this.reverse ? this.drivingRod.min.x : this.drivingRod.max.x) - this.drivingRod.height() / 2.0, this.drivingRod.center.y, this.reverse ? this.drivingRod.min.z : this.drivingRod.max.z);
        float drivingRodAngle = (float)Math.toDegrees(Math.atan2(this.reverse ? -connRodMovment.z : connRodMovment.z, this.drivingRod.length() - this.drivingRod.height()));
        try (ComponentRenderer matrix = draw.push();){
            GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
            GL11.glTranslated((double)connRodMovment.x, (double)connRodMovment.z, (double)0.0);
            GL11.glTranslated((double)drivingRodRotPoint.x, (double)drivingRodRotPoint.y, (double)drivingRodRotPoint.z);
            GL11.glRotated((double)drivingRodAngle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-drivingRodRotPoint.x), (double)(-drivingRodRotPoint.y), (double)(-drivingRodRotPoint.z));
            matrix.render(this.drivingRod);
        }
        double pistonDelta = connRodMovment.x - connRodRadius;
        try (ComponentRenderer matrix = draw.push();){
            GL11.glTranslated((double)pistonDelta, (double)0.0, (double)0.0);
            matrix.render(this.pistonRod);
        }
    }

    private static class ChuffSound {
        private final LocomotiveSteam stock;
        private final float pitchOffset;
        private boolean pitchStroke;
        private boolean chuffOn = false;
        private final List<ISound> chuffs = new ArrayList<ISound>();
        private int chuffId = 0;

        ChuffSound(LocomotiveSteam stock) {
            for (int i = 0; i < 6; ++i) {
                this.chuffs.add(ImmersiveRailroading.newSound(stock.getDefinition().chuff, false, 80.0f, stock.soundGauge()));
            }
            this.stock = stock;
            this.pitchOffset = (float)(Math.random() / 50.0);
            this.pitchStroke = false;
        }

        void update(boolean enteredStroke) {
            if (!this.chuffOn) {
                if (enteredStroke) {
                    this.chuffOn = true;
                    this.pitchStroke = !this.pitchStroke;
                    double speed = Math.abs(this.stock.getCurrentSpeed().minecraft());
                    double maxSpeed = Math.abs(this.stock.getDefinition().getMaxSpeed(this.stock.gauge).minecraft());
                    float volume = (float)Math.max(1.0 - speed / maxSpeed, 0.3) * Math.abs(this.stock.getThrottle());
                    volume = (float)Math.sqrt(volume);
                    double fraction = 3.0;
                    float pitch = 0.8f + (float)(speed / maxSpeed / fraction);
                    float delta = this.pitchOffset - (this.pitchStroke ? -0.02f : 0.0f);
                    ISound chuff = this.chuffs.get(this.chuffId);
                    chuff.setPitch(pitch + delta);
                    chuff.setVolume(volume + delta);
                    chuff.play(this.stock.getPosition());
                    this.chuffId = (this.chuffId + 1) % this.chuffs.size();
                }
            } else if (!enteredStroke) {
                this.chuffOn = false;
            }
            for (ISound chuff : this.chuffs) {
                if (!chuff.isPlaying()) continue;
                chuff.setPosition(this.stock.getPosition());
                chuff.setVelocity(this.stock.getVelocity());
                chuff.update();
            }
        }

        void free() {
            for (ISound chuff : this.chuffs) {
                chuff.terminate();
            }
        }
    }
}

