/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.physics.MovementTrack;
import cam72cam.immersiverailroading.thirdparty.trackapi.ITrack;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.world.World;
import org.lwjgl.opengl.GL11;

public class TrackFollower {
    private Vec3d pos;
    private final Vec3d point;
    float toPointYaw;
    float toPointPitch;
    float atPointYaw;

    public TrackFollower(Vec3d point) {
        this.point = point;
    }

    public void apply(EntityMoveableRollingStock stock) {
        Vec3d point = this.point.scale(stock.gauge.scale());
        if (!stock.getPosition().equals((Object)this.pos)) {
            Vec3d pointPos;
            this.pos = stock.getPosition();
            Vec3d startPos = VecUtil.fromWrongYaw(-point.x, stock.getRotationYaw()).add(stock.getPosition());
            if (startPos.equals((Object)(pointPos = this.nextPosition(stock.getWorld(), stock.gauge, startPos, stock.getRotationYaw(), stock.getRotationYaw(), -0.5 * stock.gauge.scale())))) {
                pointPos = this.nextPosition(stock.getWorld(), stock.gauge, this.pos, stock.getRotationYaw(), stock.getRotationYaw(), -0.5 * stock.gauge.scale() - point.x);
            }
            Vec3d pointPosNext = this.nextPosition(stock.getWorld(), stock.gauge, pointPos, stock.getRotationYaw(), stock.getRotationYaw(), 0.5 * stock.gauge.scale());
            Vec3d delta = this.pos.subtract(pointPos).scale(-point.x);
            if (pointPos.distanceTo(pointPosNext) > 0.1 * stock.gauge.scale()) {
                this.toPointYaw = VecUtil.toYaw(delta) + stock.getRotationYaw() + 180.0f;
                this.atPointYaw = VecUtil.toYaw(pointPos.subtract(pointPosNext)) + stock.getRotationYaw() - this.toPointYaw + 180.0f;
                this.toPointPitch = -VecUtil.toPitch(VecUtil.rotateYaw(delta, stock.getRotationYaw() + 180.0f)) + 90.0f + stock.getRotationPitch();
            } else {
                this.pos = null;
                this.atPointYaw = 0.0f;
            }
        }
        GL11.glRotated((double)this.toPointYaw, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)this.toPointPitch, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)point.x, (double)point.y, (double)point.z);
        GL11.glRotated((double)this.atPointYaw, (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)(-point.x), (double)(-point.y), (double)(-point.z));
    }

    public Vec3d nextPosition(World world, Gauge gauge, Vec3d currentPosition, float rotationYaw, float bogeyYaw, double distance) {
        ITrack rail = MovementTrack.findTrack(world, currentPosition, rotationYaw, gauge.value());
        if (rail == null) {
            return currentPosition;
        }
        Vec3d result = rail.getNextPosition(currentPosition, VecUtil.fromWrongYaw(distance, bogeyYaw));
        if (result == null) {
            return currentPosition;
        }
        return result;
    }
}

