/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.util;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapped;
import cam72cam.mod.serialization.TagMapper;
import cam72cam.mod.util.Facing;

@TagMapped(value=TagMapper.class)
public class PlacementInfo {
    public final Vec3d placementPosition;
    public final TrackDirection direction;
    public final float yaw;
    public final Vec3d control;

    public PlacementInfo(Vec3d placementPosition, TrackDirection direction, float yaw, Vec3d control) {
        this.placementPosition = placementPosition;
        this.direction = direction;
        this.yaw = yaw;
        this.control = control;
    }

    public static int segmentation() {
        return Math.min(32, Math.max(1, Config.ConfigBalance.AnglePlacementSegmentation));
    }

    public PlacementInfo(ItemStack stack, float yawHead, Vec3d hit) {
        yawHead = (-yawHead % 360.0f + 360.0f) % 360.0f;
        this.yaw = (float)((int)((yawHead + 90.0f / ((float)PlacementInfo.segmentation() * 2.0f)) * (float)PlacementInfo.segmentation()) / 90 * 90) / ((float)PlacementInfo.segmentation() * 1.0f);
        RailSettings settings = RailSettings.from(stack);
        TrackDirection direction = settings.direction;
        if (direction == TrackDirection.NONE) {
            direction = yawHead % 90.0f < 45.0f ? TrackDirection.RIGHT : TrackDirection.LEFT;
        }
        int quarter = this.rotationQuarter();
        double hitX = hit.x % 1.0;
        double hitZ = hit.z % 1.0;
        block0 : switch (settings.posType) {
            case FIXED: {
                hitX = 0.5;
                hitZ = 0.5;
                break;
            }
            case PIXELS: {
                hitX = (float)((int)(hitX * 16.0)) / 16.0f;
                hitZ = (float)((int)(hitZ * 16.0)) / 16.0f;
                break;
            }
            case PIXELS_LOCKED: {
                hitX = (float)((int)(hitX * 16.0)) / 16.0f;
                hitZ = (float)((int)(hitZ * 16.0)) / 16.0f;
                if (quarter != 0) break;
                switch (this.facing()) {
                    case EAST: 
                    case WEST: {
                        hitZ = 0.5;
                        break block0;
                    }
                    case NORTH: 
                    case SOUTH: {
                        hitX = 0.5;
                        break block0;
                    }
                }
                break;
            }
            case SMOOTH: {
                break;
            }
            case SMOOTH_LOCKED: {
                if (quarter != 0) break;
                switch (this.facing()) {
                    case EAST: 
                    case WEST: {
                        hitZ = 0.5;
                        break block0;
                    }
                    case NORTH: 
                    case SOUTH: {
                        hitX = 0.5;
                        break block0;
                    }
                }
            }
        }
        this.placementPosition = new Vec3d(new Vec3i(hit)).add(hitX, 0.0, hitZ);
        this.direction = direction;
        this.control = null;
    }

    @Deprecated
    public PlacementInfo(TagCompound nbt) {
        this.placementPosition = nbt.getVec3d("placementPosition");
        this.direction = TrackDirection.values()[nbt.getInteger("direction")];
        if (nbt.hasKey("yaw")) {
            this.yaw = nbt.getFloat("yaw").floatValue();
        } else {
            int rotationQuarter = nbt.getInteger("rotationQuarter");
            Facing facing = Facing.from((byte)nbt.getByte("facing"));
            float facingAngle = 180.0f - facing.getAngle();
            float rotAngle = (float)rotationQuarter / 4.0f * 90.0f;
            if (this.direction != TrackDirection.RIGHT) {
                rotAngle = -rotAngle;
            }
            this.yaw = facingAngle + rotAngle;
        }
        this.control = nbt.hasKey("control") ? nbt.getVec3d("control") : null;
    }

    public TagCompound toNBT() {
        TagCompound nbt = new TagCompound();
        nbt.setVec3d("placementPosition", this.placementPosition);
        nbt.setFloat("yaw", Float.valueOf(this.yaw));
        nbt.setInteger("direction", Integer.valueOf(this.direction.ordinal()));
        if (this.control != null) {
            nbt.setVec3d("control", this.control);
        }
        return nbt;
    }

    public Facing facing() {
        return Facing.fromAngle((float)(180.0f - this.yaw));
    }

    public int rotationQuarter() {
        return (int)(this.yaw % 90.0f * (float)PlacementInfo.segmentation() / 90.0f);
    }

    public float partialAngle() {
        return this.yaw % 90.0f;
    }

    public PlacementInfo offset(Vec3i offset) {
        return new PlacementInfo(this.placementPosition.add(offset), this.direction, this.yaw, this.control != null ? this.control.add(offset) : null);
    }

    public PlacementInfo withDirection(TrackDirection direction) {
        return new PlacementInfo(this.placementPosition, direction, this.yaw, this.control);
    }

    static class TagMapper
    implements cam72cam.mod.serialization.TagMapper<PlacementInfo> {
        TagMapper() {
        }

        public TagMapper.TagAccessor<PlacementInfo> apply(Class<PlacementInfo> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor((d, o) -> {
                if (o == null) {
                    d.remove(fieldName);
                } else {
                    d.set(fieldName, o.toNBT());
                }
            }, d -> d.hasKey(fieldName) ? new PlacementInfo(d.get(fieldName)) : null);
        }
    }
}

