/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions.vanilla;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.conditions.vanilla.Reference")
@Document(value="vanilla/api/loot/conditions/vanilla/Reference")
public final class ReferenceLootConditionTypeBuilder
implements ILootConditionTypeBuilder {
    private ResourceLocation predicateName;

    ReferenceLootConditionTypeBuilder() {
    }

    @ZenCodeType.Method
    public ReferenceLootConditionTypeBuilder withName(ResourceLocation name) {
        this.predicateName = name;
        return this;
    }

    @ZenCodeType.Method
    public ReferenceLootConditionTypeBuilder withName(String name) {
        return this.withName(new ResourceLocation(name));
    }

    @Override
    public ILootCondition finish() {
        if (this.predicateName == null) {
            throw new IllegalStateException("You must specify the predicate name that you want to be able to query in a 'Reference' loot condition");
        }
        return context -> {
            net.minecraft.loot.conditions.ILootCondition vanillaCondition = context.func_227504_b_(this.predicateName);
            if (context.func_227501_a_(vanillaCondition)) {
                try {
                    boolean bl = vanillaCondition.test((Object)context);
                    return bl;
                }
                finally {
                    context.func_227503_b_(vanillaCondition);
                }
            }
            CraftTweakerAPI.logError("Prevented infinite loop from ensuing with predicate '%s' referenced by a 'Reference' loot condition", this.predicateName);
            return false;
        };
    }
}

