/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.tag.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagAdd;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagCreate;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagRemove;
import com.blamejared.crafttweaker.impl.entity.MCEntityType;
import com.blamejared.crafttweaker.impl.helper.CraftTweakerHelper;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/tags/TagManagerEntityType")
@ZenCodeType.Name(value="crafttweaker.api.tag.TagManagerEntityType")
public class TagManagerEntityType
implements TagManager<MCEntityType> {
    public static final TagManagerEntityType INSTANCE = new TagManagerEntityType();

    private TagManagerEntityType() {
    }

    @Override
    @Nonnull
    public Class<MCEntityType> getElementClass() {
        return MCEntityType.class;
    }

    @Override
    public String getTagFolder() {
        return "entity_types";
    }

    @Override
    public List<MCTag<MCEntityType>> getAllTagsFor(MCEntityType element) {
        return this.getTagCollection().func_199913_a(element.getInternal()).stream().map(location -> new MCTag<MCEntityType>((ResourceLocation)location, this)).collect(Collectors.toList());
    }

    @Override
    public void addElements(MCTag<MCEntityType> to, List<MCEntityType> toAdd) {
        ITag<EntityType<?>> internal = this.getInternal(to);
        List<EntityType<?>> entityTypes = CraftTweakerHelper.getEntityTypes(toAdd);
        if (internal == null) {
            Tag tagFromContents = new Tag((Set)Sets.newHashSet(entityTypes), EntityType.class);
            CraftTweakerAPI.apply(new ActionTagCreate(this.getTagCollection(), (ITag<EntityType<?>>)tagFromContents, to));
        } else {
            CraftTweakerAPI.apply(new ActionTagAdd(internal, entityTypes, to));
        }
    }

    @Override
    public void removeElements(MCTag<MCEntityType> from, List<MCEntityType> toRemove) {
        ITag<EntityType<?>> internal = this.getInternal(from);
        List<EntityType<?>> entityTypes = CraftTweakerHelper.getEntityTypes(toRemove);
        CraftTweakerAPI.apply(new ActionTagRemove(internal, entityTypes, from));
    }

    @Override
    public List<MCEntityType> getElementsInTag(MCTag<MCEntityType> theTag) {
        ITag<EntityType<?>> internal = this.getInternal(theTag);
        if (internal == null) {
            return Collections.emptyList();
        }
        return internal.func_230236_b_().stream().map(MCEntityType::new).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public ITag<EntityType<?>> getInternal(MCTag<MCEntityType> theTag) {
        return (ITag)this.getTagCollection().func_241833_a().get(theTag.getIdInternal());
    }

    @Override
    public ITagCollection<EntityType<?>> getTagCollection() {
        return TagCollectionManager.func_242178_a().func_241838_d();
    }
}

