/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.tag.registry;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.util.InstantiationUtil;
import com.blamejared.crafttweaker.impl.tag.manager.TagManager;
import com.blamejared.crafttweaker.impl.tag.manager.TagManagerWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.openzen.zencode.java.ZenCodeType;

public final class CrTTagRegistryData {
    public static final CrTTagRegistryData INSTANCE = new CrTTagRegistryData();
    private final Map<String, TagManager<?>> registeredInstances = new HashMap();
    private final Map<String, TagManagerWrapper<?>> syntheticInstances = new HashMap();
    private final Map<Class<?>, TagManager<?>> tagFolderByCrTElementType = new HashMap();

    private CrTTagRegistryData() {
    }

    public void addTagImplementationClass(Class<? extends TagManager> cls) {
        TagManager manager = InstantiationUtil.getOrCreateInstance(cls);
        if (manager == null) {
            throw new IllegalArgumentException("TagManagers need to have a public static final instance field or a no-arg constructor");
        }
        CraftTweakerAPI.logDebug("Registering Native TagManager with TagFolder '%s'", manager.getTagFolder());
        this.register(manager);
    }

    private void register(TagManager<?> tagManager) {
        String tagFolder = tagManager.getTagFolder();
        if (this.getAllInstances().containsKey(tagFolder)) {
            this.handleDuplicateTagManager(tagManager, tagFolder);
            return;
        }
        if (tagManager instanceof TagManagerWrapper) {
            this.syntheticInstances.put(tagFolder, (TagManagerWrapper)tagManager);
        } else {
            this.registeredInstances.put(tagFolder, tagManager);
        }
        this.tagFolderByCrTElementType.put(tagManager.getElementClass(), tagManager);
    }

    private void handleDuplicateTagManager(TagManager<?> tagManager, String tagFolder) {
        String message = "There are two tagManagers registered for tagfolder %s! Classes are '%s' and '%s'.";
        String nameA = tagManager.getClass().getCanonicalName();
        String nameB = this.getAllInstances().get(tagFolder).getClass().getCanonicalName();
        CraftTweakerAPI.logError("There are two tagManagers registered for tagfolder %s! Classes are '%s' and '%s'.", tagFolder, nameA, nameB);
    }

    public void registerForgeTags() {
        RegistryManager registryManager = RegistryManager.ACTIVE;
        for (ResourceLocation key : ForgeTagHandler.getCustomTagTypeNames()) {
            if (registryManager.getRegistry(key) == null) {
                CraftTweakerAPI.logWarning("Unsupported TagCollection without registry: " + key, new Object[0]);
                continue;
            }
            ForgeRegistry registry = registryManager.getRegistry(key);
            String tagFolder = registry.getTagFolder();
            if (tagFolder == null) {
                if (key.func_110624_b().equals("minecraft")) {
                    tagFolder = key.func_110623_a();
                } else {
                    CraftTweakerAPI.logWarning("Could not find tagFolder for registry '%s'", key);
                    continue;
                }
            }
            if (this.hasTagManager(tagFolder)) continue;
            CraftTweakerAPI.logDebug("Creating Wrapper TagManager for type '%s' with tag folder '%s'", key, tagFolder);
            this.registerTagManagerFromRegistry(key, registry, tagFolder);
        }
    }

    public void registerTagManagerFromRegistry(ResourceLocation name, ForgeRegistry<?> registry, String tagFolder) {
        Class registrySuperType = registry.getRegistrySuperType();
        Optional<String> s = CraftTweakerRegistry.tryGetZenClassNameFor(registrySuperType);
        if (!s.isPresent()) {
            CraftTweakerAPI.logDebug("Could not register tag manager for " + tagFolder, new Object[0]);
            return;
        }
        this.register(new TagManagerWrapper(registrySuperType, name, tagFolder));
    }

    public boolean hasTagManager(String location) {
        return this.getAllInstances().containsKey(location);
    }

    private Map<String, TagManager<?>> getAllInstances() {
        HashMap result = new HashMap(this.registeredInstances);
        result.putAll(this.syntheticInstances);
        return result;
    }

    <T> TagManager<T> getForElementType(Class<T> cls) {
        return this.tagFolderByCrTElementType.get(cls);
    }

    <T> TagManager<T> getForRegistry(ResourceLocation location) {
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(location);
        if (registry == null) {
            throw new IllegalArgumentException("Unknown registry name: " + location);
        }
        return this.getByTagFolder(registry.getTagFolder());
    }

    public <T extends TagManager<?>> T getByImplementation(Class<T> cls) {
        for (TagManager<?> value : this.registeredInstances.values()) {
            if (!cls.isInstance(value)) continue;
            return (T)((TagManager)cls.cast(value));
        }
        throw new IllegalArgumentException("Unknown tag implementation name: " + cls);
    }

    public boolean isSynthetic(String tagFolder) {
        return this.syntheticInstances.containsKey(tagFolder);
    }

    public String getElementZCTypeFor(String tagFolder) {
        Map<String, TagManager<?>> allInstances = this.getAllInstances();
        if (!allInstances.containsKey(tagFolder)) {
            throw new IllegalArgumentException("Could not find registry for name " + tagFolder);
        }
        Class<?> elementClass = allInstances.get(tagFolder).getElementClass();
        Optional<String> s = CraftTweakerRegistry.tryGetZenClassNameFor(elementClass);
        return s.orElseThrow(() -> new IllegalArgumentException("Cannot find ZC type for name " + tagFolder));
    }

    public String getImplementationZCTypeFor(String location) {
        TagManager<?> tagManager = this.registeredInstances.get(location);
        return tagManager.getClass().getAnnotation(ZenCodeType.Name.class).value();
    }

    public <T> TagManager<T> getByTagFolder(String location) {
        for (TagManager<?> value : this.getAllInstances().values()) {
            if (!value.getTagFolder().equals(location)) continue;
            return value;
        }
        throw new IllegalArgumentException("No TagManager with tag folder " + location + " is registered");
    }

    public Collection<TagManager<?>> getAll() {
        return this.getAllInstances().values();
    }
}

