/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel;

import java.util.Arrays;
import java.util.Map;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.TypeID;

public class FunctionHeader {
    public final TypeParameter[] typeParameters;
    public final FunctionParameter[] parameters;
    public final TypeID thrownType;
    public final int minParameters;
    public final int maxParameters;
    public final boolean hasUnknowns;
    private TypeID returnType;

    public FunctionHeader(TypeID returnType) {
        if (returnType == null) {
            throw new NullPointerException();
        }
        this.typeParameters = TypeParameter.NONE;
        this.returnType = returnType;
        this.parameters = FunctionParameter.NONE;
        this.thrownType = null;
        this.minParameters = 0;
        this.maxParameters = 0;
        this.hasUnknowns = returnType == BasicTypeID.UNDETERMINED;
    }

    public FunctionHeader(TypeID returnType, TypeID ... parameterTypes) {
        if (returnType == null) {
            throw new NullPointerException("The function needs a return type");
        }
        this.typeParameters = TypeParameter.NONE;
        this.returnType = returnType;
        this.parameters = new FunctionParameter[parameterTypes.length];
        this.thrownType = null;
        for (int i = 0; i < parameterTypes.length; ++i) {
            this.parameters[i] = new FunctionParameter(parameterTypes[i], null);
        }
        this.minParameters = parameterTypes.length;
        this.maxParameters = parameterTypes.length;
        this.hasUnknowns = FunctionHeader.hasUnknowns(parameterTypes, returnType);
    }

    public FunctionHeader(TypeID returnType, FunctionParameter ... parameters) {
        if (returnType == null) {
            throw new NullPointerException("The function needs a return type");
        }
        this.typeParameters = TypeParameter.NONE;
        this.returnType = returnType;
        this.parameters = parameters;
        this.thrownType = null;
        this.minParameters = FunctionHeader.getMinParameters(parameters);
        this.maxParameters = FunctionHeader.getMaxParameters(parameters);
        this.hasUnknowns = FunctionHeader.hasUnknowns(parameters, returnType);
    }

    public FunctionHeader(TypeParameter[] typeParameters, TypeID returnType, TypeID thrownType, FunctionParameter ... parameters) {
        if (returnType == null) {
            throw new NullPointerException();
        }
        if (typeParameters == null) {
            throw new NullPointerException();
        }
        this.typeParameters = typeParameters;
        this.returnType = returnType;
        this.parameters = parameters;
        this.thrownType = thrownType;
        this.minParameters = FunctionHeader.getMinParameters(parameters);
        this.maxParameters = FunctionHeader.getMaxParameters(parameters);
        this.hasUnknowns = FunctionHeader.hasUnknowns(parameters, returnType);
    }

    private static int getMinParameters(FunctionParameter[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].defaultValue == null && !parameters[i].variadic) continue;
            return i;
        }
        return parameters.length;
    }

    private static int getMaxParameters(FunctionParameter[] parameters) {
        if (parameters.length == 0) {
            return 0;
        }
        return parameters[parameters.length - 1].variadic ? Integer.MAX_VALUE : parameters.length;
    }

    private static boolean hasUnknowns(TypeID[] types, TypeID returnType) {
        if (returnType == BasicTypeID.UNDETERMINED) {
            return true;
        }
        for (TypeID type : types) {
            if (type != BasicTypeID.UNDETERMINED) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUnknowns(FunctionParameter[] parameters, TypeID returnType) {
        if (returnType == BasicTypeID.UNDETERMINED) {
            return true;
        }
        for (FunctionParameter parameter : parameters) {
            if (parameter.type != BasicTypeID.UNDETERMINED) continue;
            return true;
        }
        return false;
    }

    public boolean isVariadic() {
        return this.parameters.length > 0 && this.parameters[this.parameters.length - 1].variadic;
    }

    public boolean isVariadicCall(CallArguments arguments, TypeScope scope) {
        if (!this.isVariadic()) {
            return false;
        }
        if (arguments.arguments.length < this.parameters.length - 1) {
            return false;
        }
        if (arguments.arguments.length != this.parameters.length) {
            return true;
        }
        return !scope.getTypeMembers(arguments.arguments[arguments.arguments.length - 1].type).canCastImplicit(this.parameters[this.parameters.length - 1].type);
    }

    public boolean isVariadicCall(CallArguments arguments) {
        if (!this.isVariadic()) {
            return false;
        }
        if (arguments.arguments.length < this.parameters.length - 1) {
            return false;
        }
        if (arguments.arguments.length != this.parameters.length) {
            return true;
        }
        return !arguments.arguments[arguments.arguments.length - 1].type.equals(this.parameters[this.parameters.length - 1].type);
    }

    public boolean[] useTypeParameters() {
        boolean[] useTypeParameters = new boolean[this.typeParameters.length];
        Arrays.fill(useTypeParameters, true);
        return useTypeParameters;
    }

    public TypeID getReturnType() {
        return this.returnType;
    }

    public void setReturnType(TypeID returnType) {
        if (returnType == null) {
            throw new NullPointerException("The function needs a return type");
        }
        this.returnType = returnType;
    }

    public TypeID getParameterType(boolean isVariadic, int index) {
        return this.getParameter((boolean)isVariadic, (int)index).type;
    }

    public FunctionParameter getParameter(boolean isVariadic, int index) {
        if (isVariadic && index >= this.parameters.length - 1) {
            FunctionParameter parameter = this.parameters[this.parameters.length - 1];
            if (parameter.type instanceof ArrayTypeID) {
                return new FunctionParameter(((ArrayTypeID)parameter.type).elementType, parameter.name);
            }
            return parameter;
        }
        return this.parameters[index];
    }

    public boolean isDenormalized() {
        if (!this.returnType.getNormalized().equals(this.returnType)) {
            return true;
        }
        for (FunctionParameter parameter : this.parameters) {
            if (parameter.type.getNormalized() == parameter.type) continue;
            return true;
        }
        return false;
    }

    public FunctionHeader normalize(GlobalTypeRegistry registry) {
        if (!this.isDenormalized()) {
            return this;
        }
        FunctionParameter[] normalizedParameters = new FunctionParameter[this.parameters.length];
        for (int i = 0; i < normalizedParameters.length; ++i) {
            normalizedParameters[i] = this.parameters[i].normalize(registry);
        }
        return new FunctionHeader(this.typeParameters, this.returnType.getNormalized(), this.thrownType == null ? null : this.thrownType.getNormalized(), normalizedParameters);
    }

    public int getNumberOfTypeParameters() {
        return this.typeParameters.length;
    }

    public boolean hasAnyDefaultValues() {
        for (FunctionParameter parameter : this.parameters) {
            if (parameter.defaultValue == null) continue;
            return true;
        }
        return false;
    }

    public FunctionHeader inferFromOverride(GlobalTypeRegistry registry, FunctionHeader overridden) {
        TypeID resultThrownType;
        TypeParameter[] resultTypeParameters = this.typeParameters;
        TypeID resultReturnType = this.returnType;
        if (resultReturnType == BasicTypeID.UNDETERMINED) {
            resultReturnType = overridden.returnType;
        }
        if ((resultThrownType = this.thrownType) == null && overridden.thrownType != null) {
            resultThrownType = overridden.thrownType;
        }
        FunctionParameter[] resultParameters = Arrays.copyOf(this.parameters, this.parameters.length);
        for (int i = 0; i < resultParameters.length; ++i) {
            if (resultParameters[i].type != BasicTypeID.UNDETERMINED) continue;
            FunctionParameter parameter = resultParameters[i];
            FunctionParameter original = overridden.parameters[i];
            resultParameters[i] = new FunctionParameter(original.type, parameter.name, parameter.defaultValue, original.variadic);
        }
        return new FunctionHeader(resultTypeParameters, resultReturnType, resultThrownType, resultParameters);
    }

    public boolean matchesExactly(CodePosition position, CallArguments arguments, TypeScope scope) {
        if (arguments.arguments.length < this.minParameters || arguments.arguments.length > this.maxParameters) {
            return false;
        }
        FunctionHeader header = this.fillGenericArguments(position, scope, arguments.typeArguments);
        boolean variadicCall = header.isVariadicCall(arguments, scope);
        for (int i = 0; i < arguments.arguments.length; ++i) {
            if (arguments.arguments[i].type.equals(header.getParameterType(variadicCall, i))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesImplicitly(CodePosition position, CallArguments arguments, TypeScope scope) {
        if (!this.accepts(arguments.arguments.length)) {
            return false;
        }
        FunctionHeader header = this.fillGenericArguments(position, scope, arguments.typeArguments);
        if (this.isVariadic()) {
            boolean matches = true;
            for (int i = 0; i < arguments.arguments.length; ++i) {
                if (scope.getTypeMembers(arguments.arguments[i].type).canCastImplicit(header.getParameterType(true, i))) continue;
                matches = false;
                break;
            }
            if (matches) {
                return true;
            }
        }
        for (int i = 0; i < arguments.arguments.length; ++i) {
            if (scope.getTypeMembers(arguments.arguments[i].type).canCastImplicit(header.parameters[i].type)) continue;
            return false;
        }
        return true;
    }

    public String getCanonicalWithoutReturnType() {
        int i;
        StringBuilder result = new StringBuilder();
        if (this.getNumberOfTypeParameters() > 0) {
            result.append('<');
            for (i = 0; i < this.typeParameters.length; ++i) {
                if (i > 0) {
                    result.append(',');
                }
                result.append(this.typeParameters[i].getCanonical());
            }
            result.append('>');
        }
        result.append('(');
        for (i = 0; i < this.parameters.length; ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.parameters[i].type.toString());
        }
        result.append(')');
        return result.toString();
    }

    public String getCanonical() {
        return this.getCanonicalWithoutReturnType() + this.returnType.toString();
    }

    public boolean hasInferenceBlockingTypeParameters(TypeParameter[] parameters) {
        for (int i = 0; i < this.parameters.length; ++i) {
            if (!this.parameters[i].type.hasInferenceBlockingTypeParameters(parameters)) continue;
            return true;
        }
        return false;
    }

    public boolean accepts(TypeScope scope, Expression ... arguments) {
        if (this.parameters.length != arguments.length) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (scope.getTypeMembers(arguments[i].type).canCastImplicit(this.parameters[i].type)) continue;
            return false;
        }
        return true;
    }

    public boolean canOverride(TypeScope scope, FunctionHeader other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this.parameters.length != other.parameters.length) {
            return false;
        }
        if (this.returnType != BasicTypeID.UNDETERMINED && !scope.getTypeMembers(this.returnType).canCastImplicit(other.returnType)) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i].type == BasicTypeID.UNDETERMINED) continue;
            if (this.parameters[i].variadic != other.parameters[i].variadic) {
                return false;
            }
            if (scope.getTypeMembers(other.parameters[i].type).canCastImplicit(this.parameters[i].type)) continue;
            return false;
        }
        return true;
    }

    public boolean isEquivalentTo(FunctionHeader other) {
        if (this.parameters.length != other.parameters.length) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i].type.equals(other.parameters[i].type)) continue;
            return false;
        }
        return true;
    }

    public boolean isSimilarTo(FunctionHeader other) {
        int i;
        int common = Math.min(this.parameters.length, other.parameters.length);
        for (i = 0; i < common; ++i) {
            if (this.parameters[i].type == other.parameters[i].type) continue;
            return false;
        }
        for (i = common; i < this.parameters.length; ++i) {
            if (this.parameters[i].defaultValue != null) continue;
            return false;
        }
        for (i = common; i < other.parameters.length; ++i) {
            if (other.parameters[i].defaultValue != null) continue;
            return false;
        }
        return true;
    }

    public FunctionHeader instanceForCall(CodePosition position, GlobalTypeRegistry registry, CallArguments arguments) {
        if (arguments.getNumberOfTypeArguments() > 0) {
            Map<TypeParameter, TypeID> typeParameters = TypeID.getMapping(this.typeParameters, arguments.typeArguments);
            return this.instance(new GenericMapper(position, registry, typeParameters));
        }
        return this;
    }

    public FunctionHeader withGenericArguments(GenericMapper mapper) {
        if (this.typeParameters.length > 0) {
            mapper = mapper.getInner(mapper.position, mapper.registry, TypeID.getSelfMapping(mapper.registry, this.typeParameters));
        }
        return this.instance(mapper);
    }

    private FunctionHeader instance(GenericMapper mapper) {
        TypeID returnType = this.returnType.instance(mapper);
        FunctionParameter[] parameters = new FunctionParameter[this.parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.parameters[i].withGenericArguments(mapper);
        }
        return new FunctionHeader(this.typeParameters, returnType, this.thrownType == null ? null : this.thrownType.instance(mapper), parameters);
    }

    public FunctionHeader fillGenericArguments(CodePosition position, TypeScope scope, TypeID[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return this;
        }
        Map<TypeParameter, TypeID> typeArguments = TypeID.getMapping(this.typeParameters, arguments);
        GenericMapper mapper = scope.getLocalTypeParameters().getInner(position, scope.getTypeRegistry(), typeArguments);
        TypeID returnType = this.returnType.instance(mapper);
        FunctionParameter[] parameters = new FunctionParameter[this.parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.parameters[i].withGenericArguments(mapper);
        }
        return new FunctionHeader(TypeParameter.NONE, returnType, this.thrownType == null ? null : this.thrownType.instance(mapper), parameters);
    }

    public FunctionHeader forTypeParameterInference() {
        return new FunctionHeader((TypeID)BasicTypeID.UNDETERMINED, this.parameters);
    }

    public FunctionHeader forLambda(FunctionHeader lambdaHeader) {
        FunctionParameter[] parameters = new FunctionParameter[lambdaHeader.parameters.length];
        for (int i = 0; i < lambdaHeader.parameters.length; ++i) {
            parameters[i] = new FunctionParameter(this.parameters[i].type, lambdaHeader.parameters[i].name);
        }
        return new FunctionHeader(this.typeParameters, this.returnType, this.thrownType, parameters);
    }

    public FunctionParameter getVariadicParameter() {
        if (this.parameters.length == 0) {
            return null;
        }
        if (this.parameters[this.parameters.length - 1].variadic) {
            return this.parameters[this.parameters.length - 1];
        }
        return null;
    }

    public String explainWhyIncompatible(TypeScope scope, CallArguments arguments) {
        if (this.parameters.length != arguments.arguments.length) {
            return this.parameters.length + " parameters expected but " + arguments.arguments.length + " given.";
        }
        if (this.getNumberOfTypeParameters() != arguments.getNumberOfTypeArguments()) {
            return this.getNumberOfTypeParameters() + " type parameters expected but " + arguments.getNumberOfTypeArguments() + " given.";
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (scope.getTypeMembers(arguments.arguments[i].type).canCastImplicit(this.parameters[i].type)) continue;
            return "Parameter " + i + ": cannot cast " + arguments.arguments[i].type + " to " + this.parameters[i].type;
        }
        return "Method should be compatible";
    }

    public String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        if (this.typeParameters.length > 0) {
            result.append("<");
            for (i = 0; i < this.typeParameters.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.typeParameters[i].toString());
            }
            result.append(">");
        }
        result.append("(");
        for (i = 0; i < this.parameters.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.parameters[i].toString());
        }
        result.append(") as ");
        result.append(this.returnType.toString());
        return result.toString();
    }

    public boolean accepts(int arguments) {
        return arguments >= this.minParameters && arguments <= this.maxParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionHeader that = (FunctionHeader)o;
        if (this.minParameters != that.minParameters) {
            return false;
        }
        if (this.maxParameters != that.maxParameters) {
            return false;
        }
        if (this.hasUnknowns != that.hasUnknowns) {
            return false;
        }
        if (!Arrays.equals(this.typeParameters, that.typeParameters)) {
            return false;
        }
        if (!this.returnType.equals(that.returnType)) {
            return false;
        }
        if (!Arrays.equals(this.parameters, that.parameters)) {
            return false;
        }
        return this.thrownType == that.thrownType;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.typeParameters);
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameters);
        result = 31 * result + (this.thrownType != null ? this.thrownType.hashCode() : 0);
        result = 31 * result + this.minParameters;
        result = 31 * result + this.maxParameters;
        result = 31 * result + (this.hasUnknowns ? 1 : 0);
        return result;
    }
}

