/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type.member;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.CompareType;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.OperatorType;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.CheckNullExpression;
import org.openzen.zenscript.codemodel.expression.EnumConstantExpression;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.InterfaceCastExpression;
import org.openzen.zenscript.codemodel.expression.InvalidExpression;
import org.openzen.zenscript.codemodel.expression.NullExpression;
import org.openzen.zenscript.codemodel.expression.SupertypeCastExpression;
import org.openzen.zenscript.codemodel.expression.WrapOptionalExpression;
import org.openzen.zenscript.codemodel.member.EnumConstantMember;
import org.openzen.zenscript.codemodel.member.IDefinitionMember;
import org.openzen.zenscript.codemodel.member.InnerDefinition;
import org.openzen.zenscript.codemodel.member.ref.CasterMemberRef;
import org.openzen.zenscript.codemodel.member.ref.ConstMemberRef;
import org.openzen.zenscript.codemodel.member.ref.DefinitionMemberRef;
import org.openzen.zenscript.codemodel.member.ref.FieldMemberRef;
import org.openzen.zenscript.codemodel.member.ref.FunctionalMemberRef;
import org.openzen.zenscript.codemodel.member.ref.GetterMemberRef;
import org.openzen.zenscript.codemodel.member.ref.ImplementationMemberRef;
import org.openzen.zenscript.codemodel.member.ref.IteratorMemberRef;
import org.openzen.zenscript.codemodel.member.ref.SetterMemberRef;
import org.openzen.zenscript.codemodel.member.ref.VariantOptionRef;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.partial.PartialMemberGroupExpression;
import org.openzen.zenscript.codemodel.partial.PartialStaticMemberGroupExpression;
import org.openzen.zenscript.codemodel.partial.PartialTypeExpression;
import org.openzen.zenscript.codemodel.partial.PartialVariantOptionExpression;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.ArrayTypeID;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.GenericTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.InvalidTypeID;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.BuiltinID;
import org.openzen.zenscript.codemodel.type.member.LocalMemberCache;
import org.openzen.zenscript.codemodel.type.member.TypeMember;
import org.openzen.zenscript.codemodel.type.member.TypeMemberGroup;
import org.openzen.zenscript.codemodel.type.member.TypeMemberPriority;

public final class TypeMembers {
    public final TypeID type;
    private final LocalMemberCache cache;
    private final List<TypeMember<CasterMemberRef>> casters = new ArrayList<TypeMember<CasterMemberRef>>();
    private final List<TypeMember<ImplementationMemberRef>> implementations = new ArrayList<TypeMember<ImplementationMemberRef>>();
    private final List<TypeMember<IteratorMemberRef>> iterators = new ArrayList<TypeMember<IteratorMemberRef>>();
    private final Map<String, EnumConstantMember> enumMembers = new HashMap<String, EnumConstantMember>();
    private final Map<String, VariantOptionRef> variantOptions = new HashMap<String, VariantOptionRef>();
    private final Map<String, TypeMemberGroup> members = new HashMap<String, TypeMemberGroup>();
    private final Map<String, InnerDefinition> innerTypes = new HashMap<String, InnerDefinition>();
    private final Map<OperatorType, TypeMemberGroup> operators = new HashMap<OperatorType, TypeMemberGroup>();

    public TypeMembers(LocalMemberCache cache, TypeID type) {
        if (type == null) {
            throw new NullPointerException("Type must not be null!");
        }
        if (type == BasicTypeID.UNDETERMINED) {
            throw new IllegalArgumentException("Cannot retrieve members of undetermined type");
        }
        this.cache = cache;
        this.type = type;
    }

    public LocalMemberCache getMemberCache() {
        return this.cache;
    }

    public boolean extendsOrImplements(TypeID other) {
        TypeID superType;
        block9: {
            other = other.getNormalized();
            if (this.type instanceof DefinitionTypeID && other instanceof DefinitionTypeID) {
                DefinitionTypeID thisTypeId = (DefinitionTypeID)this.type;
                DefinitionTypeID otherTypeId = (DefinitionTypeID)other;
                if (thisTypeId.definition == otherTypeId.definition && thisTypeId.definition.typeParameters.length == otherTypeId.typeArguments.length) {
                    for (int i = 0; i < thisTypeId.definition.typeParameters.length; ++i) {
                        TypeID type = otherTypeId.typeArguments[i];
                        if (type == BasicTypeID.UNDETERMINED || type instanceof InvalidTypeID && ((InvalidTypeID)type).code == CompileExceptionCode.TYPE_ARGUMENTS_NOT_INFERRABLE || thisTypeId.definition.typeParameters[i].matches(this.cache, type)) {
                            continue;
                        }
                        break block9;
                    }
                    return true;
                }
            }
        }
        if ((superType = this.type.getSuperType(this.cache.getRegistry())) != null) {
            if (superType == other) {
                return true;
            }
            if (this.cache.get(superType).extendsOrImplements(other)) {
                return true;
            }
        }
        for (TypeMember<ImplementationMemberRef> implementation : this.implementations) {
            if (((ImplementationMemberRef)implementation.member).implementsType == other) {
                return true;
            }
            if (!this.cache.get(((ImplementationMemberRef)implementation.member).implementsType).extendsOrImplements(other)) continue;
            return true;
        }
        return false;
    }

    public boolean extendsType(TypeID other) {
        other = other.getNormalized();
        TypeID superType = this.type.getSuperType(this.cache.getRegistry());
        if (superType != null) {
            return superType == other || this.cache.get(superType).extendsType(other);
        }
        return false;
    }

    public GlobalTypeRegistry getTypeRegistry() {
        return this.cache.getRegistry();
    }

    public void copyMembersTo(TypeMembers other, TypeMemberPriority priority) {
        for (TypeMember<CasterMemberRef> typeMember : this.casters) {
            other.casters.add(new TypeMember(priority, typeMember.member));
        }
        for (TypeMember<DefinitionMemberRef> typeMember : this.iterators) {
            other.addIterator((IteratorMemberRef)typeMember.member, priority);
        }
        for (Map.Entry entry : this.enumMembers.entrySet()) {
            other.addEnumMember((EnumConstantMember)entry.getValue(), priority);
        }
        for (Map.Entry entry : this.variantOptions.entrySet()) {
            other.addVariantOption((VariantOptionRef)entry.getValue());
        }
        for (Map.Entry entry : this.members.entrySet()) {
            other.getOrCreateGroup((String)entry.getKey(), ((TypeMemberGroup)entry.getValue()).isStatic).merge((TypeMemberGroup)entry.getValue(), priority);
        }
        for (Map.Entry entry : this.innerTypes.entrySet()) {
            other.innerTypes.put((String)entry.getKey(), (InnerDefinition)entry.getValue());
        }
        for (Map.Entry entry : this.operators.entrySet()) {
            other.getOrCreateGroup((OperatorType)((Object)entry.getKey())).merge((TypeMemberGroup)entry.getValue(), priority);
        }
    }

    public DefinitionMemberRef getBuiltin(BuiltinID builtin) {
        for (TypeMemberGroup group : this.members.values()) {
            if (group.getConstant() != null && group.getConstant().member.builtin == builtin) {
                return group.getConstant();
            }
            if (group.getField() != null && group.getField().member.builtin == builtin) {
                return group.getField();
            }
            for (TypeMember<FunctionalMemberRef> member : group.getMethodMembers()) {
                if (((FunctionalMemberRef)member.member).getBuiltin() != builtin) continue;
                return member.member;
            }
        }
        for (TypeMemberGroup group : this.operators.values()) {
            if (group.getConstant() != null && group.getConstant().member.builtin == builtin) {
                return group.getConstant();
            }
            if (group.getField() != null && group.getField().member.builtin == builtin) {
                return group.getField();
            }
            for (TypeMember<FunctionalMemberRef> member : group.getMethodMembers()) {
                if (((FunctionalMemberRef)member.member).getBuiltin() != builtin) continue;
                return member.member;
            }
        }
        return null;
    }

    public TypeID union(TypeID other) {
        TypeID union;
        if (this.type == (other = other.getNormalized())) {
            return this.type;
        }
        if (this.canCastImplicit(other)) {
            return other;
        }
        if (this.cache.get(other).canCastImplicit(this.type)) {
            return this.type;
        }
        for (TypeMember<ImplementationMemberRef> implementation : this.implementations) {
            union = this.cache.get(((ImplementationMemberRef)implementation.member).implementsType).union(other);
            if (union == null) continue;
            return union;
        }
        if (this.type instanceof ArrayTypeID && other instanceof ArrayTypeID) {
            ArrayTypeID thisArray = (ArrayTypeID)this.type;
            ArrayTypeID otherArray = (ArrayTypeID)other;
            if (thisArray.dimension == otherArray.dimension && (union = this.cache.get(thisArray.elementType).union(otherArray.elementType)) != null) {
                return this.getTypeRegistry().getArray(union, thisArray.dimension);
            }
        }
        return null;
    }

    public List<IDefinitionMember> getUnimplementedMembers(Set<IDefinitionMember> implemented) {
        TypeMemberGroup group;
        ArrayList<IDefinitionMember> result = new ArrayList<IDefinitionMember>();
        for (TypeMember<CasterMemberRef> typeMember : this.casters) {
            if (!((CasterMemberRef)typeMember.member).member.isAbstract() || implemented.contains(((CasterMemberRef)typeMember.member).member)) continue;
            result.add(((CasterMemberRef)typeMember.member).member);
        }
        for (TypeMember<DefinitionMemberRef> typeMember : this.iterators) {
            if (!((IteratorMemberRef)typeMember.member).target.isAbstract() || implemented.contains(((IteratorMemberRef)typeMember.member).target)) continue;
            result.add(((IteratorMemberRef)typeMember.member).target);
        }
        for (Map.Entry entry : this.members.entrySet()) {
            group = (TypeMemberGroup)entry.getValue();
            if (group.getGetter() != null && group.getGetter().member.isAbstract() && !implemented.contains(group.getGetter().member)) {
                result.add(group.getGetter().member);
            }
            if (group.getSetter() != null && group.getSetter().member.isAbstract() && !implemented.contains(group.getSetter().member)) {
                result.add(group.getSetter().member);
            }
            for (TypeMember<FunctionalMemberRef> member : group.getMethodMembers()) {
                if (!((FunctionalMemberRef)member.member).getTarget().isAbstract() || implemented.contains(((FunctionalMemberRef)member.member).getTarget())) continue;
                result.add(((FunctionalMemberRef)member.member).getTarget());
            }
        }
        for (Map.Entry entry : this.operators.entrySet()) {
            if (entry.getKey() == OperatorType.DESTRUCTOR) continue;
            group = (TypeMemberGroup)entry.getValue();
            if (group.getGetter() != null && group.getGetter().member.isAbstract() && !implemented.contains(group.getGetter().member)) {
                result.add(group.getGetter().member);
            }
            if (group.getSetter() != null && group.getSetter().member.isAbstract() && !implemented.contains(group.getSetter().member)) {
                result.add(group.getSetter().member);
            }
            for (TypeMember<FunctionalMemberRef> member : group.getMethodMembers()) {
                if (!((FunctionalMemberRef)member.member).getTarget().isAbstract() || implemented.contains(((FunctionalMemberRef)member.member).getTarget())) continue;
                result.add(((FunctionalMemberRef)member.member).getTarget());
            }
        }
        return result;
    }

    public void addConstructor(FunctionalMemberRef constructor, TypeMemberPriority priority) {
        this.getOrCreateGroup(OperatorType.CONSTRUCTOR).addMethod(constructor, priority);
    }

    public void addConstructor(FunctionalMemberRef constructor) {
        this.getOrCreateGroup(OperatorType.CONSTRUCTOR).addMethod(constructor, TypeMemberPriority.SPECIFIED);
    }

    public void addDestructor(FunctionalMemberRef destructor, TypeMemberPriority priority) {
        this.getOrCreateGroup(OperatorType.DESTRUCTOR).addMethod(destructor, priority);
    }

    public void addCaller(FunctionalMemberRef caller, TypeMemberPriority priority) {
        this.getOrCreateGroup(OperatorType.CALL).addMethod(caller, priority);
    }

    public void addCaster(CasterMemberRef caster, TypeMemberPriority priority) {
        for (int i = 0; i < this.casters.size(); ++i) {
            if (((CasterMemberRef)this.casters.get((int)i).member).toType != caster.toType) continue;
            this.casters.set(i, this.casters.get(i).resolve(new TypeMember<CasterMemberRef>(priority, caster)));
        }
        this.casters.add(new TypeMember<CasterMemberRef>(priority, caster));
    }

    public void addConst(ConstMemberRef member) {
        TypeMemberGroup group = this.getOrCreateGroup(member.member.name, true);
        group.setConst(member, TypeMemberPriority.SPECIFIED);
    }

    public void addField(FieldMemberRef member, TypeMemberPriority priority) {
        TypeMemberGroup group = this.getOrCreateGroup(member.member.name, member.isStatic());
        group.setField(member, priority);
    }

    public void addGetter(GetterMemberRef member, TypeMemberPriority priority) {
        TypeMemberGroup group = this.getOrCreateGroup(member.member.name, member.isStatic());
        group.setGetter(member, priority);
    }

    public void addSetter(SetterMemberRef member, TypeMemberPriority priority) {
        TypeMemberGroup group = this.getOrCreateGroup(member.member.name, member.isStatic());
        group.setSetter(member, priority);
    }

    public void addMethod(String name, FunctionalMemberRef member, TypeMemberPriority priority) {
        TypeMemberGroup group = this.getOrCreateGroup(name, member.isStatic());
        group.addMethod(member, priority);
    }

    public void addOperator(OperatorType operator, FunctionalMemberRef member) {
        this.addOperator(operator, member, TypeMemberPriority.SPECIFIED);
    }

    public boolean hasOperator(OperatorType operator) {
        return this.operators.containsKey((Object)operator) && this.operators.get((Object)operator).hasMethods();
    }

    public void addOperator(OperatorType operator, FunctionalMemberRef member, TypeMemberPriority priority) {
        TypeMemberGroup group = this.getOrCreateGroup(operator);
        group.addMethod(member, priority);
    }

    public void addVariantOption(VariantOptionRef option) {
        this.variantOptions.put(option.getName(), option);
    }

    public void addIterator(IteratorMemberRef iterator, TypeMemberPriority priority) {
        for (int i = 0; i < this.iterators.size(); ++i) {
            if (((IteratorMemberRef)this.iterators.get((int)i).member).getLoopVariableCount() != iterator.getLoopVariableCount()) continue;
            this.iterators.set(i, this.iterators.get(i).resolve(new TypeMember<IteratorMemberRef>(priority, iterator)));
            return;
        }
        this.iterators.add(new TypeMember<IteratorMemberRef>(priority, iterator));
    }

    public void addImplementation(ImplementationMemberRef member, TypeMemberPriority priority) {
        for (int i = 0; i < this.implementations.size(); ++i) {
            if (((ImplementationMemberRef)this.implementations.get((int)i).member).implementsType != member.implementsType) continue;
            this.implementations.set(i, this.implementations.get(i).resolve(new TypeMember<ImplementationMemberRef>(priority, member)));
            return;
        }
        this.implementations.add(new TypeMember<ImplementationMemberRef>(priority, member));
    }

    public void addInnerType(String name, InnerDefinition type) {
        this.innerTypes.put(name, type);
    }

    public TypeMemberGroup getOrCreateGroup(String name, boolean isStatic) {
        if (!this.members.containsKey(name)) {
            this.members.put(name, new TypeMemberGroup(isStatic, name));
        }
        return this.members.get(name);
    }

    public TypeMemberGroup getGroup(String name) {
        if (!this.members.containsKey(name)) {
            return new TypeMemberGroup(false, name);
        }
        return this.members.get(name);
    }

    public TypeMemberGroup getOrCreateGroup(OperatorType operator) {
        if (!this.operators.containsKey((Object)operator)) {
            this.operators.put(operator, new TypeMemberGroup(false, operator.operator + " operator"));
        }
        return this.operators.get((Object)operator);
    }

    public TypeMemberGroup getGroup(OperatorType operator) {
        if (!this.operators.containsKey((Object)operator)) {
            return new TypeMemberGroup(false, operator.operator + " operator");
        }
        return this.operators.get((Object)operator);
    }

    public void addEnumMember(EnumConstantMember member, TypeMemberPriority priority) {
        this.enumMembers.put(member.name, member);
    }

    public EnumConstantMember getEnumMember(String name) {
        return this.enumMembers.get(name);
    }

    public VariantOptionRef getVariantOption(String name) {
        return this.variantOptions.get(name);
    }

    public Expression compare(CodePosition position, TypeScope scope, CompareType operator, Expression left, Expression right) throws CompileException {
        if (operator == CompareType.EQ) {
            TypeMemberGroup equal = this.getOrCreateGroup(OperatorType.EQUALS);
            for (TypeMember<FunctionalMemberRef> member : equal.getMethodMembers()) {
                if (!((FunctionalMemberRef)member.member).getHeader().accepts(scope, right)) continue;
                return equal.call(position, scope, left, new CallArguments(right), false);
            }
        } else if (operator == CompareType.NE) {
            TypeMemberGroup equal = this.getOrCreateGroup(OperatorType.NOTEQUALS);
            for (TypeMember<FunctionalMemberRef> member : equal.getMethodMembers()) {
                if (!((FunctionalMemberRef)member.member).getHeader().accepts(scope, right)) continue;
                return equal.call(position, scope, left, new CallArguments(right), false);
            }
            Expression compare = this.compare(position, scope, CompareType.EQ, left, right);
            return scope.getTypeMembers(compare.type).unary(position, scope, OperatorType.NOT, compare);
        }
        TypeMemberGroup compare = this.getOrCreateGroup(OperatorType.COMPARE);
        return compare.callWithComparator(position, scope, left, new CallArguments(right), operator);
    }

    public Expression unary(CodePosition position, TypeScope scope, OperatorType operator, Expression value) throws CompileException {
        TypeMemberGroup members = this.getOrCreateGroup(operator);
        return members.call(position, scope, value, new CallArguments(Expression.NONE), false);
    }

    public IteratorMemberRef getIterator(int variables) {
        for (TypeMember<IteratorMemberRef> iterator : this.iterators) {
            if (((IteratorMemberRef)iterator.member).getLoopVariableCount() != variables) continue;
            return (IteratorMemberRef)iterator.member;
        }
        return null;
    }

    public TypeID[] getLoopTypes(int variables) {
        for (TypeMember<IteratorMemberRef> iterator : this.iterators) {
            if (((IteratorMemberRef)iterator.member).getLoopVariableCount() != variables) continue;
            return ((IteratorMemberRef)iterator.member).types;
        }
        return null;
    }

    public boolean canCastImplicit(TypeID toType) {
        if (this.type == (toType = toType.getNormalized())) {
            return true;
        }
        if (toType == BasicTypeID.UNDETERMINED) {
            throw new IllegalArgumentException("Cannot cast to undetermined type!");
        }
        if (this.type == BasicTypeID.NULL && toType.isOptional()) {
            return true;
        }
        if (this.type.canCastImplicitTo(toType)) {
            return true;
        }
        if (toType.canCastImplicitFrom(this.type)) {
            return true;
        }
        if (toType.isOptional() && this.canCastImplicit(toType.withoutOptional())) {
            return true;
        }
        if (this.type.isOptional() && this.type.withoutOptional() == toType) {
            return true;
        }
        if (this.getImplicitCaster(toType) != null || this.extendsOrImplements(toType)) {
            return true;
        }
        if (this.type.isGeneric() && this.type instanceof GenericTypeID) {
            GenericTypeID genericTypeID = (GenericTypeID)this.type;
            return genericTypeID.parameter.matches(this.cache, toType);
        }
        return false;
    }

    public CasterMemberRef getImplicitCaster(TypeID toType) {
        return this.getCaster(toType, false);
    }

    public CasterMemberRef getCaster(TypeID toType) {
        return this.getCaster(toType, true);
    }

    private CasterMemberRef getCaster(TypeID toType, boolean explicit) {
        toType = toType.getNormalized();
        CasterMemberRef foundCaster = null;
        Enum priority = null;
        for (TypeMember<CasterMemberRef> caster : this.casters) {
            if (!explicit && !((CasterMemberRef)caster.member).isImplicit() || ((CasterMemberRef)caster.member).toType != toType || foundCaster != null && priority.compareTo(caster.priority) >= 0) continue;
            foundCaster = (CasterMemberRef)caster.member;
            priority = caster.priority;
        }
        return foundCaster;
    }

    public boolean canCast(TypeID toType) {
        if (this.canCastImplicit(toType = toType.getNormalized())) {
            return true;
        }
        if (this.type.canCastExplicitTo(toType)) {
            return true;
        }
        if (toType.canCastImplicitFrom(this.type)) {
            return true;
        }
        for (TypeMember<CasterMemberRef> caster : this.casters) {
            if (((CasterMemberRef)caster.member).toType != toType) continue;
            return true;
        }
        return false;
    }

    public Map<DefinitionMemberRef, IDefinitionMember> borrowInterfaceMembersFromDefinition(Set<IDefinitionMember> implemented, TypeMembers definitionMembers) {
        FunctionalMemberRef functional;
        TypeMemberGroup definitionGroup;
        TypeMemberGroup group;
        DefinitionMemberRef implementation;
        HashMap<DefinitionMemberRef, IDefinitionMember> result = new HashMap<DefinitionMemberRef, IDefinitionMember>();
        for (TypeMember<CasterMemberRef> typeMember : this.casters) {
            if (implemented.contains(((CasterMemberRef)typeMember.member).member) || (implementation = definitionMembers.getCaster(((CasterMemberRef)typeMember.member).toType)) == null) continue;
            result.put((DefinitionMemberRef)typeMember.member, ((CasterMemberRef)implementation).getTarget());
        }
        for (TypeMember<DefinitionMemberRef> typeMember : this.iterators) {
            if (implemented.contains(((IteratorMemberRef)typeMember.member).target) || (implementation = definitionMembers.getIterator(((IteratorMemberRef)typeMember.member).getLoopVariableCount())) == null) continue;
            result.put((DefinitionMemberRef)typeMember.member, ((IteratorMemberRef)implementation).getTarget());
        }
        for (Map.Entry entry : this.members.entrySet()) {
            SetterMemberRef implementation2;
            GetterMemberRef implementation22;
            group = (TypeMemberGroup)entry.getValue();
            definitionGroup = definitionMembers.getGroup((String)entry.getKey());
            if (definitionGroup == null) continue;
            if (group.getGetter() != null && !implemented.contains(group.getGetter().member) && (implementation22 = definitionGroup.getGetter()) != null) {
                result.put(group.getGetter(), implementation22.getTarget());
            }
            if (group.getSetter() != null && !implemented.contains(group.getSetter().member) && (implementation2 = definitionGroup.getSetter()) != null) {
                result.put(group.getSetter(), implementation2.getTarget());
            }
            for (TypeMember<FunctionalMemberRef> member : group.getMethodMembers()) {
                if (implemented.contains(((FunctionalMemberRef)member.member).getTarget()) || (functional = definitionGroup.getMethod(((FunctionalMemberRef)member.member).getHeader())) == null) continue;
                result.put((DefinitionMemberRef)member.member, functional.getTarget());
            }
        }
        for (Map.Entry entry : this.operators.entrySet()) {
            if (entry.getKey() == OperatorType.DESTRUCTOR) continue;
            group = (TypeMemberGroup)entry.getValue();
            definitionGroup = definitionMembers.getGroup((OperatorType)((Object)entry.getKey()));
            if (definitionGroup == null) continue;
            for (TypeMember<FunctionalMemberRef> member : group.getMethodMembers()) {
                if (implemented.contains(((FunctionalMemberRef)member.member).getTarget()) || (functional = definitionGroup.getMethod(((FunctionalMemberRef)member.member).getHeader())) == null) continue;
                result.put((DefinitionMemberRef)member.member, functional.getTarget());
            }
        }
        return result;
    }

    public Expression castImplicit(CodePosition position, Expression value, TypeID toType, boolean implicit) {
        if (toType == null) {
            throw new NullPointerException();
        }
        if ((toType = toType.getNormalized()) == BasicTypeID.UNDETERMINED) {
            return value;
        }
        if (this.type == toType) {
            return value;
        }
        if (this.type.canCastImplicitTo(toType)) {
            return this.type.castImplicitTo(position, value, toType);
        }
        if (toType.canCastImplicitFrom(this.type)) {
            return toType.castImplicitFrom(position, value);
        }
        if (this.type == BasicTypeID.NULL && toType.isOptional()) {
            return new NullExpression(position, toType);
        }
        if (toType.isOptional() && this.canCastImplicit(toType.withoutOptional())) {
            return new WrapOptionalExpression(position, this.castImplicit(position, value, toType.withoutOptional(), implicit), toType);
        }
        if (this.type.isOptional() && this.type.withoutOptional() == toType) {
            return new CheckNullExpression(position, value);
        }
        for (TypeMember<CasterMemberRef> typeMember : this.casters) {
            if (!((CasterMemberRef)typeMember.member).isImplicit() || ((CasterMemberRef)typeMember.member).toType != toType) continue;
            return ((CasterMemberRef)typeMember.member).cast(position, value, implicit);
        }
        for (TypeMember<DefinitionMemberRef> typeMember : this.implementations) {
            if (((ImplementationMemberRef)typeMember.member).implementsType.getNormalized() != toType) continue;
            return new InterfaceCastExpression(position, value, (ImplementationMemberRef)typeMember.member);
        }
        if (this.extendsOrImplements(toType)) {
            return new SupertypeCastExpression(position, value, toType);
        }
        return new InvalidExpression(position, toType, CompileExceptionCode.INVALID_CAST, "Could not cast " + this + " to " + toType);
    }

    public Expression castExplicit(CodePosition position, Expression value, TypeID toType, boolean optional) {
        if (this.canCastImplicit(toType = toType.getNormalized())) {
            return this.castImplicit(position, value, toType, false);
        }
        if (this.type.canCastExplicitTo(toType)) {
            return this.type.castExplicitTo(position, value, toType);
        }
        TypeMembers typeMembers = this.cache.get(this.type);
        if (this.type != typeMembers.type && typeMembers.canCast(toType)) {
            return typeMembers.castExplicit(position, value, toType, optional);
        }
        for (TypeMember<CasterMemberRef> caster : this.casters) {
            if (((CasterMemberRef)caster.member).toType != toType) continue;
            return ((CasterMemberRef)caster.member).cast(position, value, false);
        }
        if (toType.canCastImplicitFrom(this.type)) {
            return toType.castImplicitFrom(position, value);
        }
        return new InvalidExpression(position, toType, CompileExceptionCode.INVALID_CAST, "Cannot cast " + this + " to " + toType + ", even explicitly");
    }

    public boolean hasMember(String name) {
        return this.members.containsKey(name);
    }

    public IPartialExpression getMemberExpression(CodePosition position, TypeScope scope, Expression target, GenericName name, boolean allowStatic) {
        if (this.members.containsKey(name.name)) {
            TypeMemberGroup group = this.members.get(name.name);
            if (group.isStatic) {
                return new PartialStaticMemberGroupExpression(position, scope, this.type, group, name.arguments);
            }
            return new PartialMemberGroupExpression(position, scope, target, group, name.arguments, allowStatic);
        }
        if (this.type.isOptional()) {
            return scope.getTypeMembers(this.type.withoutOptional()).getMemberExpression(position, scope, target, name, allowStatic);
        }
        return null;
    }

    public IPartialExpression getStaticMemberExpression(CodePosition position, TypeScope scope, GenericName name) {
        if (this.members.containsKey(name.name)) {
            return new PartialStaticMemberGroupExpression(position, scope, this.type, this.members.get(name.name), name.arguments);
        }
        if (this.innerTypes.containsKey(name.name)) {
            return new PartialTypeExpression(position, this.innerTypes.get(name.name).instance(this.cache.getRegistry(), name.arguments, (DefinitionTypeID)this.type), name.arguments);
        }
        if (this.variantOptions.containsKey(name.name)) {
            return new PartialVariantOptionExpression(position, scope, this.variantOptions.get(name.name));
        }
        if (this.enumMembers.containsKey(name.name)) {
            return new EnumConstantExpression(position, this.type, this.enumMembers.get(name.name));
        }
        if (this.type.isOptional()) {
            return scope.getTypeMembers(this.type.withoutOptional()).getStaticMemberExpression(position, scope, name);
        }
        return null;
    }

    public boolean hasInnerType(String name) {
        return this.innerTypes.containsKey(name);
    }

    public DefinitionTypeID getInnerType(CodePosition position, GenericName name) {
        if (!this.innerTypes.containsKey(name.name)) {
            throw new RuntimeException("No such inner type in " + this.type + ": " + name.name);
        }
        return this.innerTypes.get(name.name).instance(this.cache.getRegistry(), name.arguments, (DefinitionTypeID)this.type);
    }

    public String toString() {
        return this.type.toString();
    }
}

