/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.ImmutableSet;
import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariants;
import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraftforge.common.BiomeDictionary;

public abstract class MineshaftPiece
extends StructurePiece {
    protected MineshaftVariantSettings settings;
    protected int chainLength;
    protected static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final Set<Material> LIQUIDS = ImmutableSet.of((Object)Material.field_151587_i, (Object)Material.field_151586_h);

    public MineshaftPiece(IStructurePieceType structurePieceType, int chainLength, MineshaftVariantSettings settings) {
        super(structurePieceType, chainLength);
        this.settings = settings;
        this.chainLength = chainLength;
    }

    public MineshaftPiece(IStructurePieceType structurePieceType, CompoundNBT compoundTag) {
        super(structurePieceType, compoundTag);
        int index = compoundTag.func_74762_e("MST");
        this.settings = index < MineshaftVariants.get().getVariants().size() && index >= 0 ? MineshaftVariants.get().getVariants().get(index) : MineshaftVariants.get().getDefault();
    }

    protected void toNbt(CompoundNBT tag) {
        int index = MineshaftVariants.get().getVariants().indexOf(this.settings);
        tag.func_74768_a("MST", index);
    }

    public void setBoundingBox(MutableBoundingBox boundingBox) {
        this.field_74887_e = boundingBox;
    }

    public MineshaftVariantSettings getSettings() {
        return this.settings;
    }

    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
    }

    protected BlockSetSelector getMainSelector() {
        return this.settings.mainSelector;
    }

    protected BlockSetSelector getFloorSelector() {
        return this.settings.floorSelector;
    }

    protected BlockSetSelector getBrickSelector() {
        return this.settings.brickSelector;
    }

    protected BlockSetSelector getLegSelector() {
        return this.settings.legSelector;
    }

    protected BlockState getMainBlock() {
        return this.settings.mainBlock;
    }

    protected BlockState getSupportBlock() {
        return this.settings.supportBlock;
    }

    protected BlockState getMainSlab() {
        return this.settings.slabBlock;
    }

    protected BlockState getGravel() {
        return this.settings.gravelBlock;
    }

    protected BlockState getMainDoorwayWall() {
        return this.settings.stoneWallBlock;
    }

    protected BlockState getMainDoorwaySlab() {
        return this.settings.stoneSlabBlock;
    }

    protected BlockState getTrapdoor() {
        return this.settings.trapdoorBlock;
    }

    protected void addBarrel(ISeedReader world, MutableBoundingBox boundingBox, Random random, BlockPos pos, ResourceLocation lootTableId) {
        if (boundingBox.func_175898_b((Vector3i)pos) && world.func_180495_p(pos).func_177230_c() != Blocks.field_222422_lK) {
            world.func_180501_a(pos, (BlockState)Blocks.field_222422_lK.func_176223_P().func_206870_a((Property)BarrelBlock.field_220092_a, (Comparable)Direction.UP), 2);
            LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)pos, (ResourceLocation)lootTableId);
        }
    }

    protected void addBarrel(ISeedReader world, MutableBoundingBox boundingBox, Random random, int x, int y, int z, ResourceLocation lootTableId) {
        BlockPos blockPos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        this.addBarrel(world, boundingBox, random, blockPos, lootTableId);
    }

    protected void addVines(ISeedReader world, MutableBoundingBox boundingBox, Direction facing, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutable.func_181079_c(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z)).func_189536_c(facing);
                    BlockState nextBlock = this.func_175807_a((IBlockReader)world, x + facing.func_82601_c(), y + facing.func_96559_d(), z + facing.func_82599_e(), boundingBox);
                    if (!this.func_175807_a((IBlockReader)world, x, y, z, boundingBox).func_196958_f() || !Block.func_208061_a((VoxelShape)nextBlock.func_196952_d((IBlockReader)world, (BlockPos)mutable), (Direction)facing.func_176734_d()) || nextBlock.func_177230_c().func_176223_P() == Blocks.field_150468_ap.func_176223_P() || !(random.nextFloat() < chance)) continue;
                    this.func_175811_a(world, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.func_176267_a((Direction)(facing.func_176740_k() == Direction.Axis.X ? facing : facing.func_176734_d())), (Comparable)Boolean.valueOf(true)), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void addVines(ISeedReader world, MutableBoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.addVines(world, boundingBox, Direction.EAST, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, Direction.WEST, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, Direction.NORTH, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, Direction.SOUTH, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void addBiomeDecorations(ISeedReader world, MutableBoundingBox box, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos blockPos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
                    BlockState state = this.func_175807_a((IBlockReader)world, x, y, z, box);
                    BlockState stateBelow = this.func_175807_a((IBlockReader)world, x, y - 1, z, box);
                    Block blockBelow = stateBelow.func_177230_c();
                    if (this.settings.snowChance > 0.0f && random.nextFloat() < this.settings.snowChance && state == CAVE_AIR && blockBelow != Blocks.field_150432_aD && blockBelow != Blocks.field_150403_cj && blockBelow != Blocks.field_180401_cv && stateBelow.func_224755_d((IBlockReader)world, blockPos.func_177977_b(), Direction.UP)) {
                        this.func_175811_a(world, (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((Property)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(random.nextInt(2) + 1)), x, y, z, box);
                    }
                    if (this.settings.cactusChance > 0.0f && random.nextFloat() < this.settings.cactusChance && state == CAVE_AIR && blockBelow == Blocks.field_150354_m) {
                        this.func_175811_a(world, (BlockState)Blocks.field_150434_aF.func_176223_P().func_206870_a((Property)CactusBlock.field_176587_a, (Comparable)Integer.valueOf(0)), x, y, z, box);
                        if (random.nextFloat() < 0.5f && this.func_175807_a((IBlockReader)world, x, y + 1, z, box) == CAVE_AIR) {
                            this.func_175811_a(world, (BlockState)Blocks.field_150434_aF.func_176223_P().func_206870_a((Property)CactusBlock.field_176587_a, (Comparable)Integer.valueOf(0)), x, y + 1, z, box);
                        }
                    }
                    if (this.settings.deadBushChance > 0.0f && random.nextFloat() < this.settings.deadBushChance && state == CAVE_AIR && (blockBelow == Blocks.field_150354_m || blockBelow == Blocks.field_196611_F || blockBelow == Blocks.field_150405_ch || blockBelow == Blocks.field_196777_fo || blockBelow == Blocks.field_196778_fp || blockBelow == Blocks.field_196780_fq || blockBelow == Blocks.field_196782_fr || blockBelow == Blocks.field_196783_fs || blockBelow == Blocks.field_196785_ft || blockBelow == Blocks.field_196787_fu || blockBelow == Blocks.field_196789_fv || blockBelow == Blocks.field_196791_fw || blockBelow == Blocks.field_196793_fx || blockBelow == Blocks.field_196795_fy || blockBelow == Blocks.field_196797_fz || blockBelow == Blocks.field_196719_fA || blockBelow == Blocks.field_196720_fB || blockBelow == Blocks.field_196721_fC || blockBelow == Blocks.field_196722_fD || blockBelow == Blocks.field_150346_d || blockBelow == Blocks.field_196660_k || blockBelow == Blocks.field_196661_l)) {
                        this.func_175811_a(world, Blocks.field_196555_aI.func_176223_P(), x, y, z, box);
                    }
                    if (!(this.settings.mushroomChance > 0.0f) || state != CAVE_AIR || blockBelow != Blocks.field_150391_bh && blockBelow != Blocks.field_150346_d) continue;
                    float r = random.nextFloat();
                    if (r < this.settings.mushroomChance / 2.0f) {
                        this.func_175811_a(world, Blocks.field_150337_Q.func_176223_P(), x, y, z, box);
                        continue;
                    }
                    if (!(r < this.settings.mushroomChance)) continue;
                    this.func_175811_a(world, Blocks.field_150338_P.func_176223_P(), x, y, z, box);
                }
            }
        }
    }

    private BlockSetSelector getLegSelectorForPosition(ISeedReader world, int x, int z) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(-1), this.func_74873_b(x, z));
        BlockState currBlock = world.func_180495_p((BlockPos)mutable);
        if (this.settings.flammableLegs) {
            while (mutable.func_177956_o() > 0 && (currBlock.func_185904_a() == Material.field_151579_a || LIQUIDS.contains(currBlock.func_185904_a()))) {
                if (currBlock.func_185904_a() == Material.field_151587_i) {
                    return this.getBrickSelector();
                }
                mutable.func_189536_c(Direction.DOWN);
                currBlock = world.func_180495_p((BlockPos)mutable);
            }
        }
        return this.getLegSelector();
    }

    protected void generateLeg(ISeedReader world, Random random, int x, int z) {
        BlockSetSelector selector = this.getLegSelectorForPosition(world, x, z);
        BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(-1), this.func_74873_b(x, z));
        BlockState currBlock = world.func_180495_p((BlockPos)mutable);
        while (mutable.func_177956_o() > 0 && (currBlock.func_185904_a() == Material.field_151579_a || LIQUIDS.contains(currBlock.func_185904_a()))) {
            world.func_180501_a((BlockPos)mutable, selector.get(random), 2);
            mutable.func_189536_c(Direction.DOWN);
            currBlock = world.func_180495_p((BlockPos)mutable);
        }
    }

    protected void generateLegWithSelector(ISeedReader world, Random random, int x, int z, BlockSetSelector selector) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(-1), this.func_74873_b(x, z));
        BlockState currBlock = world.func_180495_p((BlockPos)mutable);
        while (mutable.func_177956_o() > 0 && (currBlock.func_185904_a() == Material.field_151579_a || LIQUIDS.contains(currBlock.func_185904_a()))) {
            world.func_180501_a((BlockPos)mutable, selector.get(random), 2);
            mutable.func_189536_c(Direction.DOWN);
            currBlock = world.func_180495_p((BlockPos)mutable);
        }
    }

    protected void fill(ISeedReader world, MutableBoundingBox blockBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void fill(ISeedReader world, MutableBoundingBox blockBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceAir(ISeedReader world, MutableBoundingBox blockBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox);
                    if (currState == null || !currState.func_196958_f()) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceAir(ISeedReader world, MutableBoundingBox blockBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox);
                    if (currState == null || !currState.func_196958_f()) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceNonAir(ISeedReader world, MutableBoundingBox blockBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox);
                    if (currState == null || currState.func_196958_f()) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceNonAir(ISeedReader world, MutableBoundingBox blockBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox);
                    if (currState == null || currState.func_196958_f()) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceFill(ISeedReader world, MutableBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceFill(ISeedReader world, MutableBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceAir(ISeedReader world, MutableBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox)) == null || !currState.func_196958_f()) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceAir(ISeedReader world, MutableBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox)) == null || !currState.func_196958_f()) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(ISeedReader world, MutableBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox)) == null || currState.func_196958_f()) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(ISeedReader world, MutableBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox)) == null || currState.func_196958_f()) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceAddBlock(ISeedReader world, Random random, float chance, BlockState block, int x, int y, int z, MutableBoundingBox blockBox) {
        if (random.nextFloat() < chance) {
            this.func_175811_a(world, block, x, y, z, blockBox);
        }
    }

    protected BlockState getBlockStateFromPosFixed(IBlockReader blockView, int x, int y, int z, MutableBoundingBox blockBox) {
        int k;
        int j;
        int i = this.func_74865_a(x, z);
        BlockPos blockPos = new BlockPos(i, j = this.func_74862_a(y), k = this.func_74873_b(x, z));
        return !blockBox.func_175898_b((Vector3i)blockPos) ? null : blockView.func_180495_p(blockPos);
    }

    protected boolean isInOcean(ISeedReader world, int localX, int localZ) {
        BlockPos pos = new BlockPos(this.func_74865_a(localX, localZ), 1, this.func_74873_b(localX, localZ));
        Biome biome = world.func_226691_t_(pos);
        if (biome.getRegistryName() == null) {
            BetterMineshafts.LOGGER.error("Found null registry name for biome {} during ocean check. This shouldn't happen!", (Object)biome);
            return false;
        }
        RegistryKey registryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName());
        return BiomeDictionary.hasType((RegistryKey)registryKey, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN);
    }
}

