/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.inventory.container;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.integratedcrafting.RegistryEntries;
import org.cyclops.integratedcrafting.part.PartTypeInterfaceCrafting;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;

public class ContainerPartInterfaceCrafting
extends ContainerMultipart<PartTypeInterfaceCrafting, PartTypeInterfaceCrafting.State> {
    private final List<Integer> readSlotValidIds;
    private final List<Integer> readSlotErrorIds;

    public ContainerPartInterfaceCrafting(int id, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(id, playerInventory, (IInventory)new SimpleInventory(packetBuffer.readInt(), 1), Optional.empty(), Optional.empty(), (PartTypeInterfaceCrafting)PartHelpers.readPart((PacketBuffer)packetBuffer));
    }

    public ContainerPartInterfaceCrafting(int id, PlayerInventory playerInventory, IInventory inventory, Optional<PartTarget> target, Optional<IPartContainer> partContainer, PartTypeInterfaceCrafting partType) {
        super(RegistryEntries.CONTAINER_INTERFACE_CRAFTING, id, playerInventory, inventory, target, partContainer, (IPartType)partType);
        this.addInventory(inventory, 0, 8, 22, 1, inventory.func_70302_i_());
        this.addPlayerInventory(this.player.field_71071_by, 8, 59);
        this.getPartState().ifPresent(p -> p.setLastPlayer(this.player));
        this.readSlotValidIds = Lists.newArrayList();
        this.readSlotErrorIds = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            this.readSlotValidIds.add(this.getNextValueId());
            this.readSlotErrorIds.add(this.getNextValueId());
        }
        if (!this.player.func_130014_f_().func_201670_d()) {
            this.putButtonAction(ContainerMultipartAspects.BUTTON_SETTINGS, (s, containerExtended) -> PartHelpers.openContainerPartSettings((ServerPlayerEntity)((ServerPlayerEntity)this.player), (PartPos)((PartTarget)target.get()).getCenter(), (IPartType)partType));
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.getPartState().ifPresent(partState -> {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readSlotValidIds.get(i), (boolean)partState.isRecipeSlotValid(i));
                ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readSlotErrorIds.get(i), (IFormattableTextComponent)partState.getRecipeSlotUnlocalizedMessage(i));
            }
        });
    }

    public boolean isRecipeSlotValid(int slot) {
        return ValueNotifierHelpers.getValueBoolean((IValueNotifier)this, (int)this.readSlotValidIds.get(slot));
    }

    @Nullable
    public ITextComponent getRecipeSlotUnlocalizedMessage(int slot) {
        return ValueNotifierHelpers.getValueTextComponent((IValueNotifier)this, (int)this.readSlotErrorIds.get(slot));
    }

    protected Slot createNewSlot(IInventory inventory, int index, int x, int y) {
        if (inventory instanceof SimpleInventory) {
            return new SlotVariable(inventory, index, x, y){

                public boolean func_75214_a(ItemStack itemStack) {
                    IVariableFacade variableFacade = RegistryEntries.ITEM_VARIABLE.getVariableFacade(itemStack);
                    return variableFacade != null && ValueHelpers.correspondsTo((IValueType)variableFacade.getOutputType(), (IValueType)ValueTypes.OBJECT_RECIPE) && super.func_75214_a(itemStack);
                }
            };
        }
        return super.createNewSlot(inventory, index, x, y);
    }

    public void onDirty() {
    }
}

