/*
 * Decompiled with CFR 0.152.
 */
package me.lambdaurora.lambdynlights.mixin;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Objects;
import me.lambdaurora.lambdynlights.DynamicLightSource;
import me.lambdaurora.lambdynlights.DynamicLightsReforged;
import me.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import me.lambdaurora.lambdynlights.config.DynamicLightsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements DynamicLightSource {
    @Shadow
    public World field_70170_p;
    @Shadow
    public boolean field_70128_L;
    @Shadow
    public int field_70176_ah;
    @Shadow
    public int field_70164_aj;
    private int lambdynlights_luminance = 0;
    private int lambdynlights_lastLuminance = 0;
    private long lambdynlights_lastUpdate = 0L;
    private double lambdynlights_prevX;
    private double lambdynlights_prevY;
    private double lambdynlights_prevZ;
    private LongOpenHashSet trackedLitChunkPos = new LongOpenHashSet();

    @Shadow
    public abstract double func_226277_ct_();

    @Shadow
    public abstract double func_226280_cw_();

    @Shadow
    public abstract double func_226281_cx_();

    @Shadow
    public abstract double func_226278_cu_();

    @Shadow
    public abstract boolean func_70027_ad();

    @Shadow
    public abstract EntityType<?> func_200600_R();

    @Shadow
    public abstract BlockPos func_233580_cy_();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        if (this.field_70170_p.func_201670_d()) {
            if (this.field_70128_L) {
                this.setDynamicLightEnabled(false);
            } else {
                this.dynamicLightTick();
                if (!((Boolean)DynamicLightsConfig.EntityLighting.get()).booleanValue() && this.func_200600_R() != EntityType.field_200729_aH) {
                    this.lambdynlights_luminance = 0;
                }
                DynamicLightsReforged.updateTracking(this);
            }
        }
    }

    @Inject(method={"remove"}, at={@At(value="TAIL")})
    public void onRemove(CallbackInfo ci) {
        if (this.field_70170_p.func_201670_d()) {
            this.setDynamicLightEnabled(false);
        }
    }

    @Override
    public double getDynamicLightX() {
        return this.func_226277_ct_();
    }

    @Override
    public double getDynamicLightY() {
        return this.func_226280_cw_();
    }

    @Override
    public double getDynamicLightZ() {
        return this.func_226281_cx_();
    }

    @Override
    public World getDynamicLightWorld() {
        return this.field_70170_p;
    }

    @Override
    public void resetDynamicLight() {
        this.lambdynlights_lastLuminance = 0;
    }

    @Override
    public boolean shouldUpdateDynamicLight() {
        return DynamicLightsReforged.ShouldUpdateDynamicLights();
    }

    @Override
    public void dynamicLightTick() {
        this.lambdynlights_luminance = this.func_70027_ad() ? 15 : 0;
        int luminance = DynamicLightHandlers.getLuminanceFrom((Entity)this);
        if (luminance > this.lambdynlights_luminance) {
            this.lambdynlights_luminance = luminance;
        }
    }

    @Override
    public int getLuminance() {
        return this.lambdynlights_luminance;
    }

    @Override
    public boolean lambdynlights_updateDynamicLight(@NotNull WorldRenderer renderer) {
        if (!this.shouldUpdateDynamicLight()) {
            return false;
        }
        double deltaX = this.func_226277_ct_() - this.lambdynlights_prevX;
        double deltaY = this.func_226278_cu_() - this.lambdynlights_prevY;
        double deltaZ = this.func_226281_cx_() - this.lambdynlights_prevZ;
        int luminance = this.getLuminance();
        double minDelta = 0.0;
        String mode = (String)DynamicLightsConfig.Quality.get();
        if (Objects.equals(mode, "SLOW")) {
            minDelta = 0.5;
        }
        if (Objects.equals(mode, "FAST")) {
            minDelta = 0.2;
        }
        if (Math.abs(deltaX) > minDelta || Math.abs(deltaY) > minDelta || Math.abs(deltaZ) > minDelta || luminance != this.lambdynlights_lastLuminance) {
            this.lambdynlights_prevX = this.func_226277_ct_();
            this.lambdynlights_prevY = this.func_226278_cu_();
            this.lambdynlights_prevZ = this.func_226281_cx_();
            this.lambdynlights_lastLuminance = luminance;
            LongOpenHashSet newPos = new LongOpenHashSet();
            if (luminance > 0) {
                BlockPos.Mutable chunkPos = new BlockPos.Mutable(this.field_70176_ah, MathHelper.func_76137_a((int)((int)this.func_226280_cw_()), (int)16), this.field_70164_aj);
                DynamicLightsReforged.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                DynamicLightsReforged.updateTrackedChunks((BlockPos)chunkPos, this.trackedLitChunkPos, newPos);
                Direction directionX = (this.func_233580_cy_().func_177958_n() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
                Direction directionY = (MathHelper.func_76140_b((double)this.func_226280_cw_()) & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
                Direction directionZ = (this.func_233580_cy_().func_177952_p() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.func_189536_c(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.func_189536_c(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.func_189536_c(directionX.func_176734_d());
                    } else {
                        chunkPos.func_189536_c(directionZ.func_176734_d());
                        chunkPos.func_189536_c(directionY);
                    }
                    DynamicLightsReforged.scheduleChunkRebuild(renderer, (BlockPos)chunkPos);
                    DynamicLightsReforged.updateTrackedChunks((BlockPos)chunkPos, this.trackedLitChunkPos, newPos);
                }
            }
            this.lambdynlights_scheduleTrackedChunksRebuild(renderer);
            this.trackedLitChunkPos = newPos;
            return true;
        }
        return false;
    }

    @Override
    public void lambdynlights_scheduleTrackedChunksRebuild(@NotNull WorldRenderer renderer) {
        if (Minecraft.func_71410_x().field_71441_e == this.field_70170_p) {
            LongIterator longIterator = this.trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                DynamicLightsReforged.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

