/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.world.gen.feature;

import com.minecraftabnormals.upgrade_aquatic.common.blocks.MulberryVineBlock;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.IPlantable;

public class RiverTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    public RiverTreeFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    public boolean place(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos position, BaseTreeFeatureConfig config) {
        int height = 3 + rand.nextInt(2) + rand.nextInt(2);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= worldIn.func_217301_I()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_217301_I()) {
                            if (RiverTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (RiverTreeFeature.isValidGround((IWorld)worldIn, position.func_177977_b()) && position.func_177956_o() < worldIn.func_217301_I() - height - 1) {
                RiverTreeFeature.setDirtAt((IWorld)worldIn, position.func_177977_b());
                int logX = position.func_177958_n();
                int logZ = position.func_177952_p();
                int logY = position.func_177956_o();
                for (int k1 = 0; k1 < height; ++k1) {
                    logY = position.func_177956_o() + k1;
                    BlockPos blockpos = new BlockPos(logX, logY, logZ);
                    if (!RiverTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, blockpos)) continue;
                    this.placeLogAt((IWorldWriter)worldIn, blockpos, rand, config);
                }
                logY = position.func_177956_o() + height - rand.nextInt(2);
                position = new BlockPos(logX, logY, logZ);
                this.createLeaves((IWorldGenerationReader)worldIn, position.func_177977_b(), rand, false, config);
                this.createLeaves((IWorldGenerationReader)worldIn, position, rand, false, config);
                this.createLeaves((IWorldGenerationReader)worldIn, position.func_177984_a(), rand, true, config);
                this.placeLeafAt((IWorldGenerationReader)worldIn, position.func_177984_a(), rand, config);
                this.placeLeafAt((IWorldGenerationReader)worldIn, position.func_177981_b(2), rand, config);
                return true;
            }
            return false;
        }
        return false;
    }

    private void createLeaves(IWorldGenerationReader worldIn, BlockPos newPos, Random rand, boolean small, BaseTreeFeatureConfig config) {
        int leafSize = 1;
        for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
            for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                if (small) {
                    if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize || rand.nextInt(3) == 0) continue;
                    this.placeLeafAt(worldIn, newPos.func_177982_a(k3, 0, j4), rand, null);
                    continue;
                }
                if (Math.abs(k3) != leafSize || Math.abs(j4) != leafSize) {
                    this.placeLeafAt(worldIn, newPos.func_177982_a(k3, 0, j4), rand, config);
                    continue;
                }
                if (rand.nextInt(4) != 0) continue;
                this.placeLeafAt(worldIn, newPos.func_177982_a(k3, 0, j4), rand, config);
            }
        }
    }

    private void placeLogAt(IWorldWriter worldIn, BlockPos pos, Random rand, BaseTreeFeatureConfig config) {
        this.setLogState(worldIn, pos, ((Block)UABlocks.RIVER_LOG.get()).func_176223_P());
    }

    private void placeLeafAt(IWorldGenerationReader world, BlockPos pos, Random rand, BaseTreeFeatureConfig config) {
        BlockState state;
        if (RiverTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)world, pos)) {
            this.setLogState((IWorldWriter)world, pos, (BlockState)((Block)UABlocks.RIVER_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)));
        }
        if (RiverTreeFeature.isAir((IWorldGenerationBaseReader)world, pos.func_177977_b()) && rand.nextInt(3) == 0 && rand.nextBoolean() && (state = (BlockState)((BlockState)((Block)UABlocks.MULBERRY_VINE.get()).func_176223_P().func_206870_a((Property)MulberryVineBlock.AGE, (Comparable)Integer.valueOf(4))).func_206870_a((Property)MulberryVineBlock.DOUBLE, (Comparable)Boolean.valueOf(rand.nextBoolean()))).func_196955_c((IWorldReader)world, pos.func_177977_b())) {
            this.setLogState((IWorldWriter)world, pos.func_177977_b(), state);
        }
    }

    protected final void setLogState(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, state, 18);
    }

    public static boolean isAir(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (!(worldIn instanceof IBlockReader)) {
            return worldIn.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f);
        }
        return worldIn.func_217375_a(pos, state -> state.isAir((IBlockReader)worldIn, pos));
    }

    public static boolean isAirOrLeaves(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        if (worldIn instanceof IWorldReader) {
            return worldIn.func_217375_a(pos, state -> state.canBeReplacedByLeaves((IWorldReader)worldIn, pos));
        }
        return worldIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    public static void setDirtAt(IWorld worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_196658_i || block == Blocks.field_150458_ak) {
            worldIn.func_180501_a(pos, Blocks.field_150346_d.func_176223_P(), 18);
        }
    }

    public static boolean isValidGround(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)UABlocks.RIVER_SAPLING.get());
    }
}

