/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.capability;

import com.github.lehjr.numina.util.capabilities.heat.HeatCapability;
import com.github.lehjr.numina.util.capabilities.heat.HeatItemWrapper;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.ModularItem;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.NuminaRangedWrapper;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.powersuits.capability.AbstractModularPowerCap;
import com.github.lehjr.powersuits.client.render.ArmorModelSpecNBT;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.constants.MPSRegistryNames;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PowerArmorCap
extends AbstractModularPowerCap {
    double maxHeat;

    public PowerArmorCap(@Nonnull ItemStack itemStackIn, EquipmentSlotType slot) {
        this.itemStack = itemStackIn;
        this.targetSlot = slot;
        this.modelSpec = new ArmorModelSpecNBT(itemStackIn);
        final HashMap rangedWrapperMap = new HashMap();
        switch (this.targetSlot) {
            case HEAD: {
                this.modularItemCap = new ModularItem(this.itemStack, 18){
                    {
                        super(arg0, arg1);
                        rangedWrapperMap.put(EnumModuleCategory.ARMOR, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                        rangedWrapperMap.put(EnumModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, 2));
                        rangedWrapperMap.put(EnumModuleCategory.ENERGY_GENERATION, new NuminaRangedWrapper((IItemHandlerModifiable)this, 2, 3));
                        rangedWrapperMap.put(EnumModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 3, this.getSlots()));
                        this.setRangedWrapperMap(rangedWrapperMap);
                    }
                };
                this.maxHeat = MPSSettings.getMaxHeatHelmet();
                break;
            }
            case CHEST: {
                this.modularItemCap = new ModularItem(this.itemStack, 18){
                    {
                        super(arg0, arg1);
                        rangedWrapperMap.put(EnumModuleCategory.ARMOR, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                        rangedWrapperMap.put(EnumModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, 2));
                        rangedWrapperMap.put(EnumModuleCategory.ENERGY_GENERATION, new NuminaRangedWrapper((IItemHandlerModifiable)this, 2, 3));
                        rangedWrapperMap.put(EnumModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 3, this.getSlots()));
                        this.setRangedWrapperMap(rangedWrapperMap);
                    }
                };
                this.maxHeat = MPSSettings.getMaxHeatChestplate();
                break;
            }
            case LEGS: {
                this.modularItemCap = new ModularItem(itemStackIn, 10){
                    {
                        super(arg0, arg1);
                        rangedWrapperMap.put(EnumModuleCategory.ARMOR, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                        rangedWrapperMap.put(EnumModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, 2));
                        rangedWrapperMap.put(EnumModuleCategory.ENERGY_GENERATION, new NuminaRangedWrapper((IItemHandlerModifiable)this, 2, 3));
                        rangedWrapperMap.put(EnumModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 3, this.getSlots()));
                        this.setRangedWrapperMap(rangedWrapperMap);
                    }
                };
                this.maxHeat = MPSSettings.getMaxHeatLegs();
                break;
            }
            case FEET: {
                this.modularItemCap = new ModularItem(this.itemStack, 8){
                    {
                        super(arg0, arg1);
                        rangedWrapperMap.put(EnumModuleCategory.ARMOR, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                        rangedWrapperMap.put(EnumModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, 2));
                        rangedWrapperMap.put(EnumModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 2, this.getSlots()));
                        this.setRangedWrapperMap(rangedWrapperMap);
                    }
                };
                this.maxHeat = MPSSettings.getMaxHeatBoots();
            }
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == null) {
            return LazyOptional.empty();
        }
        if (cap == HeatCapability.HEAT) {
            this.modularItemCap.updateFromNBT();
            this.heatStorage = new HeatItemWrapper(this.itemStack, this.maxHeat, this.modularItemCap.getStackInSlot(0).getCapability(PowerModuleCapability.POWER_MODULE));
            this.heatStorage.updateFromNBT();
            return HeatCapability.HEAT.orEmpty(cap, LazyOptional.of(() -> this.heatStorage));
        }
        if (this.targetSlot == EquipmentSlotType.CHEST && cap == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            this.modularItemCap.updateFromNBT();
            return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> (IFluidHandlerItem)this.modularItemCap.getOnlineModuleOrEmpty(MPSRegistryNames.FLUID_TANK_MODULE_REGNAME).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse((Object)new EmptyFluidHandler())));
        }
        return super.getCapability(cap, side);
    }

    class EmptyFluidHandler
    extends FluidHandlerItemStack {
        public EmptyFluidHandler() {
            super(ItemStack.field_190927_a, 0);
        }
    }
}

