/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.capability;

import com.github.lehjr.numina.util.capabilities.heat.HeatCapability;
import com.github.lehjr.numina.util.capabilities.heat.HeatItemWrapper;
import com.github.lehjr.numina.util.capabilities.inventory.modechanging.ModeChangingModularItem;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.NuminaRangedWrapper;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.powersuits.capability.AbstractModularPowerCap;
import com.github.lehjr.powersuits.client.render.PowerFistSpecNBT;
import com.github.lehjr.powersuits.config.MPSSettings;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PowerFistCap
extends AbstractModularPowerCap {
    public PowerFistCap(@Nonnull ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
        this.targetSlot = EquipmentSlotType.MAINHAND;
        this.modularItemCap = new ModeChangingModularItem(this.itemStack, 40){
            {
                HashMap<EnumModuleCategory, NuminaRangedWrapper> rangedWrapperMap = new HashMap<EnumModuleCategory, NuminaRangedWrapper>();
                rangedWrapperMap.put(EnumModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                rangedWrapperMap.put(EnumModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, this.getSlots()));
                this.setRangedWrapperMap(rangedWrapperMap);
            }
        };
        this.modelSpec = new PowerFistSpecNBT(this.itemStack);
        this.heatStorage = new HeatItemWrapper(this.itemStack, MPSSettings.getMaxHeatPowerFist());
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == null) {
            return LazyOptional.empty();
        }
        if (cap == HeatCapability.HEAT) {
            this.heatStorage.updateFromNBT();
            return HeatCapability.HEAT.orEmpty(cap, LazyOptional.of(() -> this.heatStorage));
        }
        return super.getCapability(cap, side);
    }
}

