/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.control;

import com.github.lehjr.numina.basemod.MuseLogger;
import com.github.lehjr.numina.config.ConfigHelper;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.client.control.KeyBindingHelper;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableModule;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.powersuits.client.gui.clickable.ClickableKeybinding;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public enum KeybindManager {
    INSTANCE;

    private static final KeyBindingHelper keyBindingHelper;
    protected final Set<ClickableKeybinding> keybindings = new HashSet<ClickableKeybinding>();

    public Set<ClickableKeybinding> getKeybindings() {
        return this.keybindings;
    }

    public void remove(ClickableKeybinding keybinding) {
        this.keybindings.remove((Object)keybinding);
        this.writeOutKeybinds();
    }

    public KeyBinding addKeybinding(String keybindDescription, InputMappings.Input keyCode, MusePoint2D position) {
        KeyBinding kb = new KeyBinding(keybindDescription, keyCode.func_197937_c(), "Modular Powersuits");
        boolean free = !keyBindingHelper.keyBindingHasKey(keyCode);
        this.keybindings.add(new ClickableKeybinding(kb, position, free, false));
        return kb;
    }

    public String parseName(KeyBinding keybind) {
        if (keybind.getKey().func_197937_c() < 0) {
            return "Mouse" + (keybind.getKey().func_197937_c() + 100);
        }
        return keybind.getKey().func_197935_d();
    }

    public void writeOutKeybinds() {
        try {
            File file = new File(ConfigHelper.setupConfigFile((String)"powersuits-keybinds.cfg", (String)"powersuits").getAbsolutePath());
            if (!file.exists()) {
                Files.createDirectories(file.toPath().getParent(), new FileAttribute[0]);
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file, false);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            NonNullList modulesToWrite = NonNullList.func_191196_a();
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
                player.func_184582_a(slot).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iItemHandler -> modulesToWrite.addAll((Collection)iItemHandler.getInstalledModules()));
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (ClickableKeybinding keybinding : this.keybindings) {
                stringBuilder.append(keybinding.getKeyBinding().getKey().func_197937_c()).append(":").append(keybinding.getPosition().getX()).append(':').append(keybinding.getPosition().getY()).append(':').append(keybinding.displayOnHUD).append(':').append(keybinding.toggleval).append('\n');
                for (ClickableModule module : keybinding.getBoundModules()) {
                    stringBuilder.append(module.getModule().func_77973_b().getRegistryName().func_110623_a()).append('~').append(module.getPosition().getX()).append('~').append(module.getPosition().getY()).append('\n');
                }
            }
            String out = stringBuilder.toString();
            fileWriter.write(out);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception e) {
            MuseLogger.logger.error("Problem writing out keyconfig :(");
            e.printStackTrace();
        }
    }

    public void readInKeybinds() {
        try {
            File file = new File(ConfigHelper.setupConfigFile((String)"powersuits-keybinds.cfg", (String)"powersuits").getAbsolutePath());
            if (!file.exists()) {
                MuseLogger.logger.error("No modular power armor keybind file found.");
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            ClickableKeybinding workingKeybinding = null;
            while (reader.ready()) {
                String[] exploded;
                String line = reader.readLine();
                if (line.contains(":")) {
                    exploded = line.split(":");
                    int id = Integer.parseInt(exploded[0]);
                    if (!keyBindingHelper.keyBindingHasKey(id)) {
                        MusePoint2D position = new MusePoint2D((double)Float.parseFloat(exploded[1]), (double)Float.parseFloat(exploded[2]));
                        boolean free = !keyBindingHelper.keyBindingHasKey(id);
                        boolean displayOnHUD = false;
                        boolean toggleval = false;
                        if (exploded.length > 3) {
                            displayOnHUD = Boolean.parseBoolean(exploded[3]);
                        }
                        if (exploded.length > 4) {
                            toggleval = Boolean.parseBoolean(exploded[4]);
                        }
                        workingKeybinding = new ClickableKeybinding(new KeyBinding(KeyBindingHelper.getInputByCode((int)id).func_197935_d(), id, "Modular Powersuits"), position, free, displayOnHUD);
                        workingKeybinding.toggleval = toggleval;
                        this.keybindings.add(workingKeybinding);
                        continue;
                    }
                    workingKeybinding = null;
                    continue;
                }
                if (!line.contains("~") || workingKeybinding == null) continue;
                exploded = line.split("~");
                MusePoint2D position = new MusePoint2D((double)Float.parseFloat(exploded[1]), (double)Float.parseFloat(exploded[2]));
                ItemStack module = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("powersuits", exploded[0])));
                if (module.func_190926_b()) continue;
                ClickableModule cmodule = new ClickableModule(module, position, -1, EnumModuleCategory.NONE);
                workingKeybinding.bindModule(cmodule);
            }
            reader.close();
        }
        catch (Exception e) {
            MuseLogger.logger.error("Problem reading in keyconfig :(");
            e.printStackTrace();
        }
    }

    static {
        keyBindingHelper = new KeyBindingHelper();
    }
}

