/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.keybind;

import com.github.lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.rightclick.IRightClickModule;
import com.github.lehjr.numina.util.capabilities.module.toggleable.IToggleableModule;
import com.github.lehjr.numina.util.client.control.KeyBindingHelper;
import com.github.lehjr.numina.util.client.gui.ContainerlessGui;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableButton2;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableModule;
import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.frame.IGuiFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.GradientAndArcCalculator;
import com.github.lehjr.numina.util.client.gui.gemoetry.IRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.math.MuseMathUtils;
import com.github.lehjr.powersuits.client.control.KeybindManager;
import com.github.lehjr.powersuits.client.gui.clickable.ClickableKeybinding;
import com.github.lehjr.powersuits.client.gui.common.TabSelectFrame;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;

public class TinkerKeybindGui
extends ContainerlessGui {
    private PlayerEntity player;
    TabSelectFrame tabSelectFrame;
    private static KeyBindingHelper keyBindingHelper = new KeyBindingHelper();
    protected Set<ClickableModule> modules = new HashSet<ClickableModule>();
    protected IClickable selectedClickie;
    protected ClickableKeybinding closestKeybind;
    protected boolean selecting;
    protected ClickableButton2 newKeybindButton;
    protected ClickableButton2 trashKeybindButton;
    protected long takenTime;
    KeybindManager keybindManager = KeybindManager.INSTANCE;

    public TinkerKeybindGui(PlayerInventory playerInventory, ITextComponent title) {
        super(title, 340, 217, false);
        this.backgroundRect.setBackgroundColour(Colour.DARK_GREY);
        KeybindManager.INSTANCE.readInKeybinds();
        this.player = playerInventory.field_70458_d;
        this.tabSelectFrame = new TabSelectFrame(this.player, 2);
        this.addFrame((IGuiFrame)this.tabSelectFrame);
        for (ClickableKeybinding kb : this.keybindManager.getKeybindings()) {
            this.modules.addAll(kb.getBoundModules());
        }
        this.newKeybindButton = new ClickableButton2((ITextComponent)new TranslationTextComponent("gui.powersuits.newKeybind"), this.center().plus(new MusePoint2D(0.0, -8.0)), true);
        this.trashKeybindButton = new ClickableButton2((ITextComponent)new TranslationTextComponent("gui.powersuits.trashKeybind"), this.center().plus(new MusePoint2D(0.0, 8.0)), true);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.tabSelectFrame.initFromBackgroundRect((IRect)this.backgroundRect);
        this.newKeybindButton.setPosition(this.backgroundRect.center().plus(new MusePoint2D(0.0, -8.0)));
        this.trashKeybindButton.setPosition(this.backgroundRect.center().plus(new MusePoint2D(0.0, 8.0)));
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int p_keyPressed_3_) {
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode == 256 || this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            KeybindManager.INSTANCE.writeOutKeybinds();
            this.field_230706_i_.field_71439_g.func_71053_j();
            return true;
        }
        int key = keyCode;
        if (this.selecting) {
            if (keyBindingHelper.keyBindingHasKey(key)) {
                System.out.println("conflicting");
                this.takenTime = System.currentTimeMillis();
                if (MPSSettings.allowConfictingKeyBinds()) {
                    this.addKeybind(key, false);
                }
            } else {
                this.addKeybind(key, true);
            }
            this.selecting = false;
        }
        return super.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
    }

    public boolean func_231044_a_(double x, double y, int button) {
        if (this.backgroundRect.containsPoint(x, y)) {
            if (button == 0) {
                if (this.selectedClickie == null) {
                    for (ClickableModule module : this.modules) {
                        if (!module.hitBox(x, y)) continue;
                        this.selectedClickie = module;
                        return true;
                    }
                    for (ClickableKeybinding keybind : this.keybindManager.getKeybindings()) {
                        if (!keybind.hitBox(x, y)) continue;
                        this.selectedClickie = keybind;
                        return true;
                    }
                }
                if (this.newKeybindButton.hitBox(x, y)) {
                    this.selecting = true;
                }
            } else if (button == 1) {
                for (ClickableKeybinding keybind : this.keybindManager.getKeybindings()) {
                    if (!keybind.hitBox(x, y)) continue;
                    keybind.toggleHUDState();
                    return true;
                }
            } else if (button > 2) {
                int key = button - 100;
                if (keyBindingHelper.keyBindingHasKey(key)) {
                    this.takenTime = System.currentTimeMillis();
                }
                if (!keyBindingHelper.keyBindingHasKey(key)) {
                    this.addKeybind(key, true);
                } else if (MPSSettings.allowConfictingKeyBinds()) {
                    this.addKeybind(key, false);
                }
                this.selecting = false;
            }
            return true;
        }
        return super.func_231044_a_(x, y, button);
    }

    public void refreshModules() {
        NonNullList installedModules = NonNullList.func_191196_a();
        block4: for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            switch (slot.func_188453_a()) {
                case HAND: {
                    this.player.func_184582_a(slot).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(iModeChanging -> {
                        for (int i = 0; i < iModeChanging.getSlots(); ++i) {
                            ItemStack module = iModeChanging.getStackInSlot(i);
                            if (!module.getCapability(PowerModuleCapability.POWER_MODULE).map(c -> IToggleableModule.class.isAssignableFrom(c.getClass())).orElse(false).booleanValue() || !module.getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> {
                                if (pm.getCategory() == EnumModuleCategory.MINING_ENHANCEMENT) {
                                    return true;
                                }
                                return !IRightClickModule.class.isAssignableFrom(pm.getClass());
                            }).orElse(false).booleanValue()) continue;
                            installedModules.add((Object)module);
                        }
                    });
                    continue block4;
                }
                case ARMOR: {
                    if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue block4;
                    this.player.func_184582_a(slot).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iModularItem -> installedModules.addAll((Collection)iModularItem.getInstalledModulesOfType(IToggleableModule.class)));
                }
            }
        }
        List points = GradientAndArcCalculator.pointsInLine((int)installedModules.size(), (MusePoint2D)new MusePoint2D(this.backgroundRect.finalLeft() + 10.0, this.backgroundRect.finalTop() + 10.0), (MusePoint2D)new MusePoint2D(this.backgroundRect.finalLeft() + 10.0, this.backgroundRect.finalBottom() - 10.0));
        Iterator pointIterator = points.iterator();
        for (ItemStack module : installedModules) {
            if (this.alreadyAdded(module)) continue;
            ClickableModule clickie = new ClickableModule(module, (MusePoint2D)pointIterator.next(), -1, EnumModuleCategory.NONE);
            this.modules.add(clickie);
        }
    }

    public boolean alreadyAdded(@Nonnull ItemStack module) {
        if (module.func_190926_b()) {
            return false;
        }
        for (ClickableModule clickie : this.modules) {
            if (!ItemStack.func_179545_c((ItemStack)clickie.getModule(), (ItemStack)module)) continue;
            return true;
        }
        return false;
    }

    public boolean func_231048_c_(double x, double y, int button) {
        if (button == 0) {
            if (this.selectedClickie != null && this.closestKeybind != null && this.selectedClickie instanceof ClickableModule) {
                this.closestKeybind.bindModule((ClickableModule)this.selectedClickie);
            } else if (this.selectedClickie != null && this.selectedClickie instanceof ClickableKeybinding && this.trashKeybindButton.hitBox((double)((float)x), (double)((float)y))) {
                KeyBinding binding = ((ClickableKeybinding)this.selectedClickie).getKeyBinding();
                keyBindingHelper.removeKey(binding);
                keyBindingHelper.removeKey(binding);
                this.keybindManager.remove((ClickableKeybinding)this.selectedClickie);
            }
            this.selectedClickie = null;
        }
        return super.func_231048_c_(x, y, button);
    }

    public void update(double mouseX, double mouseY) {
        super.update(mouseX, mouseY);
        if (this.selecting) {
            return;
        }
        this.refreshModules();
        this.closestKeybind = null;
        double closestDistance = Double.MAX_VALUE;
        if (this.selectedClickie != null) {
            this.selectedClickie.setPosition(new MusePoint2D(mouseX, mouseY));
            if (this.selectedClickie instanceof ClickableModule) {
                ClickableModule selectedModule = (ClickableModule)this.selectedClickie;
                for (ClickableKeybinding keybind : this.keybindManager.getKeybindings()) {
                    double distance = keybind.getPosition().minus(selectedModule.getPosition()).distance();
                    if (!(distance < closestDistance) || !((closestDistance = distance) < 32.0)) continue;
                    this.closestKeybind = keybind;
                }
            }
        }
        for (ClickableKeybinding clickableKeybinding : this.keybindManager.getKeybindings()) {
            if (clickableKeybinding != this.selectedClickie) {
                clickableKeybinding.unbindFarModules();
            }
            clickableKeybinding.attractBoundModules(this.selectedClickie);
        }
        for (IClickable iClickable : this.modules) {
            if (iClickable == this.selectedClickie) continue;
            this.repelOtherModules(iClickable);
        }
        for (IClickable iClickable : this.keybindManager.getKeybindings()) {
            if (iClickable == this.selectedClickie) continue;
            this.repelOtherModules(iClickable);
        }
        for (IClickable iClickable : this.modules) {
            this.clampClickiePosition(iClickable);
        }
        for (IClickable iClickable : this.keybindManager.getKeybindings()) {
            this.clampClickiePosition(iClickable);
        }
    }

    private void clampClickiePosition(IClickable clickie) {
        clickie.setPosition(new MusePoint2D(MuseMathUtils.clampDouble((double)clickie.getPosition().getX(), (double)this.backgroundRect.finalLeft(), (double)this.backgroundRect.finalRight()), MuseMathUtils.clampDouble((double)clickie.getPosition().getY(), (double)this.backgroundRect.finalTop(), (double)this.backgroundRect.finalBottom())));
    }

    private void repelOtherModules(IClickable module) {
        MusePoint2D modulePosition = module.getPosition();
        for (ClickableModule otherModule : this.modules) {
            if (otherModule == this.selectedClickie || otherModule == module || !(otherModule.getPosition().distanceTo(modulePosition) < 16.0)) continue;
            MusePoint2D euclideanDistance = otherModule.getPosition().minus(module.getPosition());
            MusePoint2D directionVector = euclideanDistance.normalize();
            MusePoint2D tangentTarget = directionVector.times(16.0).plus(module.getPosition());
            MusePoint2D midpointTangent = otherModule.getPosition().midpoint(tangentTarget);
            if (midpointTangent.distanceTo(module.getPosition()) > 2.0) {
                otherModule.setPosition(midpointTangent.copy());
            }
            MusePoint2D away = directionVector.times(0.0).plus(modulePosition);
            module.setPosition(away.copy());
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (!this.selecting) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 10.0);
            if (this.takenTime + 1000L <= System.currentTimeMillis()) {
                for (ClickableModule module : this.modules) {
                    module.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                }
                for (ClickableKeybinding keybind : this.keybindManager.getKeybindings()) {
                    keybind.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                }
                if (this.selectedClickie != null && this.closestKeybind != null) {
                    MuseRenderer.drawLineBetween((IClickable)this.selectedClickie, (IClickable)this.closestKeybind, (Colour)Colour.YELLOW, (float)this.func_230927_p_());
                }
                this.newKeybindButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
                this.trashKeybindButton.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
            this.drawToolTip(matrixStack, mouseX, mouseY);
            matrixStack.func_227865_b_();
        }
    }

    public void renderLabels(MatrixStack matrixStack, int mouseX, int mouseY) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 100.0);
        MusePoint2D center = this.backgroundRect.center();
        if (this.selecting) {
            MuseRenderer.drawShadowedStringCentered((MatrixStack)matrixStack, (ITextComponent)new TranslationTextComponent("gui.powersuits.pressKey"), (double)center.getX(), (double)center.getY());
        } else {
            super.renderLabels(matrixStack, mouseX, mouseY);
            if (this.takenTime + 1000L > System.currentTimeMillis()) {
                MusePoint2D pos = this.newKeybindButton.getPosition().plus(new MusePoint2D(0.0, -20.0));
                MuseRenderer.drawShadowedStringCentered((MatrixStack)matrixStack, (ITextComponent)new TranslationTextComponent("gui.powersuits.keybindTaken"), (double)pos.getX(), (double)pos.getY());
                matrixStack.func_227865_b_();
                return;
            }
            MuseRenderer.drawShadowedStringCentered((MatrixStack)matrixStack, (ITextComponent)new TranslationTextComponent("gui.powersuits.keybindInstructions1"), (double)center.getX(), (double)(center.getY() + 40.0));
            MuseRenderer.drawShadowedStringCentered((MatrixStack)matrixStack, (ITextComponent)new TranslationTextComponent("gui.powersuits.keybindInstructions2"), (double)center.getX(), (double)(center.getY() + 50.0));
            MuseRenderer.drawShadowedStringCentered((MatrixStack)matrixStack, (ITextComponent)new TranslationTextComponent("gui.powersuits.keybindInstructions3"), (double)center.getX(), (double)(center.getY() + 60.0));
            MuseRenderer.drawShadowedStringCentered((MatrixStack)matrixStack, (ITextComponent)new TranslationTextComponent("gui.powersuits.keybindInstructions4"), (double)center.getX(), (double)(center.getY() + 70.0));
        }
        matrixStack.func_227865_b_();
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        for (ClickableModule module : this.modules) {
            if (!module.hitBox((double)x, (double)y)) continue;
            return module.getToolTip(x, y);
        }
        return null;
    }

    private void addKeybind(int key, boolean free) {
        this.addKeybind(KeyBindingHelper.getInputByCode((int)key), free);
    }

    private void addKeybind(InputMappings.Input key, boolean free) {
        String name;
        try {
            name = key.func_197935_d();
        }
        catch (Exception e) {
            name = "???";
        }
        KeyBinding keybind = new KeyBinding(name, key.func_197937_c(), "Modular Powersuits");
        if (!this.keybindManager.getKeybindings().stream().filter(clickableKeybinding -> {
            System.out.println(clickableKeybinding.getKeyBinding().getKey());
            return clickableKeybinding.getKeyBinding().getKey().equals((Object)key);
        }).findFirst().isPresent()) {
            ClickableKeybinding clickie = new ClickableKeybinding(keybind, this.newKeybindButton.getPosition().plus(new MusePoint2D(0.0, -20.0)), free, false);
            this.keybindManager.getKeybindings().add(clickie);
        }
    }
}

