/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.modding.cosmetic;

import com.github.lehjr.numina.basemod.MuseLogger;
import com.github.lehjr.numina.util.capabilities.render.IModelSpecNBT;
import com.github.lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import com.github.lehjr.numina.util.client.gui.GuiIcon;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableLabel;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableSlider;
import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.frame.GUISpacer;
import com.github.lehjr.numina.util.client.gui.frame.ScrollableMultiRectFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableTile;
import com.github.lehjr.numina.util.client.gui.gemoetry.IDrawableRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.IRect;
import com.github.lehjr.numina.util.client.render.MuseIconUtils;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.powersuits.client.gui.common.ModularItemSelectionFrame;
import com.github.lehjr.powersuits.network.MPSPackets;
import com.github.lehjr.powersuits.network.packets.ColourInfoPacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ColourPickerFrame
extends ScrollableMultiRectFrame {
    public ModularItemSelectionFrame itemSelector;
    protected ClickableSlider[] sliders = new ClickableSlider[4];
    final String[] slidersIds = new String[]{"red", "green", "blue", "alpha"};
    ScrollableColourBox colourBox;
    String COLOUR_PREFIX = I18n.func_135052_a((String)"gui.powersuits.colourPrefix", (Object[])new Object[0]);
    public ClickableLabel colourLabel;
    public Optional<ClickableSlider> selectedSlider = Optional.empty();
    public int selectedColour;
    public int decrAbove;

    public ColourPickerFrame(ModularItemSelectionFrame itemSelector, double width, double height) {
        super(true, width, height, width, height);
        this.setBackground((IDrawableRect)new DrawableTile(0.0, 0.0, 0.0, 0.0));
        this.setMargin(7.0);
        this.itemSelector = itemSelector;
        this.setTotalSize(120);
        this.addRect((IRect)new GUISpacer(width - this.margin * 2.0, 6.0));
        for (int i = 0; i < 4; ++i) {
            this.sliders[i] = this.getSlider(this.slidersIds[i], i, width - this.margin * 2.0);
        }
        this.colourBox = new ScrollableColourBox();
        this.colourBox.setWidth(width - this.margin * 2.0);
        this.colourBox.setHeight(18.0);
        this.addRect((IRect)this.colourBox);
        this.colourLabel = new ClickableLabel(this.COLOUR_PREFIX, this.getPosition());
        this.colourLabel.setWidth(width - this.margin * 2.0);
        this.colourLabel.setDrawBackground(false);
        this.addRect((IRect)this.colourLabel);
        this.doneAdding();
        this.colourLabel.setOnPressed(pressed -> {
            if (this.colours().length > this.selectedColour) {
                Minecraft.func_71410_x().field_195559_v.func_197960_a(new Colour(this.selectedColour).hexColour());
            }
        });
        this.selectedSlider = Optional.empty();
        this.selectedColour = 0;
        this.decrAbove = -1;
    }

    public ClickableSlider getSlider(String id, int index, double width) {
        ClickableSlider slider = new ClickableSlider(this.center(), width, id, new TranslationTextComponent("module.tradeoff." + id));
        this.addRect((IRect)slider);
        slider.setLabelColour(Colour.WHITE);
        slider.setOnPressed(pressed -> {
            this.selectedSlider = Optional.of(slider);
        });
        return slider;
    }

    public int[] colours() {
        return this.getOrCreateColourTag() != null ? this.getOrCreateColourTag().func_150302_c() : new int[]{};
    }

    public IntArrayNBT getOrCreateColourTag() {
        return this.itemSelector.getModularItemOrEmpty().getCapability(ModelSpecNBTCapability.RENDER).filter(IModelSpecNBT.class::isInstance).map(IModelSpecNBT.class::cast).map(spec -> {
            CompoundNBT renderSpec = spec.getRenderTag();
            if (renderSpec != null && !renderSpec.isEmpty()) {
                return new IntArrayNBT(spec.getColorArray());
            }
            return new IntArrayNBT(new int[0]);
        }).orElse(new IntArrayNBT(new int[0]));
    }

    public IntArrayNBT setColourTagMaybe(List<Integer> intList) {
        return this.itemSelector.getModularItemOrEmpty().getCapability(ModelSpecNBTCapability.RENDER).filter(IModelSpecNBT.class::isInstance).map(IModelSpecNBT.class::cast).map(spec -> {
            CompoundNBT renderSpec = spec.getRenderTag();
            renderSpec.func_218657_a("colours", (INBT)new IntArrayNBT(intList));
            this.itemSelector.selectedType().ifPresent(slotType -> MPSPackets.CHANNEL_INSTANCE.sendToServer((Object)new ColourInfoPacket((EquipmentSlotType)slotType, this.colours())));
            return (IntArrayNBT)renderSpec.func_74781_a("colours");
        }).orElse(new IntArrayNBT(new int[0]));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.containsPoint(mouseX, mouseY)) {
            if (this.isEnabled() && super.mouseClicked(mouseX, mouseY, button)) {
                double scrolledY = mouseY + (double)this.currentScrollPixels;
                this.colourBox.addColour(mouseX, scrolledY);
                this.colourBox.removeColour(mouseX, scrolledY);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        if (this.isEnabled()) {
            this.selectedSlider = Optional.empty();
        }
        return super.mouseReleased(x, y, button);
    }

    public void onSelectColour(int i) {
        Colour c = new Colour(this.colours()[i]);
        this.sliders[0].setValue((double)c.r);
        this.sliders[1].setValue((double)c.g);
        this.sliders[2].setValue((double)c.b);
        this.sliders[3].setValue((double)c.a);
        this.selectedColour = i;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int scrolledY = mouseY + this.currentScrollPixels;
        this.renderBackground(matrixStack, mouseX, scrolledY, partialTicks);
        if (this.isVisible()) {
            this.currentScrollPixels = Math.min(this.currentScrollPixels, this.getMaxScrollPixels());
            if (this.colours().length > this.selectedColour) {
                this.colourLabel.setLabel(this.COLOUR_PREFIX + " 0X" + new Colour(this.colours()[this.selectedColour]).hexColour());
            }
            super.preRender(matrixStack, mouseX, scrolledY, partialTicks);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)(-this.currentScrollPixels), (float)0.0f);
            this.refreshRects();
            Arrays.stream(this.sliders).forEach(slider -> slider.func_230430_a_(matrixStack, mouseX, scrolledY, partialTicks));
            this.colourBox.func_230430_a_(matrixStack, mouseX, scrolledY, partialTicks);
            this.colourLabel.func_230430_a_(matrixStack, mouseX, scrolledY, partialTicks);
            RenderSystem.popMatrix();
            super.postRender(mouseX, scrolledY, partialTicks);
        }
    }

    public void update(double mousex, double mousey) {
        super.update(mousex, mousey);
        if (!this.itemSelector.playerHasModularItems()) {
            this.disable();
        } else {
            this.enable();
        }
        if (this.isEnabled()) {
            Arrays.stream(this.sliders).forEach(slider -> slider.update(mousex, mousey + (double)this.getCurrentScrollPixels()));
            if (this.selectedSlider.isPresent()) {
                this.selectedSlider.ifPresent(slider -> {
                    slider.setValueByX(mousex);
                    if (this.colours().length > this.selectedColour) {
                        this.colours()[this.selectedColour] = Colour.getInt((float)((float)this.sliders[0].getValue()), (float)((float)this.sliders[1].getValue()), (float)((float)this.sliders[2].getValue()), (float)((float)this.sliders[3].getValue()));
                        this.itemSelector.selectedType().ifPresent(slotType -> MPSPackets.CHANNEL_INSTANCE.sendToServer((Object)new ColourInfoPacket((EquipmentSlotType)slotType, this.colours())));
                    }
                });
            } else if (!this.itemSelector.getModularItemOrEmpty().func_190926_b() && this.colours().length > 0 && this.selectedColour <= this.colours().length - 1) {
                this.onSelectColour(this.selectedColour);
            }
        }
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        return null;
    }

    class ScrollableColourBox
    extends DrawableTile
    implements IClickable {
        public ScrollableColourBox() {
            super(0.0, 0.0, 0.0, 0.0);
        }

        public int[] getIntArray(IntArrayNBT e) {
            if (e == null) {
                return new int[0];
            }
            return e.func_150302_c();
        }

        boolean addColour(double x, double y) {
            if (y > this.top() + 8.0 && y < this.bottom()) {
                int colourCol = (int)(x - this.left() - 8.0) / 8;
                if (colourCol >= 0 && colourCol < ColourPickerFrame.this.colours().length) {
                    ColourPickerFrame.this.onSelectColour(colourCol);
                } else if (colourCol == ColourPickerFrame.this.colours().length) {
                    MuseLogger.logger.debug("Adding");
                    List<Integer> intList = Arrays.stream(this.getIntArray(ColourPickerFrame.this.getOrCreateColourTag())).boxed().collect(Collectors.toList());
                    intList.add(Colour.WHITE.getInt());
                    ColourPickerFrame.this.setColourTagMaybe(intList);
                }
                return true;
            }
            return false;
        }

        boolean removeColour(double x, double y) {
            if (y > this.top() + 1.5 && y < this.top() + 7.0 && x > this.left() + 8.0 + (double)(ColourPickerFrame.this.selectedColour * 8) && x < this.left() + 16.0 + (double)(ColourPickerFrame.this.selectedColour * 8)) {
                IntArrayNBT IntArrayNBT2 = ColourPickerFrame.this.getOrCreateColourTag();
                List<Integer> intList = Arrays.stream(this.getIntArray(IntArrayNBT2)).boxed().collect(Collectors.toList());
                if (intList.size() > 1 && ColourPickerFrame.this.selectedColour <= intList.size() - 1) {
                    intList.remove(ColourPickerFrame.this.selectedColour);
                    ColourPickerFrame.this.setColourTagMaybe(intList);
                    ColourPickerFrame.this.decrAbove = ColourPickerFrame.this.selectedColour;
                    if (ColourPickerFrame.this.selectedColour == this.getIntArray(IntArrayNBT2).length) {
                        --ColourPickerFrame.this.selectedColour;
                    }
                    ColourPickerFrame.this.itemSelector.selectedType().ifPresent(slotType -> MPSPackets.CHANNEL_INSTANCE.sendToServer((Object)new ColourInfoPacket((EquipmentSlotType)slotType, IntArrayNBT2.func_150302_c())));
                }
                return true;
            }
            return false;
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            GuiIcon icon = MuseIconUtils.getIcon();
            for (int i = 0; i < ColourPickerFrame.this.colours().length; ++i) {
                icon.armorColourPatch.draw(matrixStack, this.left() + 8.0 + (double)(i * 8), this.top() + 8.0, new Colour(ColourPickerFrame.this.colours()[i]));
            }
            icon.armorColourPatch.draw(matrixStack, this.left() + 8.0 + (double)(ColourPickerFrame.this.colours().length * 8), this.top() + 8.0, Colour.WHITE);
            icon.selectedArmorOverlay.draw(matrixStack, this.left() + 8.0 + (double)(ColourPickerFrame.this.selectedColour * 8), this.top() + 8.0, Colour.WHITE);
            icon.minusSign.draw(matrixStack, this.left() + 8.0 + (double)(ColourPickerFrame.this.selectedColour * 8), this.top(), Colour.RED);
            icon.plusSign.draw(matrixStack, this.left() + 8.0 + (double)(ColourPickerFrame.this.colours().length * 8), this.top() + 8.0, Colour.GREEN);
        }

        public void setEnabled(boolean b) {
        }

        public boolean isEnabled() {
            return true;
        }

        public void setVisible(boolean b) {
        }

        public boolean isVisible() {
            return true;
        }

        public void setOnPressed(IClickable.IPressable iPressable) {
        }

        public void setOnReleased(IClickable.IReleasable iReleasable) {
        }

        public void onPressed() {
        }

        public void onReleased() {
        }
    }
}

