/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.modding.module.tweak;

import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.client.gui.frame.ScrollableFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.string.MuseStringUtils;
import com.github.lehjr.powersuits.client.gui.common.ModularItemSelectionFrame;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class DetailedSummaryFrame
extends ScrollableFrame {
    protected AtomicInteger energy = new AtomicInteger(0);
    protected AtomicDouble armor = new AtomicDouble(0.0);
    protected ModularItemSelectionFrame itemSelectionFrame;

    public DetailedSummaryFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour background, Colour topBorder, Colour bottomBorder, ModularItemSelectionFrame itemSelectionFrame) {
        super(topleft, bottomright, background, topBorder, bottomBorder);
        this.itemSelectionFrame = itemSelectionFrame;
    }

    public void update(double mousex, double mousey) {
        this.energy.set(0);
        this.armor.set(0.0);
        for (EquipmentSlotType type : EquipmentSlotType.values()) {
            this.getMinecraft().field_71439_g.func_184582_a(type).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iModularItem -> {
                int i;
                Pair range = iModularItem.getRangeForCategory(EnumModuleCategory.ARMOR);
                if (range != null) {
                    for (i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                        iModularItem.getStackInSlot(i).getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(iPowerModule -> {
                            this.armor.getAndAdd(iPowerModule.applyPropertyModifiers("armorPhysical"));
                            this.armor.getAndAdd(iPowerModule.applyPropertyModifiers("armorEnergy"));
                        });
                    }
                }
                if ((range = iModularItem.getRangeForCategory(EnumModuleCategory.ENERGY_STORAGE)) != null) {
                    for (i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                        this.energy.getAndAdd(iModularItem.getStackInSlot(i).getCapability(CapabilityEnergy.ENERGY).map(energyHandler -> energyHandler.getEnergyStored()).orElse(0));
                    }
                }
            });
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.getMinecraft().field_71439_g != null) {
            int i;
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            int margin = 4;
            int nexty = (int)this.getRect().top() + margin + 4;
            MuseRenderer.drawShadowedStringCentered((MatrixStack)matrixStack, (String)I18n.func_135052_a((String)"gui.powersuits.equippedTotals", (Object[])new Object[0]), (double)((this.getRect().left() + this.getRect().right()) / 2.0), (double)nexty);
            nexty += 10;
            String formattedValue = MuseStringUtils.formatNumberFromUnits((double)this.energy.get(), (String)"FE");
            String name = I18n.func_135052_a((String)"gui.powersuits.energyStorage", (Object[])new Object[0]);
            double valueWidth = MuseRenderer.getStringWidth((String)formattedValue);
            double allowedNameWidth = this.getRect().width() - valueWidth - (double)(margin * 2);
            List namesList = MuseStringUtils.wrapStringToVisualLength((String)name, (double)allowedNameWidth);
            for (i = 0; i < namesList.size(); ++i) {
                MuseRenderer.drawShadowedString((MatrixStack)matrixStack, (String)((String)namesList.get(i)), (double)(this.getRect().left() + (double)margin), (double)(nexty + 9 * i));
            }
            MuseRenderer.drawRightAlignedShadowedString((MatrixStack)matrixStack, (String)formattedValue, (double)(this.getRect().right() - (double)margin), (double)(nexty + 9 * (namesList.size() - 1) / 2));
            nexty += 10 * namesList.size() + 1;
            formattedValue = MuseStringUtils.formatNumberFromUnits((double)this.armor.get(), (String)"pts");
            name = I18n.func_135052_a((String)"gui.powersuits.armor", (Object[])new Object[0]);
            valueWidth = MuseRenderer.getStringWidth((String)formattedValue);
            allowedNameWidth = this.getRect().width() - valueWidth - (double)(margin * 2);
            namesList = MuseStringUtils.wrapStringToVisualLength((String)name, (double)allowedNameWidth);
            assert (namesList != null);
            for (i = 0; i < namesList.size(); ++i) {
                MuseRenderer.drawShadowedString((MatrixStack)matrixStack, (String)((String)namesList.get(i)), (double)(this.getRect().left() + (double)margin), (double)(nexty + 9 * i));
            }
            MuseRenderer.drawRightAlignedShadowedString((MatrixStack)matrixStack, (String)formattedValue, (double)(this.getRect().right() - (double)margin), (double)(nexty + 9 * (namesList.size() - 1) / 2));
        }
    }
}

