/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.modding.module.tweak;

import com.github.lehjr.numina.network.NuminaPackets;
import com.github.lehjr.numina.network.packets.TweakRequestDoublePacket;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableTinkerIntSlider;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableTinkerSlider;
import com.github.lehjr.numina.util.client.gui.frame.ScrollableFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.nbt.propertymodifier.IPropertyModifier;
import com.github.lehjr.numina.util.nbt.propertymodifier.PropertyModifierIntLinearAdditive;
import com.github.lehjr.numina.util.nbt.propertymodifier.PropertyModifierLinearAdditive;
import com.github.lehjr.numina.util.string.MuseStringUtils;
import com.github.lehjr.powersuits.client.gui.common.ModularItemSelectionFrame;
import com.github.lehjr.powersuits.client.gui.modding.module.tweak.ModuleSelectionFrame;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;

public class ModuleTweakFrame
extends ScrollableFrame {
    protected static int margin = 4;
    protected ModularItemSelectionFrame itemTarget;
    protected ModuleSelectionFrame moduleTarget;
    protected List<ClickableTinkerSlider> sliders = new LinkedList<ClickableTinkerSlider>();
    protected Map<String, Double> propertyStrings = new HashMap<String, Double>();
    protected ClickableTinkerSlider selectedSlider;

    public ModuleTweakFrame(MusePoint2D topleft, MusePoint2D bottomright, Colour background, Colour topBorder, Colour bottomBorder, ModularItemSelectionFrame itemTarget, ModuleSelectionFrame moduleTarget) {
        super(topleft, bottomright, background, topBorder, bottomBorder);
        this.itemTarget = itemTarget;
        this.moduleTarget = moduleTarget;
    }

    public void update(double mousex, double mousey) {
        LazyOptional<IPowerModule> cap = this.moduleTarget.getModuleCap();
        if (cap.isPresent()) {
            this.loadTweaks(cap);
        } else {
            this.sliders.clear();
            this.propertyStrings.clear();
            this.selectedSlider = null;
        }
        for (ClickableTinkerSlider slider : this.sliders) {
            slider.update(mousex, mousey);
        }
        if (this.selectedSlider != null) {
            this.selectedSlider.setValueByX(mousex);
        }
    }

    public void resetScroll() {
        this.currentScrollPixels = 0;
    }

    String getUnit(String key) {
        return this.moduleTarget.getSelectedModule().map(target -> target.getModule().getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> pm.getUnit(key)).orElse("")).orElse("");
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        super.preRender(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)(-this.currentScrollPixels), (float)0.0f);
        MuseRenderer.drawShadowedStringCentered((MatrixStack)matrixStack, (String)"Tinker", (double)this.centerx(), (double)(this.top() + 7.0));
        for (ClickableTinkerSlider slider : this.sliders) {
            slider.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        int nexty = (int)((double)(this.sliders.size() * 24) + this.getRect().top() + 18.0);
        for (Map.Entry<String, Double> property : this.propertyStrings.entrySet()) {
            String formattedValue = MuseStringUtils.formatNumberFromUnits((double)property.getValue(), (String)this.getUnit(property.getKey()));
            String name = property.getKey();
            double valueWidth = MuseRenderer.getStringWidth((String)formattedValue);
            double allowedNameWidth = this.getRect().width() - valueWidth - (double)(margin * 2);
            List namesList = MuseStringUtils.wrapStringToVisualLength((String)new TranslationTextComponent("module.tradeoff." + name).getString(), (double)allowedNameWidth);
            for (int i = 0; i < namesList.size(); ++i) {
                MuseRenderer.drawLeftAlignedShadowedString((MatrixStack)matrixStack, (String)((String)namesList.get(i)), (double)(this.getRect().left() + (double)margin), (double)(nexty + 9 * i));
            }
            MuseRenderer.drawRightAlignedShadowedString((MatrixStack)matrixStack, (String)formattedValue, (double)(this.getRect().right() - (double)margin), (double)(nexty + 9 * (namesList.size() - 1) / 2));
            nexty += 9 * namesList.size() + 1;
        }
        RenderSystem.popMatrix();
        super.postRender(mouseX, mouseY, partialTicks);
    }

    private void loadTweaks(LazyOptional<IPowerModule> cap) {
        this.propertyStrings = new HashMap<String, Double>();
        HashMap tweaks = new HashMap();
        this.sliders.clear();
        this.totalSize = cap.map(pm -> {
            int totalSize = 0;
            CompoundNBT moduleTag = pm.getModuleTag();
            Map propertyModifiers = pm.getPropertyModifiers();
            for (Map.Entry property : propertyModifiers.entrySet()) {
                double currValue = 0.0;
                for (IPropertyModifier modifier : (List)property.getValue()) {
                    currValue = modifier.applyModifier(moduleTag, currValue);
                    if (!(modifier instanceof PropertyModifierLinearAdditive)) continue;
                    String modifierName = ((PropertyModifierLinearAdditive)modifier).getTradeoffName();
                    if (!(tweaks.get(modifierName) instanceof PropertyModifierIntLinearAdditive)) {
                        tweaks.put(modifierName, (PropertyModifierLinearAdditive)modifier);
                    }
                    totalSize += 9;
                }
                this.propertyStrings.put((String)property.getKey(), currValue);
                totalSize += 9;
            }
            System.out.println("tweaks size: " + tweaks.size());
            int y = 0;
            for (String tweak : tweaks.keySet()) {
                ClickableTinkerSlider slider;
                System.out.println(tweak + ":  " + tweaks.get(tweak));
                MusePoint2D center = new MusePoint2D(this.getRect().centerx(), this.getRect().top() + (double)(y += 23));
                PropertyModifierLinearAdditive tweakObj = (PropertyModifierLinearAdditive)tweaks.get(tweak);
                if (tweakObj instanceof PropertyModifierIntLinearAdditive) {
                    slider = new ClickableTinkerIntSlider(center, this.getRect().finalRight() - this.getRect().finalLeft() - 16.0, moduleTag, tweak, new TranslationTextComponent("module.tradeoff." + tweak), (PropertyModifierIntLinearAdditive)tweaks.get(tweak));
                    this.sliders.add(slider);
                    totalSize = (int)((double)totalSize + slider.finalHeight());
                    continue;
                }
                slider = new ClickableTinkerSlider(center, this.getRect().finalRight() - this.getRect().finalLeft() - 16.0, moduleTag, tweak, new TranslationTextComponent("module.tradeoff." + tweak));
                this.sliders.add(slider);
                totalSize = (int)((double)totalSize + slider.finalHeight());
            }
            return totalSize + 20;
        }).orElse(0);
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (button == 0) {
            y += (double)this.currentScrollPixels;
            for (ClickableTinkerSlider slider : this.sliders) {
                if (!slider.mouseClicked(x, y, button)) continue;
                this.selectedSlider = slider;
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        if (this.selectedSlider != null && button == 0) {
            this.selectedSlider.mouseReleased(x, y, button);
            this.itemTarget.selectedType().ifPresent(type -> this.moduleTarget.getModuleCap().ifPresent(pm -> NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new TweakRequestDoublePacket(type, pm.getModuleStack().func_77973_b().getRegistryName(), this.selectedSlider.id(), this.selectedSlider.getValue()))));
            this.selectedSlider = null;
            return true;
        }
        return false;
    }
}

