/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.render.entity;

import com.github.lehjr.numina.client.render.entity.NuminaEntityRenderer;
import com.github.lehjr.numina.constants.NuminaConstants;
import com.github.lehjr.numina.util.client.model.helper.ModelHelper;
import com.github.lehjr.numina.util.client.model.obj.OBJBakedCompositeModel;
import com.github.lehjr.numina.util.client.render.MuseIconUtils;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.powersuits.entity.PlasmaBallEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.NonNullLazy;

public class PlasmaBoltEntityRenderer
extends NuminaEntityRenderer<PlasmaBallEntity> {
    static final Colour colour1 = new Colour(0.3f, 0.3f, 1.0f, 0.3f);
    static final Colour colour2 = new Colour(0.4f, 0.4f, 1.0f, 0.5f);
    static final Colour colour3 = new Colour(0.8f, 0.8f, 1.0f, 0.7f);
    static final Colour colour4 = new Colour(1.0f, 1.0f, 1.0f, 0.9f);
    static final ResourceLocation modelLocation = new ResourceLocation("numina", "models/item/test/sphere.obj");
    public static final NonNullLazy<OBJBakedCompositeModel> modelSphere = NonNullLazy.of(() -> ModelHelper.loadBakedModel((IModelTransform)ModelRotation.X0_Y0, null, (ResourceLocation)modelLocation));
    protected static final Random rand = new Random();

    public PlasmaBoltEntityRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(PlasmaBallEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        float size = entityIn.getChargePercent();
        System.out.println("size: " + size);
        if (size > 0.0f) {
            PlasmaBoltEntityRenderer.renderPlasma(matrixStackIn, bufferIn, size);
        }
    }

    public ResourceLocation getTextureLocation(PlasmaBallEntity entity) {
        return NuminaConstants.TEXTURE_WHITE;
    }

    public static void renderPlasma(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, double size) {
        matrixStackIn.func_227860_a_();
        float scalFactor = 3.0f;
        float scale = (float)(size * 0.0625);
        System.out.println("scale: " + scale);
        matrixStackIn.func_227862_a_(scale, scale, scale);
        for (int i = 0; i < 9; ++i) {
            double angle1 = Math.random() * 2.0 * Math.PI;
            double angle2 = Math.random() * 2.0 * Math.PI;
            double angle3 = Math.random() * 2.0 * Math.PI;
            MuseIconUtils.getIcon().lightning.drawLightning(bufferIn, matrixStackIn, (float)(Math.cos(angle1) * 0.5), (float)(Math.sin(angle1) * 0.5), (float)(Math.cos(angle3) * 0.5), (float)(Math.cos(angle2) * 5.0), (float)(Math.sin(angle2) * 5.0), (float)(Math.sin(angle3) * 5.0), new Colour(1.0f, 1.0f, 1.0f, 0.9f));
        }
        int millisPerCycle = 500;
        double timeScale = Math.cos((double)(System.currentTimeMillis() % (long)millisPerCycle) * 2.0 / (double)millisPerCycle - 1.0);
        PlasmaBoltEntityRenderer.renderPlasmaBall(matrixStackIn, bufferIn, 4.0f * scalFactor, colour1.withAlpha(0.15f));
        PlasmaBoltEntityRenderer.renderPlasmaBall(matrixStackIn, bufferIn, (float)(3.0 + timeScale / 2.0) * scalFactor, colour2.withAlpha(0.25f));
        PlasmaBoltEntityRenderer.renderPlasmaBall(matrixStackIn, bufferIn, (float)(2.0 + timeScale) * scalFactor, colour3.withAlpha(0.4f));
        PlasmaBoltEntityRenderer.renderPlasmaBall(matrixStackIn, bufferIn, (float)(1.0 + timeScale) * scalFactor, colour4.withAlpha(0.75f));
        matrixStackIn.func_227865_b_();
    }

    static void renderPlasmaBall(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, float scale, Colour colour) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227862_a_(scale, scale, scale);
        PlasmaBoltEntityRenderer.renderSphere(bufferIn, PlasmaBoltEntityRenderer.getSphereRenderType(), matrixStackIn, 0xF000F0, colour);
        matrixStackIn.func_227865_b_();
    }

    private static RenderType getSphereRenderType() {
        return RenderType.func_228642_d_((ResourceLocation)NuminaConstants.TEXTURE_WHITE);
    }

    public static void renderSphere(IRenderTypeBuffer bufferIn, RenderType rt, MatrixStack matrixStackIn, int packedLightIn, Colour colour) {
        PlasmaBoltEntityRenderer.renderSphere(bufferIn, rt, matrixStackIn, packedLightIn, OverlayTexture.field_229196_a_, colour);
    }

    public static void renderSphere(IRenderTypeBuffer bufferIn, RenderType rt, MatrixStack matrixStackIn, int packedLightIn, int overlay, Colour colour) {
        IVertexBuilder bb = bufferIn.getBuffer(rt);
        for (BakedQuad quad : ((OBJBakedCompositeModel)modelSphere.get()).getQuads(null, null, rand, (IModelData)EmptyModelData.INSTANCE)) {
            bb.addVertexData(matrixStackIn.func_227866_c_(), quad, colour.r, colour.g, colour.b, colour.a, packedLightIn, overlay, true);
        }
    }
}

