/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.config;

import com.github.lehjr.numina.config.ModuleConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.powersuits.config.ClientConfig;
import com.github.lehjr.powersuits.config.ServerConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.NonNullLazy;
import org.apache.commons.lang3.tuple.Pair;

public class MPSSettings {
    public static final ClientConfig CLIENT_CONFIG;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ServerConfig SERVER_CONFIG;
    public static final ForgeConfigSpec SERVER_SPEC;
    static NonNullLazy<IConfig> moduleConfig;

    public static boolean useGraphicalMeters() {
        return CLIENT_CONFIG != null ? (Boolean)MPSSettings.CLIENT_CONFIG.HUD_USE_GRAPHICAL_METERS.get() : false;
    }

    public static boolean displayHud() {
        return CLIENT_CONFIG != null ? (Boolean)MPSSettings.CLIENT_CONFIG.HUD_DISPLAY_HUD.get() : false;
    }

    public static boolean use24HourClock() {
        return CLIENT_CONFIG != null ? (Boolean)MPSSettings.CLIENT_CONFIG.HUD_USE_24_HOUR_CLOCK.get() : false;
    }

    public static float getHudKeybindX() {
        return CLIENT_CONFIG != null ? MPSSettings.toFloat((Double)MPSSettings.CLIENT_CONFIG.HUD_KEYBIND_X.get()) : 8.0f;
    }

    public static float getHudKeybindY() {
        return CLIENT_CONFIG != null ? MPSSettings.toFloat((Double)MPSSettings.CLIENT_CONFIG.HUD_KEYBIND_Y.get()) : 32.0f;
    }

    public static boolean allowConfictingKeyBinds() {
        return CLIENT_CONFIG != null ? (Boolean)MPSSettings.CLIENT_CONFIG.GENERAL_ALLOW_CONFLICTING_KEYBINDS.get() : true;
    }

    public static double getMaxFlyingSpeed() {
        return SERVER_CONFIG != null ? (Double)MPSSettings.SERVER_CONFIG.GENERAL_MAX_FLYING_SPEED.get() : 25.0;
    }

    public static double getMaxHeatPowerFist() {
        return SERVER_CONFIG != null ? (Double)MPSSettings.SERVER_CONFIG.GENERAL_BASE_MAX_HEAT_POWERFIST.get() : 5.0;
    }

    public static double getMaxHeatHelmet() {
        return SERVER_CONFIG != null ? (Double)MPSSettings.SERVER_CONFIG.GENERAL_BASE_MAX_HEAT_HELMET.get() : 5.0;
    }

    public static double getMaxHeatChestplate() {
        return SERVER_CONFIG != null ? (Double)MPSSettings.SERVER_CONFIG.GENERAL_BASE_MAX_HEAT_CHEST.get() : 20.0;
    }

    public static double getMaxHeatLegs() {
        return SERVER_CONFIG != null ? (Double)MPSSettings.SERVER_CONFIG.GENERAL_BASE_MAX_HEAT_LEGS.get() : 15.0;
    }

    public static double getMaxHeatBoots() {
        return SERVER_CONFIG != null ? (Double)MPSSettings.SERVER_CONFIG.GENERAL_BASE_MAX_HEAT_FEET.get() : 15.0;
    }

    public static boolean useLegacyCosmeticSystem() {
        return SERVER_CONFIG != null ? (Boolean)MPSSettings.SERVER_CONFIG.COSMETIC_USE_LEGACY_COSMETIC_SYSTEM.get() : false;
    }

    public static boolean allowHighPollyArmor() {
        return SERVER_CONFIG != null ? (Boolean)MPSSettings.SERVER_CONFIG.COSMETIC_ALLOW_HIGH_POLLY_ARMOR_MODELS.get() : true;
    }

    public static boolean allowPowerFistCustomization() {
        return SERVER_CONFIG != null ? (Boolean)MPSSettings.SERVER_CONFIG.COSMETIC_ALLOW_POWER_FIST_CUSTOMIZATOIN.get() : true;
    }

    public static List<ResourceLocation> getOreList() {
        List ores = SERVER_CONFIG != null ? (List)MPSSettings.SERVER_CONFIG.GENERAL_VEIN_MINER_ORE_LIST.get() : new ArrayList();
        ArrayList<ResourceLocation> retList = new ArrayList<ResourceLocation>();
        ores.forEach(ore -> retList.add(new ResourceLocation(ore)));
        return retList;
    }

    public static List<ResourceLocation> getBlockList() {
        List blocks = SERVER_CONFIG != null ? (List)MPSSettings.SERVER_CONFIG.GENERAL_VEIN_MINER_BLOCK_LIST.get() : new ArrayList();
        ArrayList<ResourceLocation> retList = new ArrayList<ResourceLocation>();
        blocks.forEach(block -> retList.add(new ResourceLocation(block)));
        return retList;
    }

    public static IConfig getModuleConfig() {
        return (IConfig)moduleConfig.get();
    }

    static float toFloat(double val) {
        return (float)val;
    }

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT_CONFIG = (ClientConfig)clientSpecPair.getLeft();
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER_CONFIG = (ServerConfig)serverSpecPair.getLeft();
        moduleConfig = NonNullLazy.of(() -> new ModuleConfig("powersuits"));
    }
}

