/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.event;

import com.github.lehjr.numina.config.NuminaSettings;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.client.control.PlayerMovementInputWrapper;
import com.github.lehjr.numina.util.client.sound.Musique;
import com.github.lehjr.numina.util.client.sound.SoundDictionary;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.numina.util.math.MuseMathUtils;
import com.github.lehjr.numina.util.player.PlayerUtils;
import com.github.lehjr.powersuits.client.sound.MPSSoundDictionary;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.constants.MPSRegistryNames;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public enum MovementManager {
    INSTANCE;

    static final double root2;
    public static final Map<UUID, Double> playerJumpMultipliers;
    public static final double DEFAULT_GRAVITY = -0.0784000015258789;

    public double getPlayerJumpMultiplier(PlayerEntity player) {
        if (playerJumpMultipliers.containsKey(player.func_110124_au())) {
            return playerJumpMultipliers.get(player.func_110124_au());
        }
        return 0.0;
    }

    public void setPlayerJumpTicks(PlayerEntity player, double number) {
        playerJumpMultipliers.put(player.func_110124_au(), number);
    }

    public double computeFallHeightFromVelocity(double velocity) {
        double ticks = velocity / -0.0784000015258789;
        return 0.03920000076293945 * ticks * ticks;
    }

    public void setMovementModifier(ItemStack itemStack, double multiplier, PlayerEntity player) {
        AtomicDouble movementResistance = new AtomicDouble(0.0);
        itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iModularItem -> iModularItem.getOnlineModuleOrEmpty(MPSRegistryNames.KINETIC_GENERATOR_MODULE_REGNAME).getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(kin -> movementResistance.set(kin.applyPropertyModifiers("movementResistance"))));
        double additive = (multiplier -= movementResistance.get()) * (player.func_70051_ag() ? 0.13 : 0.1) / 2.0;
        CompoundNBT itemNBT = itemStack.func_196082_o();
        boolean hasAttribute = false;
        if (itemNBT.func_150297_b("AttributeModifiers", 9)) {
            ListNBT listnbt = itemNBT.func_150295_c("AttributeModifiers", 10);
            int remove = -1;
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT attributeTag = listnbt.func_150305_b(i);
                AttributeModifier attributemodifier = AttributeModifier.func_233800_a_((CompoundNBT)attributeTag);
                if (attributemodifier == null || !attributemodifier.func_111166_b().equals(Attributes.field_233821_d_.func_233754_c_())) continue;
                if (additive != 0.0) {
                    attributeTag.func_74780_a("Amount", additive);
                    hasAttribute = true;
                    break;
                }
                remove = i;
                break;
            }
            if (hasAttribute && remove != -1) {
                listnbt.remove(remove);
            }
        }
        if (!hasAttribute && additive != 0.0) {
            itemStack.func_185129_a(Attributes.field_233821_d_, new AttributeModifier(Attributes.field_233821_d_.func_233754_c_(), additive, AttributeModifier.Operation.ADDITION), EquipmentSlotType.LEGS);
        }
    }

    public static double thrust(PlayerEntity player, double thrust, boolean flightControl) {
        PlayerMovementInputWrapper.PlayerMovementInput playerInput = PlayerMovementInputWrapper.get((PlayerEntity)player);
        double thrustUsed = 0.0;
        if (flightControl) {
            Vector3d desiredDirection = player.func_70040_Z().func_72432_b();
            double strafeX = desiredDirection.field_72449_c;
            double strafeZ = -desiredDirection.field_72450_a;
            double flightVerticality = player.func_184582_a(EquipmentSlotType.HEAD).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(iModularItem -> iModularItem.getOnlineModuleOrEmpty(MPSRegistryNames.FLIGHT_CONTROL_MODULE_REGNAME).getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> pm.applyPropertyModifiers("yLookRatio")).orElse(0.0)).orElse(0.0);
            desiredDirection = new Vector3d(desiredDirection.field_72450_a * (double)Math.signum(playerInput.moveForward) + strafeX * (double)Math.signum(playerInput.moveStrafe), flightVerticality * desiredDirection.field_72448_b * (double)Math.signum(playerInput.moveForward) + (double)(playerInput.jumpKey ? 1 : 0) - (double)(playerInput.downKey ? 1 : 0), desiredDirection.field_72449_c * (double)Math.signum(playerInput.moveForward) + strafeZ * (double)Math.signum(playerInput.moveStrafe));
            desiredDirection = desiredDirection.func_72432_b();
            if (player.func_213322_ci().field_72448_b < 0.0 && desiredDirection.field_72448_b >= 0.0) {
                if (-player.func_213322_ci().field_72448_b > thrust) {
                    player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, thrust, 0.0));
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrust -= player.func_213322_ci().field_72448_b;
                    thrustUsed += player.func_213322_ci().field_72448_b;
                    player.func_213293_j(player.func_213322_ci().field_72450_a, 0.0, player.func_213322_ci().field_72449_c);
                }
            }
            if (player.func_213322_ci().field_72448_b < -1.0) {
                thrust += 1.0 + player.func_213322_ci().field_72448_b;
                thrustUsed -= 1.0 + player.func_213322_ci().field_72448_b;
                player.func_213293_j(player.func_213322_ci().field_72450_a, -1.0, player.func_213322_ci().field_72449_c);
            }
            if (Math.abs(player.func_213322_ci().field_72450_a) > 0.0 && desiredDirection.func_72433_c() == 0.0) {
                if (Math.abs(player.func_213322_ci().field_72450_a) > thrust) {
                    player.func_213317_d(player.func_213322_ci().func_72441_c(-(Math.signum(player.func_213322_ci().field_72450_a) * thrust), 0.0, 0.0));
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrust -= Math.abs(player.func_213322_ci().field_72450_a);
                    thrustUsed += Math.abs(player.func_213322_ci().field_72450_a);
                    player.func_213293_j(0.0, player.func_213322_ci().field_72448_b, player.func_213322_ci().field_72449_c);
                }
            }
            if (Math.abs(player.func_213322_ci().field_72449_c) > 0.0 && desiredDirection.func_72433_c() == 0.0) {
                if (Math.abs(player.func_213322_ci().field_72449_c) > thrust) {
                    player.func_213317_d(player.func_213322_ci().func_178786_a(0.0, 0.0, Math.signum(player.func_213322_ci().field_72449_c) * thrust));
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrustUsed += Math.abs(player.func_213322_ci().field_72449_c);
                    thrust -= Math.abs(player.func_213322_ci().field_72449_c);
                    player.func_213293_j(player.func_213322_ci().field_72450_a, player.func_213322_ci().field_72448_b, 0.0);
                }
            }
            player.func_213317_d(player.func_213322_ci().func_72441_c(thrust * desiredDirection.field_72450_a, thrust * desiredDirection.field_72448_b, thrust * desiredDirection.field_72449_c));
            thrustUsed += thrust;
        } else {
            Vector3d playerHorzFacing = player.func_70040_Z();
            playerHorzFacing = new Vector3d(playerHorzFacing.field_72450_a, 0.0, playerHorzFacing.field_72449_c);
            playerHorzFacing.func_72432_b();
            if (playerInput.moveForward == 0.0f) {
                player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, thrust, 0.0));
            } else {
                player.func_213317_d(player.func_213322_ci().func_72441_c(playerHorzFacing.field_72450_a * thrust / root2 * (double)Math.signum(playerInput.moveForward), thrust / root2, playerHorzFacing.field_72449_c * thrust / root2 * (double)Math.signum(playerInput.moveForward)));
            }
            thrustUsed += thrust;
        }
        double horzm2 = player.func_213322_ci().field_72450_a * player.func_213322_ci().field_72450_a + player.func_213322_ci().field_72449_c * player.func_213322_ci().field_72449_c;
        double horizontalLimit = MPSSettings.getMaxFlyingSpeed() * MPSSettings.getMaxFlyingSpeed() / 400.0;
        if (playerInput.sneakKey && horizontalLimit > 0.05) {
            horizontalLimit = 0.05;
        }
        if (horzm2 > horizontalLimit) {
            double ratio = Math.sqrt(horizontalLimit / horzm2);
            player.func_213293_j(player.func_213322_ci().field_72450_a * ratio, player.func_213322_ci().field_72448_b, player.func_213322_ci().field_72449_c * ratio);
        }
        PlayerUtils.resetFloatKickTicks((PlayerEntity)player);
        return thrustUsed;
    }

    public static double computePlayerVelocity(PlayerEntity player) {
        return MuseMathUtils.pythag((double)player.func_213322_ci().field_72450_a, (double)player.func_213322_ci().field_72448_b, (double)player.func_213322_ci().field_72449_c);
    }

    @SubscribeEvent
    public void handleLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            player.func_184582_a(EquipmentSlotType.LEGS).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iModularItem -> iModularItem.getOnlineModuleOrEmpty(MPSRegistryNames.JUMP_ASSIST_MODULE_REGNAME).getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(jumper -> {
                double jumpAssist = jumper.applyPropertyModifiers("multiplier") * 2.0;
                double drain = jumper.applyPropertyModifiers("jumpEnergy");
                int avail = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                if (player.field_70170_p.func_201670_d() && NuminaSettings.useSounds()) {
                    Musique.playerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JUMP_ASSIST, (SoundCategory)SoundCategory.PLAYERS, (float)((float)(jumpAssist / 8.0)), (Float)Float.valueOf(1.0f), (Boolean)false);
                }
                if (drain < (double)avail) {
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)drain));
                    this.setPlayerJumpTicks(player, jumpAssist);
                    double jumpCompensationRatio = jumper.applyPropertyModifiers("sprintExComp");
                    if (player.func_70051_ag()) {
                        player.func_71024_bL().func_75113_a((float)((double)-0.2f * jumpCompensationRatio));
                    } else {
                        player.func_71024_bL().func_75113_a((float)((double)-0.05f * jumpCompensationRatio));
                    }
                }
            }));
        }
    }

    @SubscribeEvent
    public void handleFallEvent(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && (double)event.getDistance() > 3.0) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            player.func_184582_a(EquipmentSlotType.FEET).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iModularItem -> iModularItem.getOnlineModuleOrEmpty(MPSRegistryNames.SHOCK_ABSORBER_MODULE_REGNAME).getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(sa -> {
                int avail;
                double drain;
                double distanceAbsorb = (double)event.getDistance() * sa.applyPropertyModifiers("multiplier");
                if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                    Musique.playerSound((PlayerEntity)player, (SoundEvent)SoundDictionary.SOUND_EVENT_GUI_INSTALL, (SoundCategory)SoundCategory.PLAYERS, (float)((float)distanceAbsorb), (Float)Float.valueOf(1.0f), (Boolean)false);
                }
                if ((drain = distanceAbsorb * sa.applyPropertyModifiers("shockEnergy")) < (double)(avail = ElectricItemUtils.getPlayerEnergy((LivingEntity)player))) {
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)drain));
                    event.setDistance((float)((double)event.getDistance() - distanceAbsorb));
                }
            }));
        }
    }

    static {
        root2 = Math.sqrt(2.0);
        playerJumpMultipliers = new HashMap<UUID, Double>();
    }
}

