/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.armor;

import com.github.lehjr.numina.client.model.item.armor.ArmorModelInstance;
import com.github.lehjr.numina.client.model.item.armor.HighPolyArmor;
import com.github.lehjr.numina.network.NuminaPackets;
import com.github.lehjr.numina.network.packets.CosmeticInfoPacket;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.toggleable.IToggleableModule;
import com.github.lehjr.numina.util.capabilities.render.IArmorModelSpecNBT;
import com.github.lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import com.github.lehjr.numina.util.capabilities.render.modelspec.EnumSpecType;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.numina.util.string.AdditionalInfo;
import com.github.lehjr.powersuits.basemod.MPSObjects;
import com.github.lehjr.powersuits.capability.PowerArmorCap;
import com.github.lehjr.powersuits.constants.MPSRegistryNames;
import com.github.lehjr.powersuits.item.armor.MPAArmorMaterial;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractElectricItemArmor
extends ArmorItem {
    public static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};

    public AbstractElectricItemArmor(EquipmentSlotType slots, Item.Properties builder) {
        super((IArmorMaterial)MPAArmorMaterial.EMPTY_ARMOR, slots, builder);
    }

    public AbstractElectricItemArmor(EquipmentSlotType slots) {
        super((IArmorMaterial)MPAArmorMaterial.EMPTY_ARMOR, slots, new Item.Properties().func_200917_a(1).func_200916_a((ItemGroup)MPSObjects.creativeTab).func_200918_c(0).setNoRepair());
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(iModularItem -> iModularItem.isModuleOnline(MPSRegistryNames.PIGLIN_PACIFICATION_MODULE_REGNAME)).orElse(false);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int enerConsum = (int)Math.round(stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(iItemHandler -> {
            Pair range = iItemHandler.getRangeForCategory(EnumModuleCategory.ARMOR);
            double energyUsed = 0.0;
            for (int x = ((Integer)range.getKey()).intValue(); x < (Integer)range.getRight(); ++x) {
                energyUsed += iItemHandler.getStackInSlot(x).getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> pm.applyPropertyModifiers("armorEnergyPerDamage")).orElse(0.0).doubleValue();
            }
            return energyUsed;
        }).orElse(0.0));
        if (enerConsum > 0 && entity instanceof LivingEntity) {
            ElectricItemUtils.drainPlayerEnergy(entity, (int)enerConsum);
        }
        return 0;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot != this.field_77881_a) {
            return multimap;
        }
        AtomicDouble armorVal = new AtomicDouble(0.0);
        AtomicDouble toughnessVal = new AtomicDouble(0.0);
        AtomicDouble knockbackResistance = new AtomicDouble(0.0);
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iItemHandler -> {
            Pair range = iItemHandler.getRangeForCategory(EnumModuleCategory.ARMOR);
            if (range != null) {
                for (int i = ((Integer)range.getLeft()).intValue(); i < (Integer)range.getRight(); ++i) {
                    iItemHandler.getStackInSlot(i).getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(pm -> {
                        if (pm.isAllowed()) {
                            double armorDouble = pm.applyPropertyModifiers("armorPhysical");
                            double knockBack = 0.0;
                            if (pm instanceof IToggleableModule && ((IToggleableModule)pm).isModuleOnline()) {
                                armorDouble += pm.applyPropertyModifiers("armorEnergy");
                            }
                            if (armorDouble > 0.0) {
                                knockBack = pm.applyPropertyModifiers("knockbackResistance");
                                armorVal.getAndAdd(armorDouble);
                            }
                            if (knockBack > 0.0) {
                                knockbackResistance.getAndAdd(knockBack);
                            }
                        }
                    });
                }
            }
        });
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry entry : multimap.entries()) {
            builder.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
        }
        if (armorVal.get() > 0.0) {
            builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor modifier", armorVal.get(), AttributeModifier.Operation.ADDITION));
        }
        if (knockbackResistance.get() > 0.0) {
            builder.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Knockback resistance", knockbackResistance.get(), AttributeModifier.Operation.ADDITION));
        }
        if (toughnessVal.get() > 0.0) {
            builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.func_188454_b()], "Armor toughness", toughnessVal.get(), AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    @Nullable
    public String getArmorTexture(ItemStack armor, Entity entity, EquipmentSlotType equipmentSlotType, String type) {
        if (type == "overlay") {
            return "numina:textures/item/armor/blankarmor.png";
        }
        if (!equipmentSlotType.equals((Object)armor.getEquipmentSlot())) {
            return "numina:textures/item/armor/blankarmor.png";
        }
        return armor.getCapability(ModelSpecNBTCapability.RENDER).filter(IArmorModelSpecNBT.class::isInstance).map(IArmorModelSpecNBT.class::cast).map(spec -> {
            if (spec.getSpecType() == EnumSpecType.NONE) {
                return "numina:textures/item/armor/blankarmor.png";
            }
            if (spec.getRenderTag() != null && spec.getRenderTag().isEmpty()) {
                return "numina:textures/item/armor/blankarmor.png";
            }
            return spec.getArmorTexture();
        }).orElse(AtlasTexture.field_110575_b.toString());
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, BipedModel _default) {
        return itemStack.getCapability(ModelSpecNBTCapability.RENDER).map(spec -> {
            CompoundNBT renderTag = spec.getRenderTag();
            EquipmentSlotType slot = MobEntity.func_184640_d((ItemStack)itemStack);
            if ((renderTag == null || renderTag.isEmpty()) && entityLiving == Minecraft.func_71410_x().field_71439_g && armorSlot == slot && (renderTag = spec.getDefaultRenderTag()) != null && !renderTag.isEmpty()) {
                spec.setRenderTag(renderTag, "render");
                NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new CosmeticInfoPacket(armorSlot, "render", renderTag));
            }
            if (spec.getRenderTag() != null && spec.getSpecType() == EnumSpecType.ARMOR_SKIN) {
                return _default;
            }
            HighPolyArmor model = ArmorModelInstance.getInstance();
            ItemStack chestplate = entityLiving.func_184582_a(EquipmentSlotType.CHEST);
            if (chestplate.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(iItemHandler -> iItemHandler.isModuleOnline(MPSRegistryNames.ACTIVE_CAMOUFLAGE_MODULE_REGNAME)).orElse(false).booleanValue()) {
                model.setVisibleSection(null);
            } else if (renderTag != null) {
                model.setVisibleSection(slot);
                model.setRenderSpec(renderTag);
            }
            return model;
        }).orElse(_default);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (worldIn != null) {
            AdditionalInfo.appendHoverText((ItemStack)stack, (World)worldIn, tooltip, (ITooltipFlag)flagIn);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundNBT nbt) {
        return new PowerArmorCap(stack, this.field_77881_a);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY).map(energyCap -> energyCap.getMaxEnergyStored() > 0).orElse(false);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return stack.getCapability(CapabilityEnergy.ENERGY).map(energyCap -> 1.0 - (double)energyCap.getEnergyStored() / (double)energyCap.getMaxEnergyStored()).orElse(1.0);
    }

    public boolean func_77645_m() {
        return false;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

