/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.armor;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModule;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class LeatherPlatingModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IPowerModule moduleCap;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.moduleCap = new PowerModule(module, EnumModuleCategory.ARMOR, EnumModuleTarget.ARMORONLY, MPSSettings::getModuleConfig){
                {
                    super(arg0, arg1, arg2, arg3);
                    this.addBaseProperty("armorPhysical", 3.0, "module.tradeoff.armorPoints");
                    this.addBaseProperty("maxHeat", 75.0);
                    this.addBaseProperty("knockbackResistance", 0.25);
                }

                public int getTier() {
                    return 1;
                }

                public String getModuleGroup() {
                    return "Armor";
                }
            };
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.moduleCap));
        }
    }
}

