/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.energy_generation;

import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.tickable.IPlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.tickable.PlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.toggleable.IToggleableModule;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.constants.MPSRegistryNames;
import com.github.lehjr.powersuits.event.MovementManager;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class KineticGeneratorModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IPlayerTickModule ticker;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, EnumModuleCategory.ENERGY_GENERATION, EnumModuleTarget.TORSOONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("energyPerBlock", 2000.0);
                    this.addTradeoffProperty("energyGenerated", "energyPerBlock", 6000.0, "FE");
                    this.addBaseProperty("movementResistance", 0.01f);
                    this.addTradeoffProperty("energyGenerated", "movementResistance", 0.49f, "%");
                }
            };
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap instanceof IToggleableModule) {
                ((IToggleableModule)cap).updateFromNBT();
            }
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.ticker));
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, true);
            }

            public void onPlayerTickActive(PlayerEntity player, @Nonnull ItemStack itemStackIn) {
                if (player.field_71075_bZ.field_75100_b || player.func_184218_aH() || player.func_184613_cA() || !player.func_233570_aj_()) {
                    this.onPlayerTickInactive(player, itemStackIn);
                }
                if (ElectricItemUtils.getPlayerEnergy((LivingEntity)player) < ElectricItemUtils.getMaxPlayerEnergy((LivingEntity)player)) {
                    itemStackIn.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(h -> {
                        if (!h.isModuleOnline(MPSRegistryNames.SPRINT_ASSIST_MODULE_REGNAME)) {
                            // empty if block
                        }
                        MovementManager.INSTANCE.setMovementModifier(itemStackIn, 0.0, player);
                    });
                    if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 20L == 0L && player.func_233570_aj_()) {
                        double distance = player.field_70140_Q - player.field_70141_P;
                        ElectricItemUtils.givePlayerEnergy((LivingEntity)player, (int)((int)(distance * 10.0 * this.applyPropertyModifiers("energyPerBlock"))));
                    }
                }
            }

            public void onPlayerTickInactive(PlayerEntity player, ItemStack itemStackIn) {
                itemStackIn.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(h -> {
                    if (!h.isModuleOnline(MPSRegistryNames.SPRINT_ASSIST_MODULE_REGNAME)) {
                        MovementManager.INSTANCE.setMovementModifier(itemStackIn, 0.0, player);
                    }
                });
            }
        }
    }
}

