/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.environmental;

import com.github.lehjr.numina.util.capabilities.IItemStackUpdate;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.tickable.IPlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.tickable.PlayerTickModule;
import com.github.lehjr.numina.util.heat.MuseHeatUtils;
import com.github.lehjr.numina.util.nbt.MuseNBTUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidTankModule
extends AbstractPowerModule {
    static final String FLUID_NBT_KEY = "Fluid";
    static final double coolingFactor = 0.2;

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IPlayerTickModule ticker;
        IFluidHandlerItem fluidHandler;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, EnumModuleCategory.ENVIRONMENTAL, EnumModuleTarget.TORSOONLY, MPSSettings::getModuleConfig, true){
                {
                    super(module, category, target, config, defBool);
                    this.addBaseProperty("fluidTankSize", 20000.0);
                    this.addBaseProperty("heatActivationPercent", 0.5);
                    this.addTradeoffProperty("activationPercent", "heatActivationPercent", 0.5, "%");
                }
            };
            this.fluidHandler = new ModuleTank((int)this.ticker.applyPropertyModifiers("fluidTankSize"));
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.fluidHandler));
            }
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.ticker));
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config, boolean defBool) {
                super(module, category, target, config, defBool);
            }

            public void onPlayerTickActive(PlayerEntity player, @Nonnull ItemStack item) {
                double maxHeat;
                double currentHeat;
                if (player.func_130014_f_().func_82737_E() % 10L == 0L) {
                    int maxFluid = CapProvider.this.fluidHandler.getTankCapacity(0);
                    int currentFluid = CapProvider.this.fluidHandler.getFluidInTank(0).getAmount();
                    if (currentFluid < maxFluid) {
                        FluidStack water;
                        BlockPos pos = player.func_233580_cy_();
                        BlockState blockstate = player.field_70170_p.func_180495_p(pos);
                        if (player.func_70090_H() && player.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_203203_C) {
                            Fluid fluid;
                            FluidStack water2;
                            if (blockstate.func_177230_c() instanceof IBucketPickupHandler && blockstate.func_204520_s().func_206886_c() == Fluids.field_204546_a && CapProvider.this.fluidHandler.fill(water2 = new FluidStack(fluid = ((IBucketPickupHandler)blockstate.func_177230_c()).func_204508_a((IWorld)player.field_70170_p, pos, blockstate), 1000), IFluidHandler.FluidAction.EXECUTE) > 0) {
                                player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                            }
                        } else if (player.func_203008_ap() && CapProvider.this.fluidHandler.fill(water = new FluidStack((Fluid)Fluids.field_204546_a, 100), IFluidHandler.FluidAction.EXECUTE) > 0) {
                            player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
                        }
                    }
                }
                if ((currentHeat = MuseHeatUtils.getPlayerHeat((LivingEntity)player)) / (maxHeat = MuseHeatUtils.getPlayerMaxHeat((LivingEntity)player)) >= CapProvider.this.ticker.applyPropertyModifiers("heatActivationPercent")) {
                    double coolAmount = (double)CapProvider.this.fluidHandler.drain((int)Math.min(1000.0, currentHeat / 0.2), player.field_70170_p.field_72995_K ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE).getAmount() * 0.2;
                    MuseHeatUtils.coolPlayer((LivingEntity)player, (double)coolAmount);
                    if (coolAmount > 0.0) {
                        player.field_70170_p.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187541_bC, SoundCategory.MASTER, 1.0f, 1.0f);
                        for (int i = 0; i < 4; ++i) {
                            player.field_70170_p.func_195589_b((IParticleData)ParticleTypes.field_197601_L, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }

        class ModuleTank
        extends FluidTank
        implements IItemStackUpdate,
        IFluidTank,
        IFluidHandler,
        IFluidHandlerItem,
        INBTSerializable<CompoundNBT> {
            public ModuleTank(int capacity) {
                super(capacity);
                this.updateFromNBT();
            }

            protected void onContentsChanged() {
                MuseNBTUtils.getModuleTag((ItemStack)CapProvider.this.module).func_218657_a(FluidTankModule.FLUID_NBT_KEY, (INBT)this.writeToNBT(new CompoundNBT()));
            }

            @Nonnull
            public ItemStack getContainer() {
                return CapProvider.this.module;
            }

            public void updateFromNBT() {
                CompoundNBT nbt = MuseNBTUtils.getModuleTag((ItemStack)CapProvider.this.module);
                if (nbt != null && nbt.func_150297_b(FluidTankModule.FLUID_NBT_KEY, 10)) {
                    this.deserializeNBT(nbt.func_74775_l(FluidTankModule.FLUID_NBT_KEY));
                }
            }

            public CompoundNBT serializeNBT() {
                return this.writeToNBT(new CompoundNBT());
            }

            public void deserializeNBT(CompoundNBT nbt) {
                this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt));
            }
        }
    }
}

