/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.miningenhancement;

import com.github.lehjr.numina.util.capabilities.module.enchantment.IEnchantmentModule;
import com.github.lehjr.numina.util.capabilities.module.miningenhancement.IMiningEnhancementModule;
import com.github.lehjr.numina.util.capabilities.module.miningenhancement.MiningEnhancement;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FortuneModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IMiningEnhancementModule miningEnhancement;
        IEnchantmentModule enchantmentModule;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.miningEnhancement = new Enhancement(module, EnumModuleCategory.MINING_ENHANCEMENT, EnumModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("fortuneEnCon", 500.0, "FE");
                    this.addTradeoffProperty("enchLevel", "fortuneEnCon", 9500.0);
                    this.addIntTradeoffProperty("enchLevel", "fortuneLevel", 3, "", 1, 1);
                }
            };
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.miningEnhancement));
        }

        class Enhancement
        extends MiningEnhancement
        implements IEnchantmentModule {
            public Enhancement(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
                if (!player.field_70170_p.field_72995_K) {
                    if (this.getEnergyUsage() > ElectricItemUtils.getPlayerEnergy((LivingEntity)player)) {
                        CapProvider.this.enchantmentModule.removeEnchantment(itemstack);
                    } else {
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)this.getEnergyUsage());
                    }
                }
                return false;
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("fortuneEnCon");
            }

            public Enchantment getEnchantment() {
                return Enchantments.field_185308_t;
            }

            public int getLevel(@Nonnull ItemStack itemStack) {
                return (int)this.applyPropertyModifiers("fortuneLevel");
            }
        }
    }
}

