/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.movement;

import com.github.lehjr.numina.config.NuminaSettings;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.tickable.IPlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.tickable.PlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.toggleable.IToggleableModule;
import com.github.lehjr.numina.util.client.control.PlayerMovementInputWrapper;
import com.github.lehjr.numina.util.client.sound.Musique;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.client.sound.MPSSoundDictionary;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.constants.MPSRegistryNames;
import com.github.lehjr.powersuits.event.MovementManager;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class JetBootsModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IPlayerTickModule ticker;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, EnumModuleCategory.MOVEMENT, EnumModuleTarget.FEETONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("jetbootsEnergy", 0.0);
                    this.addBaseProperty("jetbootsThrust", 0.0);
                    this.addTradeoffProperty("thrust", "jetbootsEnergy", 750.0, "FE");
                    this.addTradeoffProperty("thrust", "jetbootsThrust", 0.08f);
                }
            };
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap instanceof IToggleableModule) {
                ((IToggleableModule)cap).updateFromNBT();
            }
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.ticker));
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, false);
            }

            public void onPlayerTickActive(PlayerEntity player, ItemStack item) {
                if (player.func_70090_H()) {
                    return;
                }
                boolean hasFlightControl = player.func_184582_a(EquipmentSlotType.HEAD).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).map(m -> m.isModuleOnline(MPSRegistryNames.FLIGHT_CONTROL_MODULE_REGNAME)).orElse(false);
                double jetEnergy = this.applyPropertyModifiers("jetbootsEnergy");
                double thrust = this.applyPropertyModifiers("jetbootsThrust");
                PlayerMovementInputWrapper.PlayerMovementInput playerInput = PlayerMovementInputWrapper.get((PlayerEntity)player);
                if (jetEnergy < (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player)) {
                    if (hasFlightControl && thrust > 0.0) {
                        thrust = MovementManager.thrust(player, thrust, true);
                        if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                            Musique.playerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JETBOOTS, (SoundCategory)SoundCategory.PLAYERS, (float)((float)(thrust * 12.5)), (Float)Float.valueOf(1.0f), (Boolean)true);
                        }
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)(thrust * jetEnergy)));
                    } else if (playerInput.jumpKey && player.func_213322_ci().field_72448_b < 0.5) {
                        thrust = MovementManager.thrust(player, thrust, false);
                        if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                            Musique.playerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JETBOOTS, (SoundCategory)SoundCategory.PLAYERS, (float)((float)(thrust * 12.5)), (Float)Float.valueOf(1.0f), (Boolean)true);
                        }
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)(thrust * jetEnergy)));
                    } else if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                        Musique.stopPlayerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JETBOOTS);
                    }
                } else if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                    Musique.stopPlayerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JETBOOTS);
                }
            }

            public void onPlayerTickInactive(PlayerEntity player, ItemStack item) {
                if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                    Musique.stopPlayerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.JETBOOTS);
                }
            }
        }
    }
}

