/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.special;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.tickable.IPlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.tickable.PlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.toggleable.IToggleableModule;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class MagnetModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IPlayerTickModule ticker;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, EnumModuleCategory.SPECIAL, EnumModuleTarget.TORSOONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("magnetEnergy", 0.0, "FE");
                    this.addTradeoffProperty("magnetPower", "magnetEnergy", 2000.0);
                    this.addBaseProperty("radius", 5.0);
                    this.addTradeoffProperty("magnetPower", "radius", 10.0);
                }
            };
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap instanceof IToggleableModule) {
                ((IToggleableModule)cap).updateFromNBT();
            }
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.ticker));
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, false);
            }

            public void onPlayerTickActive(PlayerEntity player, ItemStack stack) {
                int energyUSage = (int)this.applyPropertyModifiers("magnetEnergy");
                if (ElectricItemUtils.getPlayerEnergy((LivingEntity)player) > energyUSage) {
                    boolean isServerSide;
                    boolean bl = isServerSide = !player.field_70170_p.field_72995_K;
                    if (player.field_70170_p.func_82737_E() % 20L == 0L && isServerSide) {
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)energyUSage);
                    }
                    int range = (int)this.applyPropertyModifiers("radius");
                    World world = player.field_70170_p;
                    AxisAlignedBB bounds = player.func_174813_aQ().func_186662_g((double)range);
                    if (isServerSide) {
                        bounds.func_72321_a(0.2000000029802322, 0.2000000029802322, 0.2000000029802322);
                        if (stack.func_77952_i() >> 1 >= 7) {
                            List arrows = world.func_217357_a(ArrowEntity.class, bounds);
                            for (ArrowEntity arrow : arrows) {
                                if (arrow.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED && world.field_73012_v.nextInt(6) == 0) {
                                    ItemEntity replacement = new ItemEntity(world, arrow.func_226277_ct_(), arrow.func_226278_cu_(), arrow.func_226281_cx_(), new ItemStack((IItemProvider)Items.field_151032_g));
                                    world.func_217376_c((Entity)replacement);
                                }
                                arrow.func_70106_y();
                            }
                        }
                    }
                    for (ItemEntity e : world.func_217357_a(ItemEntity.class, bounds)) {
                        if (!e.func_70089_S() || e.func_92059_d().func_190926_b() || e.func_174874_s()) continue;
                        if (isServerSide) {
                            double x = player.func_226277_ct_() - e.func_226277_ct_();
                            double y = player.func_226278_cu_() - e.func_226278_cu_();
                            double z = player.func_226281_cx_() - e.func_226281_cx_();
                            double length = Math.sqrt(x * x + y * y + z * z) * 0.75;
                            x = x / length + player.func_213322_ci().field_72450_a * 22.0;
                            y = y / length + player.func_213322_ci().field_72448_b / 22.0;
                            z = z / length + player.func_213322_ci().field_72449_c * 22.0;
                            e.func_213293_j(x, y, z);
                            e.field_70160_al = true;
                            if (!e.field_70123_F) continue;
                            e.func_213317_d(e.func_213322_ci().func_72441_c(0.0, 1.0, 0.0));
                            continue;
                        }
                        if (world.field_73012_v.nextInt(20) != 0) continue;
                        float pitch = 0.85f - world.field_73012_v.nextFloat() * 3.0f / 10.0f;
                        world.func_184134_a(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 0.6f, pitch, true);
                    }
                }
            }
        }
    }
}

