/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.tool;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.rightclick.IRightClickModule;
import com.github.lehjr.numina.util.capabilities.module.rightclick.RightClickModule;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.numina.util.heat.MuseHeatUtils;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.entity.LuxCapacitorEntity;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class LuxCapacitorModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IRightClickModule rightClick;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.rightClick = new RightClickie(module, EnumModuleCategory.TOOL, EnumModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("luxCapEnergy", 1000.0, "FE");
                    this.addTradeoffProperty("red", "redHue", 1.0, "%");
                    this.addTradeoffProperty("green", "greenHue", 1.0, "%");
                    this.addTradeoffProperty("blue", "blueHue", 1.0, "%");
                    this.addTradeoffProperty("alpha", "opacity", 1.0, "%");
                }
            };
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.rightClick));
        }

        class RightClickie
        extends RightClickModule {
            public RightClickie(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
                float energyConsumption = this.getEnergyUsage();
                if ((float)ElectricItemUtils.getPlayerEnergy((LivingEntity)playerIn) > energyConsumption) {
                    if (!worldIn.field_72995_K) {
                        MuseHeatUtils.heatPlayer((LivingEntity)playerIn, (double)(energyConsumption / 500.0f));
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)playerIn, (int)((int)energyConsumption));
                        float red = (float)this.applyPropertyModifiers("redHue");
                        float green = (float)this.applyPropertyModifiers("greenHue");
                        float blue = (float)this.applyPropertyModifiers("blueHue");
                        float alpha = (float)this.applyPropertyModifiers("opacity");
                        LuxCapacitorEntity luxCapacitor = new LuxCapacitorEntity(worldIn, (LivingEntity)playerIn, new Colour(red, green, blue, alpha));
                        worldIn.func_217376_c((Entity)luxCapacitor);
                    }
                    return ActionResult.func_226248_a_((Object)itemStackIn);
                }
                return ActionResult.func_226250_c_((Object)itemStackIn);
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("luxCapEnergy");
            }
        }
    }
}

