/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.tool;

import com.github.lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.rightclick.IRightClickModule;
import com.github.lehjr.numina.util.capabilities.module.rightclick.RightClickModule;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ShearsModule
extends AbstractPowerModule {
    static final ArrayList<Material> materials = new ArrayList<Material>(){
        {
            this.add(Material.field_151585_k);
            this.add(Material.field_203243_f);
            this.add(Material.field_151582_l);
            this.add(Material.field_204868_h);
            this.add(Material.field_151569_G);
            this.add(Material.field_151580_n);
            this.add(Material.field_151584_j);
        }
    };

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IRightClickModule rightClick;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.rightClick = new BlockBreaker(module, EnumModuleCategory.TOOL, EnumModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("shearsEnergy", 1000.0, "FE");
                    this.addBaseProperty("shearsHarvestSpeed", 8.0, "x");
                }
            };
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.rightClick));
        }

        class BlockBreaker
        extends RightClickModule
        implements IBlockBreakingModule {
            public BlockBreaker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public boolean onBlockDestroyed(ItemStack itemStack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving, int playerEnergy) {
                if (entityLiving.field_70170_p.func_201670_d() || state.func_177230_c().func_203417_a((ITag)BlockTags.field_232872_am_)) {
                    return false;
                }
                Block block = state.func_177230_c();
                if (block instanceof IForgeShearable && ElectricItemUtils.getPlayerEnergy((LivingEntity)entityLiving) > this.getEnergyUsage()) {
                    IForgeShearable target = (IForgeShearable)block;
                    if (target.isShearable(itemStack, entityLiving.field_70170_p, pos)) {
                        List drops = target.onSheared((PlayerEntity)entityLiving, itemStack, entityLiving.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack));
                        Random rand = new Random();
                        drops.forEach(d -> {
                            ItemEntity ent = entityLiving.func_70099_a(d, 1.0f);
                            ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                        });
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)entityLiving, (int)this.getEnergyUsage());
                    }
                    return true;
                }
                return false;
            }

            public ItemStack getEmulatedTool() {
                return new ItemStack((IItemProvider)Items.field_151097_aZ);
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("shearsEnergy");
            }

            public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
                event.setNewSpeed((float)((double)event.getNewSpeed() * this.applyPropertyModifiers("shearsHarvestSpeed")));
            }

            public ActionResult interactLivingEntity(ItemStack itemStackIn, PlayerEntity playerIn, LivingEntity entity, Hand hand) {
                if (playerIn.field_70170_p.field_72995_K) {
                    return ActionResult.func_226250_c_((Object)itemStackIn);
                }
                if (entity instanceof IForgeShearable && ElectricItemUtils.getPlayerEnergy((LivingEntity)playerIn) > this.getEnergyUsage()) {
                    IForgeShearable target = (IForgeShearable)entity;
                    BlockPos pos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                    if (target.isShearable(itemStackIn, entity.field_70170_p, pos)) {
                        List drops = target.onSheared(playerIn, itemStackIn, entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStackIn));
                        Random rand = new Random();
                        drops.forEach(d -> {
                            ItemEntity ent = entity.func_70099_a(d, 1.0f);
                            ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                        });
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)playerIn, (int)this.getEnergyUsage());
                    }
                    return ActionResult.func_226248_a_((Object)itemStackIn);
                }
                return ActionResult.func_226250_c_((Object)itemStackIn);
            }
        }
    }
}

