/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.network.packets;

import com.github.lehjr.powersuits.container.InstallSalvageContainer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class ContainerGuiOpenPacket {
    EquipmentSlotType type;

    public ContainerGuiOpenPacket(EquipmentSlotType typeIn) {
        this.type = typeIn;
    }

    public static void write(ContainerGuiOpenPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_179249_a((Enum)msg.type);
    }

    public static ContainerGuiOpenPacket read(PacketBuffer packetBuffer) {
        return new ContainerGuiOpenPacket((EquipmentSlotType)packetBuffer.func_179257_a(EquipmentSlotType.class));
    }

    public static void handle(ContainerGuiOpenPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            SimpleNamedContainerProvider container = new SimpleNamedContainerProvider((id, inventory, player) -> new InstallSalvageContainer(id, inventory, msg.type), (ITextComponent)new TranslationTextComponent("gui.powersuits.tab.install.salvage"));
            NetworkHooks.openGui((ServerPlayerEntity)((NetworkEvent.Context)ctx.get()).getSender(), (INamedContainerProvider)container, buffer -> buffer.func_179249_a((Enum)msg.type));
        });
        ctx.get().setPacketHandled(true);
    }
}

