/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.connected.plane;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.metadata.IMetadataKey;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.util.IQuadFunction;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class ConnectedPlaneChiselingMode
extends ForgeRegistryEntry<IChiselMode>
implements IChiselMode {
    private final int depth;
    private final IFormattableTextComponent displayName;
    private final IFormattableTextComponent multiLineDisplayName;
    private final ResourceLocation iconName;

    public ConnectedPlaneChiselingMode(int depth, IFormattableTextComponent displayName, IFormattableTextComponent multiLineDisplayName, ResourceLocation iconName) {
        this.depth = depth;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(PlayerEntity playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, Direction::func_176734_d, face -> Vector3d.func_237491_b_((Vector3i)face.func_176734_d().func_176730_m()), IQuadFunction.fourthIdentity(), position -> IMutatorFactory.getInstance().in(context.getWorld(), new BlockPos(position)), direction -> Vector3i.field_177959_e);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                context.setComplete();
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(builder -> (Predicate)builder.apply(mutator)).orElse(state -> true);
                mutator.inWorldMutableStream().filter(filter).forEach(state -> {
                    BlockState currentState = state.getState();
                    if (context.tryDamageItem()) {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    }
                });
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return new ClickProcessingState(true, Event.Result.ALLOW);
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(PlayerEntity playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(PlayerEntity playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, UnaryOperator.identity(), face -> Vector3d.func_237491_b_((Vector3i)face.func_176730_m()), (hitPos, inBlockTargetedPosition, hitFace, candidatePosition) -> {
            if (inBlockTargetedPosition.equals(candidatePosition)) {
                return Vector3d.func_237491_b_((Vector3i)hitPos).func_178787_e(inBlockTargetedPosition).func_178787_e(Vector3d.func_237491_b_((Vector3i)hitFace.func_176734_d().func_176730_m()).func_216369_h(StateEntrySize.current().getSizePerBitScalingVector()));
            }
            Vector3d relevantAxisCandidate = candidatePosition.func_216372_d((double)Math.abs(hitFace.func_176730_m().func_177958_n()), (double)Math.abs(hitFace.func_176730_m().func_177956_o()), (double)Math.abs(hitFace.func_176730_m().func_177952_p()));
            Vector3d noneRelevantAxisCandidates = candidatePosition.func_178788_d(relevantAxisCandidate);
            Vector3d relevantAxisTarget = inBlockTargetedPosition.func_216372_d((double)Math.abs(hitFace.func_176730_m().func_177958_n()), (double)Math.abs(hitFace.func_176730_m().func_177956_o()), (double)Math.abs(hitFace.func_176730_m().func_177952_p()));
            Vector3d offset = candidatePosition.func_178788_d(inBlockTargetedPosition);
            Vector3d relevantAxisOffset = offset.func_216372_d((double)Math.abs(hitFace.func_176730_m().func_177958_n()), (double)Math.abs(hitFace.func_176730_m().func_177956_o()), (double)Math.abs(hitFace.func_176730_m().func_177952_p()));
            return noneRelevantAxisCandidates.func_178787_e(relevantAxisTarget).func_178788_d(relevantAxisOffset).func_72441_c((double)hitPos.func_177958_n(), (double)hitPos.func_177956_o(), (double)hitPos.func_177952_p()).func_178787_e(Vector3d.func_237491_b_((Vector3i)hitFace.func_176734_d().func_176730_m()).func_216369_h(StateEntrySize.current().getSizePerBitScalingVector()));
        }, position -> IMutatorFactory.getInstance().covering(context.getWorld(), new BlockPos(position.func_178786_a(1.0, 1.0, 1.0)), new BlockPos(position.func_72441_c(1.0, 1.0, 1.0))), direction -> new Vector3i(direction.func_176730_m().func_177958_n() * this.depth, direction.func_176730_m().func_177956_o() * this.depth, direction.func_176730_m().func_177952_p() * this.depth));
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            BlockState heldBlockState = ItemStackUtils.getHeldBitBlockStateFromPlayer(playerEntity);
            if (heldBlockState.isAir((IBlockReader)new SingleBlockBlockReader(heldBlockState), BlockPos.field_177992_a)) {
                return ClickProcessingState.DEFAULT;
            }
            Predicate<IStateEntryInfo> filter = context.getStateFilter().map(builder -> (Predicate)builder.apply(mutator)).orElse(state -> true);
            int missingBitCount = (int)mutator.stream().filter(state -> state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) && filter.test((IStateEntryInfo)state)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.func_184812_l_()) {
                if (!playerEntity.func_184812_l_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) && filter.test((IStateEntryInfo)state)).forEach(state -> state.overrideState(heldBlockState));
                }
            }
            return new ClickProcessingState(true, Event.Result.ALLOW);
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedRightClicking(PlayerEntity playerEntity, IChiselingContext context) {
    }

    @Override
    public boolean isStillValid(PlayerEntity playerEntity, IChiselingContext context, ChiselingOperation modeOfOperation) {
        Optional validPositions = context.getMetadata((IMetadataKey)ModMetadataKeys.VALID_POSITIONS.get());
        Optional targetedSide = context.getMetadata((IMetadataKey)ModMetadataKeys.TARGETED_SIDE.get());
        Optional targetedBlockPos = context.getMetadata((IMetadataKey)ModMetadataKeys.TARGETED_BLOCK.get());
        if (!(validPositions.isPresent() && targetedSide.isPresent() && targetedBlockPos.isPresent())) {
            return false;
        }
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK || !(rayTraceResult instanceof BlockRayTraceResult)) {
            return false;
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        if (blockRayTraceResult.func_216354_b() != targetedSide.get()) {
            return false;
        }
        Function<Direction, Vector3d> placementFacingAdapter = modeOfOperation == ChiselingOperation.CHISELING ? face -> Vector3d.func_237491_b_((Vector3i)face.func_176734_d().func_176730_m()) : face -> Vector3d.func_237491_b_((Vector3i)face.func_176730_m());
        Vector3d hitVector = blockRayTraceResult.func_216347_e().func_178787_e(placementFacingAdapter.apply(blockRayTraceResult.func_216354_b()).func_216372_d((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        BlockPos hitPos = new BlockPos(hitVector);
        Vector3d hitBlockPosVector = Vector3d.func_237491_b_((Vector3i)hitPos);
        Vector3d inBlockHitVector = hitVector.func_178788_d(hitBlockPosVector);
        Vector3i selectedPosition = new Vector3i(inBlockHitVector.func_82615_a() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.func_82617_b() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.func_82616_c() * (double)StateEntrySize.current().getBitsPerBlockSide());
        return ((Set)validPositions.get()).contains(selectedPosition) && hitPos.equals(targetedBlockPos.get());
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(PlayerEntity playerEntity, IChiselingContext context, UnaryOperator<Direction> searchDirectionAdapter, Function<Direction, Vector3d> placementFacingAdapter, IQuadFunction<BlockPos, Vector3d, Direction, Vector3d, Vector3d> stateExtractionAdapter, Function<Vector3d, IAreaAccessor> areaAccessorBuilder, Function<Direction, Vector3i> filterOffsetProducer) {
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK || !(rayTraceResult instanceof BlockRayTraceResult)) {
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        Vector3d hitVector = blockRayTraceResult.func_216347_e().func_178787_e(placementFacingAdapter.apply(blockRayTraceResult.func_216354_b()).func_216372_d((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        BlockPos hitPos = new BlockPos(hitVector);
        Vector3d hitBlockPosVector = Vector3d.func_237491_b_((Vector3i)hitPos);
        Vector3d inBlockHitVector = hitVector.func_178788_d(hitBlockPosVector);
        LinkedList<Vector3i> toProcess = new LinkedList<Vector3i>();
        IAreaAccessor worldAccessor = areaAccessorBuilder.apply(hitVector);
        HashSet<Vector3i> processed = new HashSet<Vector3i>();
        HashSet<Vector3i> validPositions = new HashSet<Vector3i>();
        HashSet<Vector3i> offsets = new HashSet<Vector3i>();
        offsets.add(((Direction)searchDirectionAdapter.apply(blockRayTraceResult.func_216354_b())).func_176730_m());
        Arrays.stream(Direction.values()).filter(direction -> direction.func_176740_k() != blockRayTraceResult.func_216354_b().func_176740_k()).map(Direction::func_176730_m).forEach(offsets::add);
        Vector3i selectedPosition = new Vector3i(inBlockHitVector.func_82615_a() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.func_82617_b() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.func_82616_c() * (double)StateEntrySize.current().getBitsPerBlockSide());
        toProcess.addLast(selectedPosition);
        Vector3i relevantSelectedAxisVector = new Vector3i(selectedPosition.func_177958_n() * Math.abs(blockRayTraceResult.func_216354_b().func_176730_m().func_177958_n()), selectedPosition.func_177956_o() * Math.abs(blockRayTraceResult.func_216354_b().func_176730_m().func_177956_o()), selectedPosition.func_177952_p() * Math.abs(blockRayTraceResult.func_216354_b().func_176730_m().func_177952_p()));
        Vector3d selectedInBlockPosition = Vector3d.func_237491_b_((Vector3i)selectedPosition).func_216369_h(StateEntrySize.current().getSizePerBitScalingVector());
        Optional<IStateEntryInfo> targetedInfo = worldAccessor.getInAreaTarget(stateExtractionAdapter.apply(hitPos, selectedInBlockPosition, blockRayTraceResult.func_216354_b(), selectedInBlockPosition));
        if (!targetedInfo.isPresent()) {
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        while (!toProcess.isEmpty()) {
            IStateEntryInfo target;
            Vector3i targetedPosition = (Vector3i)toProcess.removeFirst();
            Vector3d targetedInBlockPosition = Vector3d.func_237491_b_((Vector3i)targetedPosition).func_216369_h(StateEntrySize.current().getSizePerBitScalingVector());
            Optional<IStateEntryInfo> targetCandidate = worldAccessor.getInAreaTarget(stateExtractionAdapter.apply(hitPos, selectedInBlockPosition, blockRayTraceResult.func_216354_b(), targetedInBlockPosition));
            processed.add(targetedPosition);
            if (!targetCandidate.isPresent() || !(target = targetCandidate.get()).getState().equals(targetedInfo.get().getState())) continue;
            validPositions.add(targetedPosition);
            offsets.forEach(offset -> {
                Vector3i newTarget = new Vector3i(targetedPosition.func_177958_n() + offset.func_177958_n(), targetedPosition.func_177956_o() + offset.func_177956_o(), targetedPosition.func_177952_p() + offset.func_177952_p());
                if (newTarget.func_177958_n() >= 0 && newTarget.func_177958_n() < StateEntrySize.current().getBitsPerBlockSide() && newTarget.func_177956_o() >= 0 && newTarget.func_177956_o() < StateEntrySize.current().getBitsPerBlockSide() && newTarget.func_177952_p() >= 0 && newTarget.func_177952_p() < StateEntrySize.current().getBitsPerBlockSide()) {
                    Vector3i relevantNewTargetAxisVector = new Vector3i(newTarget.func_177958_n() * Math.abs(blockRayTraceResult.func_216354_b().func_176730_m().func_177958_n()), newTarget.func_177956_o() * Math.abs(blockRayTraceResult.func_216354_b().func_176730_m().func_177956_o()), newTarget.func_177952_p() * Math.abs(blockRayTraceResult.func_216354_b().func_176730_m().func_177952_p()));
                    int targetedDepth = Math.abs(relevantSelectedAxisVector.func_243648_a(blockRayTraceResult.func_216354_b().func_176740_k()) - relevantNewTargetAxisVector.func_243648_a(blockRayTraceResult.func_216354_b().func_176740_k()));
                    if (targetedDepth <= this.depth - 1 && !processed.contains(newTarget) && !toProcess.contains(newTarget)) {
                        toProcess.addLast(newTarget);
                    }
                } else {
                    processed.add(newTarget);
                }
            });
        }
        context.include(hitPos, Vector3d.field_186680_a);
        context.include(hitPos, new Vector3d(0.9999, 0.9999, 0.9999));
        context.setStateFilter(accessor -> new SelectedBitStateFilter((Vector3i)filterOffsetProducer.apply(blockRayTraceResult.func_216354_b()), validPositions));
        context.setMetadata((IMetadataKey)ModMetadataKeys.VALID_POSITIONS.get(), validPositions);
        context.setMetadata((IMetadataKey)ModMetadataKeys.TARGETED_SIDE.get(), blockRayTraceResult.func_216354_b());
        context.setMetadata((IMetadataKey)ModMetadataKeys.TARGETED_BLOCK.get(), hitPos);
        return Optional.empty();
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.CONNECTED_PLANE);
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public ITextComponent getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    private static final class SelectedBitStateFilter
    implements Predicate<IStateEntryInfo> {
        private final Vector3i offset;
        private final Set<Vector3i> validPositions;

        public SelectedBitStateFilter(Vector3i offset, Set<Vector3i> validPositions) {
            this.offset = offset;
            this.validPositions = validPositions;
        }

        @Override
        public boolean test(IStateEntryInfo iStateEntryInfo) {
            Vector3i position = new Vector3i(iStateEntryInfo.getStartPoint().func_82615_a() * (double)StateEntrySize.current().getBitsPerBlockSide(), iStateEntryInfo.getStartPoint().func_82617_b() * (double)StateEntrySize.current().getBitsPerBlockSide(), iStateEntryInfo.getStartPoint().func_82616_c() * (double)StateEntrySize.current().getBitsPerBlockSide());
            return this.validPositions.contains(position);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SelectedBitStateFilter)) {
                return false;
            }
            SelectedBitStateFilter that = (SelectedBitStateFilter)o;
            if (!this.offset.equals((Object)that.offset)) {
                return false;
            }
            return this.validPositions.equals(that.validPositions);
        }

        public int hashCode() {
            int result = this.offset.hashCode();
            result = 31 * result + this.validPositions.hashCode();
            return result;
        }

        public String toString() {
            return "SelectedBitStateFilter{offset=" + this.offset + ", validPositions=" + this.validPositions + '}';
        }
    }
}

