/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.chiseled;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhood;
import mod.chiselsandbits.api.neighborhood.IBlockNeighborhoodBuilder;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.profiling.ProfilingManager;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledBlockBakedModelManager {
    private static final ChiseledBlockBakedModelManager INSTANCE = new ChiseledBlockBakedModelManager();
    private final SimpleMaxSizedCache<Key, ChiseledBlockBakedModel> cache = new SimpleMaxSizedCache(() -> (Long)Configuration.getInstance().getClient().modelCacheSize.get() * (long)RenderType.func_228661_n_().size());

    private ChiseledBlockBakedModelManager() {
    }

    public static ChiseledBlockBakedModelManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public Optional<ChiseledBlockBakedModel> get(IMultiStateItemStack multiStateItemStack, ChiselRenderType renderType) {
        try (IProfilerSection ignored = ProfilingManager.getInstance().withSection("Item based chiseled block model");){
            Optional<ChiseledBlockBakedModel> optional = Optional.of(this.get(multiStateItemStack, multiStateItemStack.getStatistics().getPrimaryState(), renderType, null, null, BlockPos.field_177992_a));
            return optional;
        }
    }

    public ChiseledBlockBakedModel get(IAreaAccessor accessor, BlockState primaryState, ChiselRenderType renderType) {
        return this.get(accessor, primaryState, renderType, null, null, BlockPos.field_177992_a);
    }

    public ChiseledBlockBakedModel get(IAreaAccessor accessor, BlockState primaryState, ChiselRenderType renderType, @Nullable Function<Direction, BlockState> neighborhoodBlockStateProvider, @Nullable Function<Direction, IAreaAccessor> neighborhoodAreaAccessorProvider, @NotNull BlockPos position) {
        try (IProfilerSection ignored1 = ProfilingManager.getInstance().withSection("Block based chiseled block model");){
            long primaryStateRenderSeed = primaryState.func_209533_a(position);
            Key key = new Key(accessor.createNewShapeIdentifier(), primaryState, renderType, IBlockNeighborhoodBuilder.getInstance().build(neighborhoodBlockStateProvider, neighborhoodAreaAccessorProvider), primaryStateRenderSeed);
            ChiseledBlockBakedModel chiseledBlockBakedModel = this.cache.get(key, () -> {
                try (IProfilerSection ignored3 = ProfilingManager.getInstance().withSection("Cache mis");){
                    ChiseledBlockBakedModel chiseledBlockBakedModel = new ChiseledBlockBakedModel(primaryState, renderType, accessor, targetOffset -> {
                        IAreaAccessor neighborAccessor;
                        Vector3d nominalTargetOffset = Vector3d.field_186680_a.func_178787_e(targetOffset);
                        BlockPos nominalTargetBlockOffset = new BlockPos(nominalTargetOffset);
                        Vector3d inBlockOffset = nominalTargetOffset.func_178788_d(Vector3d.func_237491_b_((Vector3i)nominalTargetBlockOffset));
                        Vector3d inBlockOffsetTarget = VectorUtils.makePositive(inBlockOffset);
                        Direction offsetDirection = Direction.func_176737_a((float)nominalTargetBlockOffset.func_177958_n(), (float)nominalTargetBlockOffset.func_177956_o(), (float)nominalTargetBlockOffset.func_177952_p());
                        if (targetOffset.func_82615_a() >= 0.0 && targetOffset.func_82615_a() < 1.0 && targetOffset.func_82617_b() >= 0.0 && targetOffset.func_82617_b() < 1.0 && targetOffset.func_82616_c() >= 0.0 && targetOffset.func_82616_c() < 1.0) {
                            neighborAccessor = accessor;
                        } else {
                            IAreaAccessor iAreaAccessor = neighborAccessor = neighborhoodAreaAccessorProvider != null ? (IAreaAccessor)neighborhoodAreaAccessorProvider.apply(offsetDirection) : null;
                        }
                        if (neighborAccessor != null) {
                            return neighborAccessor.getInAreaTarget(inBlockOffsetTarget).map(IStateEntryInfo::getState).orElse(Blocks.field_150350_a.func_176223_P());
                        }
                        return neighborhoodBlockStateProvider != null ? (BlockState)neighborhoodBlockStateProvider.apply(offsetDirection) : Blocks.field_150350_a.func_176223_P();
                    }, primaryStateRenderSeed);
                    return chiseledBlockBakedModel;
                }
            });
            return chiseledBlockBakedModel;
        }
    }

    private static final class Key {
        private final IAreaShapeIdentifier identifier;
        private final BlockState primaryState;
        private final ChiselRenderType renderType;
        private final IBlockNeighborhood neighborhood;
        private final long renderSeed;

        private Key(IAreaShapeIdentifier identifier, BlockState primaryState, ChiselRenderType renderType, IBlockNeighborhood neighborhood, long renderSeed) {
            this.identifier = identifier;
            this.primaryState = primaryState;
            this.renderType = renderType;
            this.neighborhood = neighborhood;
            this.renderSeed = renderSeed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.renderSeed != key.renderSeed) {
                return false;
            }
            if (!Objects.equals(this.identifier, key.identifier)) {
                return false;
            }
            if (!Objects.equals(this.primaryState, key.primaryState)) {
                return false;
            }
            if (this.renderType != key.renderType) {
                return false;
            }
            return Objects.equals(this.neighborhood, key.neighborhood);
        }

        public int hashCode() {
            int result = this.identifier != null ? this.identifier.hashCode() : 0;
            result = 31 * result + (this.primaryState != null ? this.primaryState.hashCode() : 0);
            result = 31 * result + (this.renderType != null ? this.renderType.hashCode() : 0);
            result = 31 * result + (this.neighborhood != null ? this.neighborhood.hashCode() : 0);
            result = 31 * result + (int)(this.renderSeed ^ this.renderSeed >>> 32);
            return result;
        }
    }
}

