/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face;

import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;

public class FaceRegion {
    private final Direction face;
    private final BlockState blockState;
    private final boolean isEdge;
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;

    public static FaceRegion createFrom3DObjectWithFacing(Vector3d start, Vector3d end, Direction facing, BlockState blockState, boolean isEdge) {
        return new FaceRegion(facing, blockState, isEdge, facing.func_82601_c() == 0 ? start.func_82615_a() : (facing.func_82601_c() == 1 ? Math.max(start.func_82615_a(), end.func_82615_a()) : Math.min(start.func_82615_a(), end.func_82615_a())), facing.func_96559_d() == 0 ? start.func_82617_b() : (facing.func_96559_d() == 1 ? Math.max(start.func_82617_b(), end.func_82617_b()) : Math.min(start.func_82617_b(), end.func_82617_b())), facing.func_82599_e() == 0 ? start.func_82616_c() : (facing.func_82599_e() == 1 ? Math.max(start.func_82616_c(), end.func_82616_c()) : Math.min(start.func_82616_c(), end.func_82616_c())), facing.func_82601_c() == 0 ? end.func_82615_a() : (facing.func_82601_c() == 1 ? Math.max(start.func_82615_a(), end.func_82615_a()) : Math.min(start.func_82615_a(), end.func_82615_a())), facing.func_96559_d() == 0 ? end.func_82617_b() : (facing.func_96559_d() == 1 ? Math.max(start.func_82617_b(), end.func_82617_b()) : Math.min(start.func_82617_b(), end.func_82617_b())), facing.func_82599_e() == 0 ? end.func_82616_c() : (facing.func_82599_e() == 1 ? Math.max(start.func_82616_c(), end.func_82616_c()) : Math.min(start.func_82616_c(), end.func_82616_c())));
    }

    public FaceRegion(Direction facingDirection, double centerX, double centerY, double centerZ, BlockState blockState, boolean isEdgeFace) {
        this.face = facingDirection;
        this.blockState = blockState;
        this.isEdge = isEdgeFace;
        this.minX = centerX;
        this.minY = centerY;
        this.minZ = centerZ;
        this.maxX = centerX;
        this.maxY = centerY;
        this.maxZ = centerZ;
    }

    public FaceRegion(Direction face, BlockState blockState, boolean isEdge, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.face = face;
        this.blockState = blockState;
        this.isEdge = isEdge;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public boolean isEdge() {
        return this.isEdge;
    }

    public Direction getFace() {
        return this.face;
    }

    public boolean extend(FaceRegion faceToExtendTo) {
        if (faceToExtendTo.blockState != this.blockState) {
            return false;
        }
        switch (this.face) {
            case DOWN: 
            case UP: {
                boolean d;
                boolean a = this.maxX == faceToExtendTo.minX && this.maxZ == faceToExtendTo.maxZ && this.minZ == faceToExtendTo.minZ;
                boolean b = this.minX == faceToExtendTo.maxX && this.maxZ == faceToExtendTo.maxZ && this.minZ == faceToExtendTo.minZ;
                boolean c = this.maxZ == faceToExtendTo.minZ && this.maxX == faceToExtendTo.maxX && this.minX == faceToExtendTo.minX;
                boolean bl = d = this.minZ == faceToExtendTo.maxZ && this.maxX == faceToExtendTo.maxX && this.minX == faceToExtendTo.minX;
                if (a || b || c || d) {
                    this.minX = Math.min(faceToExtendTo.minX, this.minX);
                    this.minY = Math.min(faceToExtendTo.minY, this.minY);
                    this.minZ = Math.min(faceToExtendTo.minZ, this.minZ);
                    this.maxX = Math.max(faceToExtendTo.maxX, this.maxX);
                    this.maxY = Math.max(faceToExtendTo.maxY, this.maxY);
                    this.maxZ = Math.max(faceToExtendTo.maxZ, this.maxZ);
                    return true;
                }
                return false;
            }
            case WEST: 
            case EAST: {
                boolean d;
                boolean a = this.maxY == faceToExtendTo.minY && this.maxZ == faceToExtendTo.maxZ && this.minZ == faceToExtendTo.minZ;
                boolean b = this.minY == faceToExtendTo.maxY && this.maxZ == faceToExtendTo.maxZ && this.minZ == faceToExtendTo.minZ;
                boolean c = this.maxZ == faceToExtendTo.minZ && this.maxY == faceToExtendTo.maxY && this.minY == faceToExtendTo.minY;
                boolean bl = d = this.minZ == faceToExtendTo.maxZ && this.maxY == faceToExtendTo.maxY && this.minY == faceToExtendTo.minY;
                if (a || b || c || d) {
                    this.minX = Math.min(faceToExtendTo.minX, this.minX);
                    this.minY = Math.min(faceToExtendTo.minY, this.minY);
                    this.minZ = Math.min(faceToExtendTo.minZ, this.minZ);
                    this.maxX = Math.max(faceToExtendTo.maxX, this.maxX);
                    this.maxY = Math.max(faceToExtendTo.maxY, this.maxY);
                    this.maxZ = Math.max(faceToExtendTo.maxZ, this.maxZ);
                    return true;
                }
                return false;
            }
            case NORTH: 
            case SOUTH: {
                boolean d;
                boolean a = this.maxY == faceToExtendTo.minY && this.maxX == faceToExtendTo.maxX && this.minX == faceToExtendTo.minX;
                boolean b = this.minY == faceToExtendTo.maxY && this.maxX == faceToExtendTo.maxX && this.minX == faceToExtendTo.minX;
                boolean c = this.maxX == faceToExtendTo.minX && this.maxY == faceToExtendTo.maxY && this.minY == faceToExtendTo.minY;
                boolean bl = d = this.minX == faceToExtendTo.maxX && this.maxY == faceToExtendTo.maxY && this.minY == faceToExtendTo.minY;
                if (a || b || c || d) {
                    this.minX = Math.min(faceToExtendTo.minX, this.minX);
                    this.minY = Math.min(faceToExtendTo.minY, this.minY);
                    this.minZ = Math.min(faceToExtendTo.minZ, this.minZ);
                    this.maxX = Math.max(faceToExtendTo.maxX, this.maxX);
                    this.maxY = Math.max(faceToExtendTo.maxY, this.maxY);
                    this.maxZ = Math.max(faceToExtendTo.maxZ, this.maxZ);
                    return true;
                }
                return false;
            }
        }
        return false;
    }
}

