/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringStateUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private StringStateUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: StringStateUtils. This is a utility class");
    }

    public static int getStateIDFromName(String name) {
        String[] parts = name.split("[?&]");
        try {
            parts[0] = URLDecoder.decode(parts[0], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Failed to reload Property from store data : " + name, (Throwable)e);
        }
        Block blk = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0]));
        if (blk == null || blk == Blocks.field_150350_a) {
            return 0;
        }
        BlockState state = blk.func_176223_P();
        for (int x = 1; x < parts.length; ++x) {
            try {
                String[] nameValues;
                if (parts[x].length() <= 0 || (nameValues = parts[x].split("[=]")).length != 2) continue;
                nameValues[0] = URLDecoder.decode(nameValues[0], "UTF-8");
                nameValues[1] = URLDecoder.decode(nameValues[1], "UTF-8");
                state = StringStateUtils.withState(state, blk, nameValues);
                continue;
            }
            catch (Exception err) {
                LOGGER.error("Failed to reload Property from store data : " + name, (Throwable)err);
            }
        }
        return IBlockStateIdManager.getInstance().getIdFrom(state);
    }

    private static BlockState withState(BlockState state, Block blk, String[] nameval) {
        Property prop = blk.func_176194_O().func_185920_a(nameval[0]);
        if (prop == null) {
            LOGGER.info(nameval[0] + " is not a valid property for " + blk.getRegistryName());
            return state;
        }
        return StringStateUtils.setPropValue(state, prop, nameval[1]);
    }

    public static <T extends Comparable<T>> BlockState setPropValue(BlockState blockState, Property<T> property, String value) {
        Optional pv = property.func_185929_b(value);
        if (pv.isPresent()) {
            return (BlockState)blockState.func_206870_a(property, (Comparable)pv.get());
        }
        LOGGER.info(value + " is not a valid value of " + property.func_177701_a() + " for " + blockState.func_177230_c().getRegistryName());
        return blockState;
    }

    public static String getNameFromStateID(int key) {
        BlockState state = IBlockStateIdManager.getInstance().getBlockStateFrom(key);
        Block blk = state.func_177230_c();
        String sname = "air?";
        try {
            StringBuilder stateName = new StringBuilder(URLEncoder.encode(Objects.requireNonNull(blk.getRegistryName()).toString(), "UTF-8"));
            stateName.append('?');
            boolean first = true;
            for (Property p : state.func_177230_c().func_176194_O().func_177623_d()) {
                if (!first) {
                    stateName.append('&');
                }
                first = false;
                Comparable propVal = state.func_177229_b(p);
                String saveAs = propVal instanceof IStringSerializable ? ((IStringSerializable)propVal).func_176610_l() : propVal.toString();
                stateName.append(URLEncoder.encode(p.func_177701_a(), "UTF-8"));
                stateName.append('=');
                stateName.append(URLEncoder.encode(saveAs, "UTF-8"));
            }
            sname = stateName.toString();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Failed to Serialize State", (Throwable)e);
        }
        return sname;
    }
}

