/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.forge;

import com.mojang.brigadier.CommandDispatcher;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.command.DumpCommand;
import mcp.mobius.waila.forge.ForgePacketSender;
import mcp.mobius.waila.forge.ForgeWailaPlugins;
import mcp.mobius.waila.utils.DumpGenerator;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="waila")
@Mod.EventBusSubscriber(modid="waila", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeWaila
extends Waila {
    @SubscribeEvent
    static void setup(FMLCommonSetupEvent event) {
        String[] mods;
        clientSide = FMLLoader.getDist() == Dist.CLIENT;
        blockBlacklist = BlockTags.createOptional((ResourceLocation)ForgeWaila.id("blacklist"));
        entityBlacklist = EntityTypeTags.createOptional((ResourceLocation)ForgeWaila.id("blacklist"));
        configDir = FMLPaths.CONFIGDIR.get();
        ForgeWaila.init();
        packet = new ForgePacketSender();
        packet.initMain();
        plugins = new ForgeWailaPlugins();
        ModIdentification.supplier = namespace -> ModList.get().getModContainerById(namespace).map(data -> new ModIdentification.Info(data.getModId(), data.getModInfo().getDisplayName()));
        ModIdentification.itemStackSupplier = stack -> stack.func_77973_b().getCreatorModId(stack);
        for (String mod : mods = new String[]{"minecraft", "forge", "wthit", "jei"}) {
            ModList.get().getModContainerById(mod).map(ModContainer::getModInfo).ifPresent(m -> DumpGenerator.VERSIONS.put(m.getDisplayName(), m.getVersion().toString()));
        }
    }

    @SubscribeEvent
    static void loadComplete(FMLLoadCompleteEvent event) {
        plugins.initialize();
    }

    @Mod.EventBusSubscriber(modid="waila")
    static class Subscriber {
        Subscriber() {
        }

        @SubscribeEvent
        static void registerCommands(RegisterCommandsEvent event) {
            DumpCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        }

        @SubscribeEvent
        static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
            Waila.packet.sendConfig(PluginConfig.INSTANCE, (ServerPlayerEntity)event.getPlayer());
        }
    }
}

