/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.config.value;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mcp.mobius.waila.gui.config.value.OptionsEntryValue;
import mcp.mobius.waila.mixin.AccessorTextFieldWidget;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class OptionsEntryValueInput<T>
extends OptionsEntryValue<T> {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> INTEGER = s -> s.matches("[-+]?[0-9]*$");
    public static final Predicate<String> POSITIVE_INTEGER = s -> s.matches("[0-9]*$");
    public static final Predicate<String> FLOAT = s -> s.matches("[-+]?[0-9]*([.][0-9]*)?");
    public static final Predicate<String> POSITIVE_FLOAT = s -> s.matches("[0-9]*([.][0-9]*)?");
    private final TextFieldWidget textField;

    public OptionsEntryValueInput(String optionName, T value, Consumer<T> save, Predicate<String> validator) {
        super(optionName, save);
        this.value = value;
        this.textField = new WatchedTextfield(this, this.client.field_71466_p, 0, 0, 98, 18);
        this.textField.func_146180_a(String.valueOf(value));
        this.textField.func_200675_a(validator);
    }

    public OptionsEntryValueInput(String optionName, T value, Consumer<T> save) {
        this(optionName, value, save, s -> true);
    }

    @Override
    protected void drawValue(MatrixStack matrices, int entryWidth, int entryHeight, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.textField.func_212952_l(x + 135);
        this.textField.field_230691_m_ = y + entryHeight / 6;
        this.textField.func_230430_a_(matrices, mouseX, mouseY, partialTicks);
    }

    @Override
    public IGuiEventListener getListener() {
        return this.textField;
    }

    private void setValue(String text) {
        if (this.value instanceof String) {
            this.value = text;
        }
        try {
            if (this.value instanceof Integer) {
                this.value = Integer.valueOf(text);
            } else if (this.value instanceof Short) {
                this.value = Short.valueOf(text);
            } else if (this.value instanceof Byte) {
                this.value = Byte.valueOf(text);
            } else if (this.value instanceof Long) {
                this.value = Long.valueOf(text);
            } else if (this.value instanceof Double) {
                this.value = Double.valueOf(text);
            } else if (this.value instanceof Float) {
                this.value = Float.valueOf(text);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static class WatchedTextfield
    extends TextFieldWidget {
        public WatchedTextfield(OptionsEntryValueInput<?> watcher, FontRenderer fontRenderer, int x, int y, int width, int height) {
            super(fontRenderer, x, y, width, height, (ITextComponent)new StringTextComponent(""));
            this.func_212954_a(x$0 -> ((OptionsEntryValueInput)watcher).setValue(x$0));
        }

        public void func_146191_b(String string) {
            String string2;
            int l;
            AccessorTextFieldWidget self = (AccessorTextFieldWidget)((Object)this);
            int i = self.getSelectionStart() < self.getSelectionEnd() ? self.getSelectionStart() : self.getSelectionEnd();
            int j = self.getSelectionStart() < self.getSelectionEnd() ? self.getSelectionEnd() : self.getSelectionStart();
            int k = self.getMaxLength() - this.func_146179_b().length() - (i - j);
            if (k < (l = (string2 = string).length())) {
                string2 = string2.substring(0, k);
                l = k;
            }
            String string3 = new StringBuilder(this.func_146179_b()).replace(i, j, string2).toString();
            if (self.getTextPredicate().test(string3)) {
                self.set(string3);
                this.func_212422_f(i + l);
                this.func_146199_i(self.getSelectionStart());
                self.callOnChanged(this.func_146179_b());
            }
        }
    }
}

