/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.ISmeltingUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.SmeltingLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.SmeltingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.SmeltingUpgradeRenderData;

public class SmeltingUpgradeWrapper
extends UpgradeWrapperBase<SmeltingUpgradeWrapper, SmeltingUpgradeItem>
implements ITickableUpgrade,
ISmeltingUpgrade {
    private static final int NOTHING_TO_DO_COOLDOWN = 10;
    private final SmeltingLogic smeltingLogic;

    public SmeltingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.smeltingLogic = new SmeltingLogic(upgrade, upgradeSaveHandler, (Double)Config.COMMON.smeltingUpgrade.smeltingSpeedMultiplier.get(), (Double)Config.COMMON.smeltingUpgrade.fuelEfficiencyMultiplier.get());
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        if (this.isInCooldown(world)) {
            return;
        }
        if (!this.smeltingLogic.tick(world)) {
            this.setCooldown(world, 10);
        }
        boolean isBurning = this.smeltingLogic.isBurning(world);
        BackpackRenderInfo renderInfo = this.backpackWrapper.getRenderInfo();
        if (renderInfo.getUpgradeRenderData(SmeltingUpgradeRenderData.TYPE).map(SmeltingUpgradeRenderData::isBurning).orElse(false) != isBurning) {
            if (isBurning) {
                renderInfo.setUpgradeRenderData(SmeltingUpgradeRenderData.TYPE, new SmeltingUpgradeRenderData(true));
            } else {
                renderInfo.removeUpgradeRenderData(SmeltingUpgradeRenderData.TYPE);
            }
        }
    }

    @Override
    public SmeltingLogic getSmeltingLogic() {
        return this.smeltingLogic;
    }
}

