/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModFluids;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankClickMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.util.XpHelper;

public class TankInventoryPart
extends UpgradeInventoryPartBase<TankUpgradeContainer> {
    private static final TextureBlitData OVERLAY = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(47, 30), new Dimension(16, 18));
    private final Position pos;
    private final int height;
    private final BackpackScreen screen;

    public TankInventoryPart(int upgradeSlot, TankUpgradeContainer container, Position pos, int height, BackpackScreen screen) {
        super(upgradeSlot, container);
        this.pos = pos;
        this.height = height;
        this.screen = screen;
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY) {
        int i;
        GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft(), this.pos.getY(), GuiHelper.BAR_BACKGROUND_TOP);
        int yOffset = 18;
        for (i = 0; i < (this.height - 36) / 18; ++i) {
            GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft(), this.pos.getY() + yOffset, GuiHelper.BAR_BACKGROUND_MIDDLE);
            yOffset += 18;
        }
        GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft(), this.pos.getY() + yOffset, GuiHelper.BAR_BACKGROUND_BOTTOM);
        this.renderFluid(matrixStack, mouseX, mouseY);
        yOffset = 0;
        for (i = 0; i < this.height / 18; ++i) {
            GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft() + 1, this.pos.getY() + yOffset, OVERLAY);
            yOffset += 18;
        }
    }

    private int getTankLeft() {
        return this.pos.getX() + 9;
    }

    @Override
    public boolean handleMouseReleased(double mouseX, double mouseY, int button) {
        if (mouseX < (double)(this.screen.getGuiLeft() + this.getTankLeft()) || mouseX >= (double)(this.screen.getGuiLeft() + this.getTankLeft() + 18) || mouseY < (double)(this.screen.getGuiTop() + this.pos.getY()) || mouseY >= (double)(this.screen.getGuiTop() + this.pos.getY() + this.height)) {
            return false;
        }
        ClientPlayerEntity player = this.screen.getMinecraft().field_71439_g;
        ItemStack cursorStack = player.field_71071_by.func_70445_o();
        if (!cursorStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return false;
        }
        PacketHandler.sendToServer(new TankClickMessage(this.upgradeSlot));
        return true;
    }

    @Override
    public void renderErrorOverlay(MatrixStack matrixStack) {
        this.screen.renderOverlay(matrixStack, DyeColor.RED.getColorValue() | 0xAA000000, this.getTankLeft() + 1, this.pos.getY() + 1, 16, this.height - 2);
    }

    private void renderTooltip(int mouseX, int mouseY, FluidStack contents, int capacity) {
        int screenX = this.screen.getGuiLeft() + this.pos.getX() + 10;
        int screenY = this.screen.getGuiTop() + this.pos.getY() + 1;
        if (mouseX >= screenX && mouseX < screenX + 16 && mouseY >= screenY && mouseY < screenY + this.height - 2) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (!contents.isEmpty()) {
                tooltip.add(contents.getDisplayName());
            }
            tooltip.add(this.getContentsTooltip(contents, capacity));
            GuiHelper.setTooltipToRender(tooltip);
        }
    }

    private TranslationTextComponent getContentsTooltip(FluidStack contents, int capacity) {
        if (contents.getFluid().func_207185_a(ModFluids.EXPERIENCE_TAG)) {
            double contentsLevels = XpHelper.getLevelsForExperience(XpHelper.liquidToExperience(contents.getAmount()));
            double tankCapacityLevels = XpHelper.getLevelsForExperience(XpHelper.liquidToExperience(capacity));
            return new TranslationTextComponent(TranslationHelper.translUpgradeKey("tank.xp_contents_tooltip"), new Object[]{String.format("%.1f", contentsLevels), String.format("%.1f", tankCapacityLevels)});
        }
        return new TranslationTextComponent(TranslationHelper.translUpgradeKey("tank.contents_tooltip"), new Object[]{String.format("%,d", contents.getAmount()), String.format("%,d", capacity)});
    }

    private void renderFluid(MatrixStack matrixStack, int mouseX, int mouseY) {
        FluidStack contents = ((TankUpgradeContainer)this.container).getContents();
        int capacity = ((TankUpgradeContainer)this.container).getTankCapacity();
        if (contents.isEmpty()) {
            this.renderTooltip(mouseX, mouseY, FluidStack.EMPTY, capacity);
            return;
        }
        Fluid fluid = contents.getFluid();
        int fill = contents.getAmount();
        int displayLevel = (int)((float)(this.height - 2) * ((float)fill / (float)capacity));
        ResourceLocation texture = fluid.getAttributes().getStillTexture(contents);
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(texture);
        GuiHelper.renderTiledFluidTextureAtlas(matrixStack, still, fluid.getAttributes().getColor(), this.pos.getX() + 10, this.pos.getY() + 1 + this.height - 2 - displayLevel, displayLevel, this.screen.getMinecraft());
        this.renderTooltip(mouseX, mouseY, contents, capacity);
    }
}

